/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.common;

import com.google.common.base.Preconditions;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.common.HasSourceInfo;
import com.google.dart.compiler.common.SourceInfo;

public class AbstractNode
implements SourceInfo,
HasSourceInfo {
    protected Source source = null;
    protected int sourceLine = -1;
    protected int sourceColumn = -1;
    protected int sourceStart = -1;
    protected int sourceLength = -1;

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public int getSourceLine() {
        return this.sourceLine;
    }

    @Override
    public int getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    public int getSourceStart() {
        return this.sourceStart;
    }

    @Override
    public int getSourceLength() {
        return this.sourceLength;
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this;
    }

    @Override
    public void setSourceInfo(SourceInfo info) {
        this.source = info.getSource();
        this.sourceStart = info.getSourceStart();
        this.sourceLength = info.getSourceLength();
        this.sourceLine = info.getSourceLine();
        this.sourceColumn = info.getSourceColumn();
    }

    @Override
    public final void setSourceLocation(Source source, int line, int column, int startPosition, int length) {
        Preconditions.checkArgument((startPosition != -1 && length >= 0 || startPosition == -1 && length == 0 ? 1 : 0) != 0);
        this.source = source;
        this.sourceLine = line;
        this.sourceColumn = column;
        this.sourceStart = startPosition;
        this.sourceLength = length;
    }

    public final void setSourceRange(int startPosition, int length) {
        Preconditions.checkArgument((startPosition != -1 && length >= 0 || startPosition == -1 && length == 0 ? 1 : 0) != 0);
        this.sourceStart = startPosition;
        this.sourceLength = length;
    }
}

