/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;
import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.common.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsVars
extends JsStatement
implements Iterable<JsVar> {
    private final List<JsVar> vars = new ArrayList<JsVar>();

    public void add(JsVar var) {
        this.vars.add(var);
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public void insert(JsVar var) {
        this.vars.add(var);
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    @Override
    public Iterator<JsVar> iterator() {
        return this.vars.iterator();
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.vars);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.VARS;
    }

    public static class JsVar
    extends JsNode
    implements HasName {
        private final JsName name;
        private JsExpression initExpr;

        public JsVar(JsName name) {
            this.name = name;
        }

        public JsVar(JsName name, JsExpression initExpr) {
            this.name = name;
            this.initExpr = initExpr;
        }

        public JsExpression getInitExpr() {
            return this.initExpr;
        }

        @Override
        public JsName getName() {
            return this.name;
        }

        @Override
        public Symbol getSymbol() {
            return this.name;
        }

        public void setInitExpr(JsExpression initExpr) {
            this.initExpr = initExpr;
        }

        @Override
        public void traverse(JsVisitor v, JsContext ctx) {
            if (v.visit(this, ctx) && this.initExpr != null) {
                this.initExpr = v.accept(this.initExpr);
            }
            v.endVisit(this, ctx);
        }

        @Override
        public JsVar setSourceRef(SourceInfo info) {
            super.setSourceRef(info);
            return this;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.VAR;
        }
    }
}

