/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsValueLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;

public final class JsStringLiteral
extends JsValueLiteral {
    private final String value;

    JsStringLiteral(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isBooleanFalse() {
        return this.value.length() == 0;
    }

    @Override
    public boolean isBooleanTrue() {
        return this.value.length() != 0;
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.STRING;
    }
}

