/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.Lists;
import com.google.dart.compiler.util.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsScope
implements Serializable {
    private List<JsScope> children = Collections.emptyList();
    private final String description;
    private Map<String, JsName> names = Collections.emptyMap();
    private JsScope parent;
    protected int tempIndex = 0;
    private final String scopeId;
    private static Interner<String> interner = Interners.newWeakInterner();

    public JsScope(JsScope parent, String description) {
        this(parent, description, null);
    }

    public JsScope(JsScope parent, String description, String scopeId) {
        assert (parent != null);
        this.scopeId = scopeId;
        this.description = (String)interner.intern((Object)description);
        this.parent = parent;
        parent.children = Lists.add(parent.children, this);
    }

    public void rebase(JsScope newParent) {
        this.detachFromParent();
        this.parent = newParent;
        this.parent.children = Lists.add(this.parent.children, this);
    }

    public void rebaseChildScopes(JsScope newParent) {
        if (newParent == this) {
            return;
        }
        this.parent.children = Lists.addAll(this.parent.children, this.children);
        for (JsScope child : this.children) {
            child.parent = newParent;
        }
        this.children = Collections.emptyList();
    }

    protected void detachFromParent() {
        JsScope oldParent = this.parent;
        oldParent.children = Lists.remove(this.parent.children, oldParent.children.indexOf(this));
        this.parent = null;
    }

    protected JsScope(String description) {
        this.description = description;
        this.parent = null;
        this.scopeId = null;
    }

    public JsName declareName(String ident) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name != null) {
            return name;
        }
        return this.doCreateName(ident, ident, ident);
    }

    public JsName declareFreshName(String shortName) {
        String ident = shortName;
        int counter = 0;
        while (this.findExistingNameNoRecurse(ident) != null) {
            ident = shortName + "_" + counter++;
        }
        return this.doCreateName(ident, shortName, shortName);
    }

    String getNextTempName() {
        return "tmp$" + (this.scopeId != null ? this.scopeId + "$" : "") + this.tempIndex++;
    }

    public JsName declareTemporary() {
        return this.declareFreshName(this.getNextTempName());
    }

    public JsName declareName(String ident, String shortIdent) {
        return this.declareName(ident, shortIdent, ident);
    }

    public JsName declareName(String ident, String shortIdent, String originalName) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name != null) {
            if (!name.getShortIdent().equals(shortIdent) || !this.nullableEquals(name.getOriginalName(), originalName)) {
                throw new IllegalArgumentException("Requested short name " + shortIdent + " conflicts with preexisting short name " + name.getShortIdent() + " for identifier " + ident);
            }
            return name;
        }
        return this.doCreateName(ident, shortIdent, originalName);
    }

    boolean nullableEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public final JsName findExistingName(String ident) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name == null && this.parent != null) {
            return this.parent.findExistingName(ident);
        }
        return name;
    }

    public final JsName findExistingUnobfuscatableName(String ident) {
        JsName name = this.findExistingNameNoRecurse(ident);
        if (name != null && name.isObfuscatable()) {
            name = null;
        }
        if (name == null && this.parent != null) {
            return this.parent.findExistingUnobfuscatableName(ident);
        }
        return name;
    }

    public Iterator<JsName> getAllNames() {
        return this.names.values().iterator();
    }

    public final List<JsScope> getChildren() {
        return this.children;
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    protected JsName doCreateName(String ident, String shortIdent, String originalName) {
        JsName name = new JsName(this, ident, shortIdent, originalName);
        this.names = Maps.putOrdered(this.names, ident, name);
        return name;
    }

    protected JsName findExistingNameNoRecurse(String ident) {
        return this.names.get(ident);
    }
}

