/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.CanBooleanEval;
import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;
import com.google.dart.compiler.common.Symbol;

public final class JsNameRef
extends JsExpression
implements CanBooleanEval,
HasName {
    private String ident;
    private JsName name;
    private JsExpression qualifier;

    public JsNameRef(JsName name) {
        this.name = name;
    }

    public JsNameRef(String ident) {
        this.ident = ident;
    }

    public String getIdent() {
        return this.name == null ? this.ident : this.name.getIdent();
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @Override
    public Symbol getSymbol() {
        return this.name;
    }

    public JsExpression getQualifier() {
        return this.qualifier;
    }

    public String getShortIdent() {
        return this.name == null ? this.ident : this.name.getShortIdent();
    }

    @Override
    public boolean hasSideEffects() {
        if (this.qualifier == null) {
            return false;
        }
        if (!this.qualifier.isDefinitelyNotNull()) {
            return true;
        }
        return this.qualifier.hasSideEffects();
    }

    @Override
    public boolean isBooleanFalse() {
        return this.isDefinitelyNull();
    }

    @Override
    public boolean isBooleanTrue() {
        return false;
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return false;
    }

    @Override
    public boolean isDefinitelyNull() {
        if (this.name != null) {
            return this.name.getEnclosing().getProgram().getUndefinedLiteral().getName() == this.name;
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.qualifier == null;
    }

    public boolean isResolved() {
        return this.name != null;
    }

    public void resolve(JsName name) {
        this.name = name;
        this.ident = null;
    }

    public void setQualifier(JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx) && this.qualifier != null) {
            this.qualifier = v.accept(this.qualifier);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.NAME_REF;
    }
}

