/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.common.Symbol;
import java.io.Serializable;

public class JsName
implements Symbol,
Serializable {
    private final JsScope enclosing;
    private final String ident;
    private boolean isObfuscatable;
    private String shortIdent;
    private String originalName;
    private JsNode staticRef;

    JsName(JsScope enclosing, String ident, String shortIdent, String originalName) {
        this.enclosing = enclosing;
        this.ident = ident;
        this.shortIdent = shortIdent;
        if (originalName != null) {
            this.originalName = originalName;
        }
        this.isObfuscatable = true;
    }

    public JsScope getEnclosing() {
        return this.enclosing;
    }

    public String getIdent() {
        return this.ident;
    }

    public String getShortIdent() {
        return this.shortIdent;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public JsNode getStaticRef() {
        return this.staticRef;
    }

    public boolean isObfuscatable() {
        return this.isObfuscatable;
    }

    public JsNameRef makeRef() {
        return new JsNameRef(this);
    }

    public void setObfuscatable(boolean isObfuscatable) {
        this.isObfuscatable = isObfuscatable;
    }

    public void setShortIdent(String shortIdent) {
        this.shortIdent = shortIdent;
    }

    public void setStaticRef(JsNode node) {
        this.staticRef = node;
    }

    public String toString() {
        return this.ident;
    }

    @Override
    public String getOriginalSymbolName() {
        return this.getOriginalName();
    }

    public int hashCode() {
        return this.ident.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsName)) {
            return false;
        }
        JsName other = (JsName)obj;
        return this.ident.equals(other.ident) && this.enclosing == other.enclosing;
    }

    @Override
    public DartNode getNode() {
        throw new UnsupportedOperationException();
    }
}

