/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsModVisitor;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;
import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.common.Symbol;
import java.util.ArrayList;
import java.util.List;

public final class JsFunction
extends JsLiteral
implements HasName {
    protected JsBlock body;
    protected final List<JsParameter> params = new ArrayList<JsParameter>();
    protected final JsScope scope;
    private boolean artificiallyRescued;
    private boolean executeOnce;
    private boolean fromDart;
    private JsFunction impliedExecute;
    private JsName name;
    private boolean trace = false;
    private boolean traceFirst = true;
    private boolean hoisted = false;
    private boolean constructor = false;

    private static void trace(String title, String code) {
        System.out.println("---------------------------");
        System.out.println(title + ":");
        System.out.println("---------------------------");
        System.out.println(code);
    }

    public JsFunction(JsScope parent) {
        this(parent, null, false);
    }

    public JsFunction(JsScope parent, JsName name) {
        this(parent, name, false);
    }

    public JsFunction(JsScope parent, JsName name, boolean fromDart) {
        assert (parent != null);
        this.fromDart = fromDart;
        this.setName(name);
        String scopeName = name == null ? "<anonymous>" : name.getIdent();
        scopeName = "function " + scopeName;
        this.scope = new JsScope(parent, scopeName);
    }

    public JsBlock getBody() {
        return this.body;
    }

    public boolean getExecuteOnce() {
        return this.executeOnce;
    }

    public JsFunction getImpliedExecute() {
        return this.impliedExecute;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @Override
    public Symbol getSymbol() {
        return this.name;
    }

    public List<JsParameter> getParameters() {
        return this.params;
    }

    public JsScope getScope() {
        return this.scope;
    }

    @Override
    public boolean hasSideEffects() {
        return this.name != null;
    }

    public boolean isArtificiallyRescued() {
        return this.artificiallyRescued;
    }

    @Override
    public boolean isBooleanFalse() {
        return false;
    }

    @Override
    public boolean isBooleanTrue() {
        return true;
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    public boolean isFromDart() {
        return this.fromDart;
    }

    public void setArtificiallyRescued(boolean rescued) {
        this.artificiallyRescued = rescued;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    public void setExecuteOnce(boolean executeOnce) {
        this.executeOnce = executeOnce;
    }

    public void setFromDart(boolean fromDart) {
        this.fromDart = fromDart;
    }

    public void setImpliedExecute(JsFunction impliedExecute) {
        this.impliedExecute = impliedExecute;
    }

    public void setName(JsName name) {
        this.name = name;
        if (name != null && this.isFromDart()) {
            name.setStaticRef(this);
        }
    }

    public void setTrace() {
        this.trace = true;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        String after;
        String before = null;
        if (this.trace && v instanceof JsModVisitor) {
            before = this.toSource();
            if (this.traceFirst) {
                this.traceFirst = false;
                JsFunction.trace("SCRIPT INITIAL", before);
            }
        }
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.params);
            this.body = v.accept(this.body);
        }
        v.endVisit(this, ctx);
        if (this.trace && v instanceof JsModVisitor && !(after = this.toSource()).equals(before)) {
            String title = v.getClass().getSimpleName();
            JsFunction.trace(title, after);
        }
    }

    public void setHoisted() {
        this.hoisted = true;
    }

    public boolean isHoisted() {
        return this.hoisted;
    }

    public void rebaseScope(JsScope newScopeParent) {
        this.scope.rebase(newScopeParent);
    }

    @Override
    public JsFunction setSourceRef(SourceInfo info) {
        super.setSourceRef(info);
        return this;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public boolean setIsConstructor(boolean constructor) {
        this.constructor = constructor;
        return this.constructor;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.FUNCTION;
    }
}

