/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;

public final class JsConditional
extends JsExpression {
    private JsExpression elseExpr;
    private JsExpression testExpr;
    private JsExpression thenExpr;

    public JsConditional() {
    }

    public JsConditional(JsExpression testExpr, JsExpression thenExpr, JsExpression elseExpr) {
        this.testExpr = testExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public JsExpression getElseExpression() {
        return this.elseExpr;
    }

    public JsExpression getTestExpression() {
        return this.testExpr;
    }

    public JsExpression getThenExpression() {
        return this.thenExpr;
    }

    @Override
    public boolean hasSideEffects() {
        return this.testExpr.hasSideEffects() || this.thenExpr.hasSideEffects() || this.elseExpr.hasSideEffects();
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return this.thenExpr.isDefinitelyNotNull() && this.elseExpr.isDefinitelyNotNull();
    }

    @Override
    public boolean isDefinitelyNull() {
        return this.thenExpr.isDefinitelyNull() && this.elseExpr.isDefinitelyNull();
    }

    public void setElseExpression(JsExpression elseExpr) {
        this.elseExpr = elseExpr;
    }

    public void setTestExpression(JsExpression testExpr) {
        this.testExpr = testExpr;
    }

    public void setThenExpression(JsExpression thenExpr) {
        this.thenExpr = thenExpr;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.testExpr = v.accept(this.testExpr);
            this.thenExpr = v.accept(this.thenExpr);
            this.elseExpr = v.accept(this.elseExpr);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.CONDITIONAL;
    }
}

