/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsScope;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JsCatchScope
extends JsScope {
    private final JsName name;

    public JsCatchScope(JsScope parent, String ident) {
        super(parent, "Catch scope");
        this.name = new JsName(this, ident, ident, ident);
    }

    @Override
    public JsName declareName(String ident) {
        return this.getParent().declareName(ident);
    }

    @Override
    public JsName declareName(String ident, String shortIdent) {
        return this.getParent().declareName(ident, shortIdent);
    }

    @Override
    public Iterator<JsName> getAllNames() {
        return new Iterator<JsName>(){
            private boolean didIterate = false;

            @Override
            public boolean hasNext() {
                return !this.didIterate;
            }

            @Override
            public JsName next() {
                if (this.didIterate) {
                    throw new NoSuchElementException();
                }
                this.didIterate = true;
                return JsCatchScope.this.name;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected JsName doCreateName(String ident, String shortIdent, String originalName) {
        throw new UnsupportedOperationException("Cannot create a name in a catch scope");
    }

    @Override
    protected JsName findExistingNameNoRecurse(String ident) {
        if (this.name.getIdent().equals(ident)) {
            return this.name;
        }
        return null;
    }
}

