/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasCondition;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatchScope;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;

public class JsCatch
extends JsNode
implements HasCondition {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(JsScope parent, String ident) {
        assert (parent != null);
        this.scope = new JsCatchScope(parent, ident);
        this.param = new JsParameter(this.scope.findExistingName(ident));
    }

    public JsBlock getBody() {
        return this.body;
    }

    @Override
    public JsExpression getCondition() {
        return this.condition;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    @Override
    public void setCondition(JsExpression condition) {
        this.condition = condition;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.param = v.accept(this.param);
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            this.body = v.accept(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.CATCH;
    }
}

