/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.NodeKind;
import java.util.ArrayList;
import java.util.List;

public final class JsArrayLiteral
extends JsLiteral {
    private final List<JsExpression> exprs = new ArrayList<JsExpression>();

    public List<JsExpression> getExpressions() {
        return this.exprs;
    }

    @Override
    public boolean hasSideEffects() {
        for (JsExpression expr : this.exprs) {
            if (!expr.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBooleanFalse() {
        return false;
    }

    @Override
    public boolean isBooleanTrue() {
        return true;
    }

    @Override
    public boolean isDefinitelyNotNull() {
        return true;
    }

    @Override
    public boolean isDefinitelyNull() {
        return false;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.exprs);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY;
    }
}

