/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.analysis;

import com.google.dart.compiler.backend.js.analysis.JavascriptElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;

class TopLevelElementIndexer
implements NodeVisitor {
    private static final String RUN_ENTRY_METHOD_NAME = "RunEntry";
    private final List<AstNode> entryPoints = new ArrayList<AstNode>();
    private final List<AstNode> globals;
    private final Map<String, List<JavascriptElement>> namesToElements;

    public static void printGlobals(List<AstNode> globals) {
        System.out.println("Globals");
        for (AstNode global : globals) {
            System.out.println("--------");
            System.out.println(global.toSource());
            System.out.println();
        }
    }

    public static void printNamesToElements(Map<String, List<JavascriptElement>> namesToElements) {
        long rttCost = 0L;
        long namedCost = 0L;
        long ctorCost = 0L;
        Set<Map.Entry<String, List<JavascriptElement>>> entrySet = namesToElements.entrySet();
        for (Map.Entry<String, List<JavascriptElement>> entry : entrySet) {
            System.out.println("--------");
            System.out.println("Name: " + entry.getKey());
            for (JavascriptElement javascriptElement : entry.getValue()) {
                AstNode node = javascriptElement.getNode();
                if (node == null) continue;
                System.out.println("Type: " + Token.typeToName((int)node.getType()));
                if (javascriptElement.getInheritsElement() != null) {
                    System.out.println("Inherits: " + javascriptElement.getInheritsElement());
                }
                try {
                    System.out.println(node.toSource());
                }
                catch (Exception e) {
                    System.out.println("Failed to print node source code");
                }
                String name = javascriptElement.getName();
                if (name.endsWith("$named")) {
                    namedCost += (long)node.getLength();
                    continue;
                }
                if (name.endsWith("$addTo") || name.endsWith("$lookupRTT") || name.endsWith("$RTTimplements")) {
                    rttCost += (long)node.getLength();
                    continue;
                }
                if (!name.endsWith("$Constructor") && !name.endsWith("$Initializer")) continue;
                ctorCost += (long)node.getLength();
            }
            System.out.println();
        }
        System.out.println(ctorCost + " characters worth of $Constructor and $Initializer methode declarations");
        System.out.println(namedCost + " characters worth of $named methods declarations");
        System.out.println(rttCost + " characters worth of RTT method declarations");
    }

    public TopLevelElementIndexer(Map<String, List<JavascriptElement>> namesToElements, List<AstNode> globals) {
        this.globals = globals;
        this.namesToElements = namesToElements;
    }

    private void addElement(String identifier, JavascriptElement javascriptElement) {
        List<JavascriptElement> list = this.namesToElements.get(identifier);
        if (list == null) {
            list = new ArrayList<JavascriptElement>(1);
            this.namesToElements.put(identifier, list);
        }
        list.add(javascriptElement);
    }

    private void processGlobal(AstNode node) {
        FunctionCall functionCall;
        AstNode target;
        ExpressionStatement expressionStatement;
        AstNode expression;
        if (node.getType() == 134 && (expression = (expressionStatement = (ExpressionStatement)node).getExpression()).getType() == 38 && (target = (functionCall = (FunctionCall)expression).getTarget()).getType() == 39) {
            Name targetName = (Name)target;
            if (RUN_ENTRY_METHOD_NAME.equals(targetName.getIdentifier())) {
                this.entryPoints.add(node);
                return;
            }
            if ("$inherits".equals(targetName.getIdentifier())) {
                List arguments = functionCall.getArguments();
                assert (arguments.size() == 2);
                assert (((AstNode)arguments.get(0)).getType() == 39);
                assert (((AstNode)arguments.get(1)).getType() == 39);
                Name subtype = (Name)arguments.get(0);
                Name supertype = (Name)arguments.get(1);
                List<JavascriptElement> subTypeFunctions = this.namesToElements.get(subtype.getIdentifier());
                assert (subTypeFunctions != null && subTypeFunctions.size() == 1);
                JavascriptElement subtypeFunction = subTypeFunctions.get(0);
                subtypeFunction.setInheritsNode(node);
                subtypeFunction.setInherits(this.namesToElements.get(supertype.getIdentifier()).get(0));
                return;
            }
        }
        this.globals.add(node);
    }

    public List<AstNode> getEntryPoints() {
        return this.entryPoints;
    }

    public boolean visit(AstNode node) {
        if (node == node.getAstRoot()) {
            return true;
        }
        switch (node.getType()) {
            case 133: 
            case 134: {
                ExpressionStatement expressionStatement = (ExpressionStatement)node;
                AstNode expression = expressionStatement.getExpression();
                if (expression.getType() == 90) {
                    Assignment assignment = (Assignment)expression;
                    NameLocator nameLocator = new NameLocator();
                    assignment.getLeft().visit((NodeVisitor)nameLocator);
                    String enclosingTypeName = nameLocator.getEnclosingTypeName();
                    JavascriptElement enclosingElement = null;
                    if (enclosingTypeName != null) {
                        List<JavascriptElement> list = this.namesToElements.get(enclosingTypeName);
                        if (list == null) {
                            enclosingElement = new JavascriptElement(null, false, enclosingTypeName, nameLocator.getName(), null);
                            this.addElement(enclosingTypeName, enclosingElement);
                        } else {
                            assert (list != null && list.size() == 1);
                            enclosingElement = list.get(0);
                        }
                    }
                    JavascriptElement javascriptElement = new JavascriptElement(enclosingElement, nameLocator.hasPrototypeInName(), nameLocator.getQualifiedName(), nameLocator.getName(), node);
                    for (String identifier : nameLocator.getPossibleNames()) {
                        this.addElement(identifier, javascriptElement);
                    }
                    break;
                }
                this.processGlobal(node);
                break;
            }
            case 109: {
                FunctionNode functionNode = (FunctionNode)node;
                String name = functionNode.getName();
                if (name == null || name.isEmpty()) break;
                this.addElement(name, new JavascriptElement(null, false, name, name, node));
                break;
            }
            case 122: {
                VariableDeclaration variableDeclaration = (VariableDeclaration)node;
                List variables = variableDeclaration.getVariables();
                for (VariableInitializer variable : variables) {
                    AstNode target = variable.getTarget();
                    if (target.getType() != 39) continue;
                    Name variableName = (Name)target;
                    this.addElement(variableName.getIdentifier(), new JavascriptElement(null, false, variableName.getIdentifier(), variableName.getIdentifier(), node));
                }
                break;
            }
            default: {
                this.processGlobal(node);
            }
        }
        return false;
    }

    static class NameLocator
    implements NodeVisitor {
        private static final int PROTOTYPE_DEFAULT_INDEX = -1;
        private final Deque<String> identifiers = new LinkedList<String>();
        private int prototypeIndex = -1;

        NameLocator() {
        }

        public String getEnclosingTypeName() {
            return this.identifiers.getFirst();
        }

        public String getName() {
            return this.identifiers.getLast();
        }

        public Collection<String> getPossibleNames() {
            ArrayList<String> names = new ArrayList<String>(2);
            if (this.hasPrototypeInName()) {
                names.add(this.identifiers.getLast());
            }
            names.add(this.getQualifiedName());
            return names;
        }

        public String getQualifiedName() {
            StringBuffer sb = new StringBuffer();
            Iterator<String> iterator = this.identifiers.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(".");
            }
            return sb.toString();
        }

        public boolean hasPrototypeInName() {
            return this.prototypeIndex != -1;
        }

        public boolean visit(AstNode node) {
            if (node.getType() == 39) {
                Name name = (Name)node;
                String identifier = name.getIdentifier();
                if ("prototype".equals(identifier)) {
                    this.prototypeIndex = this.identifiers.size();
                }
                this.identifiers.add(identifier);
            }
            return true;
        }
    }
}

