/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.analysis;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;

class JavascriptElement {
    private final JavascriptElement enclosingElement;
    private JavascriptElement inheritsElement;
    private JavascriptElement inheritsInvocation;
    private boolean instantiated;
    private final boolean isVirtual;
    private List<JavascriptElement> members = null;
    private final String name;
    private final AstNode node;
    private final String qualifiedName;

    public JavascriptElement(JavascriptElement enclosingElement, boolean isVirtual, String qualifiedName, String name, AstNode node) {
        this.enclosingElement = enclosingElement;
        this.isVirtual = isVirtual;
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.node = node;
        if (enclosingElement != null) {
            enclosingElement.addMember(this);
        }
    }

    private void addMember(JavascriptElement javascriptElement) {
        if (this.members == null) {
            this.members = new LinkedList<JavascriptElement>();
        }
        this.members.add(javascriptElement);
    }

    public JavascriptElement getEnclosingElement() {
        return this.enclosingElement;
    }

    public JavascriptElement getInheritsElement() {
        return this.inheritsElement;
    }

    public JavascriptElement getInheritsInvocation() {
        return this.inheritsInvocation;
    }

    public int getLength() {
        return this.node.getLength();
    }

    public List<JavascriptElement> getMembers() {
        if (this.members == null) {
            return Collections.emptyList();
        }
        return this.members;
    }

    public String getName() {
        return this.name;
    }

    public AstNode getNode() {
        return this.node;
    }

    public int getOffset() {
        return this.node.getAbsolutePosition();
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public boolean isInstantiated() {
        return this.instantiated || this.isNative();
    }

    public boolean isNative() {
        return this.getNode() == null;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setInherits(JavascriptElement inherits) {
        this.inheritsElement = inherits;
    }

    public void setInheritsNode(AstNode inheritsNode) {
        this.inheritsInvocation = new JavascriptElement(null, false, "", "", inheritsNode);
    }

    public void setInstantiated(boolean instantiated) {
        this.instantiated = instantiated;
        if (this.inheritsElement != null) {
            this.inheritsElement.setInstantiated(instantiated);
        }
    }
}

