/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.backend.js.DartMangler;
import com.google.dart.compiler.backend.js.GenerateNamesAndScopes;
import com.google.dart.compiler.backend.js.JsNameProvider;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.LibraryElement;
import java.util.HashMap;
import java.util.Map;

public class TranslationContext {
    private final DartMangler mangler;
    private final Map<Element, JsScope> memberScopes = new HashMap<Element, JsScope>();
    private final Map<DartFunction, JsFunction> methods = new HashMap<DartFunction, JsFunction>();
    private final JsNameProvider names;
    private final JsProgram program;

    private TranslationContext(JsProgram program, DartMangler mangler) {
        this.program = program;
        this.mangler = mangler;
        this.names = new JsNameProvider(program, mangler);
    }

    public DartMangler getMangler() {
        return this.mangler;
    }

    public Map<Element, JsScope> getMemberScopes() {
        return this.memberScopes;
    }

    public Map<DartFunction, JsFunction> getMethods() {
        return this.methods;
    }

    public JsNameProvider getNames() {
        return this.names;
    }

    public JsProgram getProgram() {
        return this.program;
    }

    public static TranslationContext createContext(DartUnit unit, JsProgram program, DartMangler mangler, DartNode filterNode) {
        TranslationContext translationContext = new TranslationContext(program, mangler);
        LibraryElement unitLibrary = unit.getLibrary().getElement();
        GenerateNamesAndScopes visitor = new GenerateNamesAndScopes(translationContext, unitLibrary);
        if (filterNode != null) {
            visitor.accept(filterNode);
        } else {
            visitor.accept(unit);
        }
        return translationContext;
    }
}

