/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.dart.compiler.InternalCompilerException;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartClassMember;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.backend.js.Cloner;
import com.google.dart.compiler.backend.js.DartMangler;
import com.google.dart.compiler.backend.js.TranslationContext;
import com.google.dart.compiler.backend.js.TraversalContextProvider;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThisRef;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.ConstructorElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.DynamicElement;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FunctionAliasElementImplementation;
import com.google.dart.compiler.resolver.LibraryElement;
import com.google.dart.compiler.resolver.MethodElement;
import com.google.dart.compiler.resolver.VariableElement;
import com.google.dart.compiler.type.FunctionAliasType;
import com.google.dart.compiler.type.FunctionType;
import com.google.dart.compiler.type.InterfaceType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeKind;
import com.google.dart.compiler.type.TypeVariable;
import com.google.dart.compiler.type.Types;
import com.google.dart.compiler.util.AstUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuntimeTypeInjector {
    private final boolean emitTypeChecks;
    private final TraversalContextProvider context;
    private final JsBlock globalBlock;
    private final JsScope globalScope;
    private final Map<ClassElement, String> builtInTypeChecks;
    private CoreTypeProvider typeProvider;
    private final TranslationContext translationContext;
    private final Types types;
    private final DartMangler mangler;
    private final LibraryElement unitLibrary;
    private static final String RTT_DYNAMIC_LOOKUP = "RTT.dynamicType.$lookupRTT";
    private static final String RTT_NAMED_PARAMETER = "named";

    RuntimeTypeInjector(TraversalContextProvider context, CoreTypeProvider typeProvider, TranslationContext translationContext, boolean emitTypeChecks, DartMangler mangler, LibraryElement unitLibrary) {
        this.context = context;
        this.translationContext = translationContext;
        JsProgram program = translationContext.getProgram();
        this.globalBlock = program.getGlobalBlock();
        this.globalScope = program.getScope();
        this.builtInTypeChecks = this.makeBuiltinTypes(typeProvider);
        this.typeProvider = typeProvider;
        this.emitTypeChecks = emitTypeChecks;
        this.mangler = mangler;
        this.unitLibrary = unitLibrary;
        this.types = Types.getInstance(typeProvider);
    }

    private Map<ClassElement, String> makeBuiltinTypes(CoreTypeProvider typeProvider) {
        HashMap builtinTypes = Maps.newHashMap();
        builtinTypes.put(typeProvider.getBoolType().getElement(), "$isBool");
        builtinTypes.put(typeProvider.getIntType().getElement(), "$isNum");
        builtinTypes.put(typeProvider.getDoubleType().getElement(), "$isNum");
        builtinTypes.put(typeProvider.getStringType().getElement(), "$isString");
        return builtinTypes;
    }

    void generateRuntimeTypeInfo(DartClass x) {
        this.generateRuntimeTypeInfoMethods(x);
        ClassElement classElement = x.getSymbol();
        if (!classElement.isInterface()) {
            this.injectInterfaceMarkers(classElement, x);
        }
    }

    void generateRuntimeTypeInfo(DartFunctionTypeAlias x) {
        this.generateRTTLookupMethod(x);
    }

    void generateRuntimeTypeInfo(DartMethodDefinition x) {
        this.generateRTTLookupMethod(x);
    }

    void generateRuntimeTypeInfo(DartFunctionExpression x, String lookupName) {
        this.generateRTTLookupMethod(x, lookupName);
    }

    private void injectInterfaceMarkers(ClassElement classElement, SourceInfo srcRef) {
        JsProgram program = this.translationContext.getProgram();
        JsName classJsName = this.translationContext.getNames().getName(classElement);
        for (InterfaceType iface : this.getAllInterfaces(classElement)) {
            JsStatement assignment = (JsStatement)AstUtil.newAssignment(AstUtil.newNameRef((JsExpression)AstUtil.newNameRef((JsExpression)new JsNameRef(classJsName), "prototype"), "$implements$" + this.translationContext.getMangler().mangleClassName(iface.getElement())), (JsExpression)program.getNumberLiteral(1.0)).makeStmt().setSourceRef(srcRef);
            this.globalBlock.getStatements().add(assignment);
        }
    }

    private Set<InterfaceType> getAllInterfaces(ClassElement classElement) {
        LinkedHashSet interfaces = Sets.newLinkedHashSet();
        if (classElement.getType() == null) {
            throw new InternalCompilerException("type is null on ClassElement " + classElement);
        }
        interfaces.add(classElement.getType());
        InterfaceType current = classElement.getType();
        if (current != null) {
            this.addAllInterfaces(interfaces, current);
        }
        return interfaces;
    }

    private void addAllInterfaces(Set<InterfaceType> interfaces, InterfaceType t) {
        interfaces.add(t);
        for (InterfaceType current : t.getElement().getInterfaces()) {
            this.addAllInterfaces(interfaces, current);
        }
    }

    private void generateRuntimeTypeInfoMethods(DartClass x) {
        this.generateRTTLookupMethod(x);
        ClassElement classElement = x.getSymbol();
        if (this.hasRTTImplements(classElement)) {
            this.generateRTTImplementsMethod(x);
        }
        this.generateRTTAddToMethod(x);
    }

    private void generateRTTLookupMethod(DartClass x) {
        ClassElement classElement = x.getSymbol();
        boolean hasTypeParams = this.hasTypeParameters(classElement);
        JsFunction lookupFn = new JsFunction(this.globalScope);
        lookupFn.setBody(new JsBlock());
        List<JsStatement> body = lookupFn.getBody().getStatements();
        JsScope scope = new JsScope(this.globalScope, "temp");
        JsProgram program = this.translationContext.getProgram();
        JsInvocation invokeCreate = AstUtil.call(null, AstUtil.newQualifiedNameRef("RTT.create"), this.getRTTClassId(classElement));
        List<JsExpression> callArgs = invokeCreate.getArguments();
        if (this.hasRTTImplements(classElement)) {
            callArgs.add(this.getRTTImplementsMethodName(classElement));
        } else {
            callArgs.add(program.getNullLiteral());
        }
        JsName typeArgs = scope.declareName("typeArgs");
        lookupFn.getParameters().add(new JsParameter(typeArgs));
        if (hasTypeParams) {
            callArgs.add(typeArgs.makeRef());
        } else {
            callArgs.add(program.getNullLiteral());
        }
        JsName named = scope.declareName(RTT_NAMED_PARAMETER);
        lookupFn.getParameters().add(new JsParameter(named));
        callArgs.add(named.makeRef());
        body.add(new JsReturn(invokeCreate));
        JsExpression fnDecl = AstUtil.assign(null, this.getRTTLookupMethodNameRef(classElement), lookupFn);
        this.globalBlock.getStatements().add(fnDecl.makeStmt());
    }

    private void generateRTTImplementsMethod(DartClass x) {
        ClassElement classElement = x.getSymbol();
        boolean hasTypeParams = classElement.getTypeParameters().size() > 0;
        JsFunction implementsFn = new JsFunction(this.globalScope);
        implementsFn.setBody(new JsBlock());
        List<JsStatement> body = implementsFn.getBody().getStatements();
        JsScope scope = new JsScope(this.globalScope, "temp");
        JsName rtt = scope.declareName("rtt");
        implementsFn.getParameters().add(new JsParameter(rtt));
        JsName typeArgs = null;
        if (hasTypeParams) {
            typeArgs = scope.declareName("typeArgs");
            implementsFn.getParameters().add(new JsParameter(typeArgs));
        }
        JsInvocation callAddTo = AstUtil.newInvocation(this.getRTTAddToMethodName(classElement), rtt.makeRef());
        if (hasTypeParams) {
            typeArgs = scope.declareName("typeArgs");
            callAddTo.getArguments().add(typeArgs.makeRef());
        }
        body.add(callAddTo.makeStmt());
        if (hasTypeParams) {
            JsArrayLiteral derivedTypesArray = new JsArrayLiteral();
            JsExpression addDerivedTypes = AstUtil.assign(null, AstUtil.nameref(null, rtt.makeRef(), "derivedTypes"), derivedTypesArray);
            body.add(addDerivedTypes.makeStmt());
        }
        JsExpression fnDecl = AstUtil.assign(null, this.getRTTImplementsMethodName(classElement), implementsFn);
        this.globalBlock.getStatements().add(fnDecl.makeStmt());
    }

    private void generateRTTAddToMethod(DartClass x) {
        ClassElement classElement = x.getSymbol();
        JsFunction addToFn = new JsFunction(this.globalScope);
        addToFn.setBody(new JsBlock());
        JsScope scope = new JsScope(this.globalScope, "temp");
        JsName targetType = scope.declareName("target");
        addToFn.getParameters().add(new JsParameter(targetType));
        JsName rtt = scope.declareName("rtt");
        List<JsStatement> body = addToFn.getBody().getStatements();
        JsInvocation callLookup = AstUtil.newInvocation(this.getRTTLookupMethodNameRef(classElement), new JsExpression[0]);
        if (this.hasTypeParameters(classElement)) {
            JsName typeArgs = scope.declareName("typeArgs");
            addToFn.getParameters().add(new JsParameter(typeArgs));
            callLookup.getArguments().add(new JsNameRef(typeArgs));
        }
        JsVars rttLookup = AstUtil.newVar(null, rtt, callLookup);
        body.add(rttLookup);
        JsBinaryOperation addToTypes = AstUtil.newAssignment(new JsArrayAccess(AstUtil.newNameRef((JsExpression)targetType.makeRef(), "implementedTypes"), AstUtil.newNameRef((JsExpression)rtt.makeRef(), "classKey")), (JsExpression)rtt.makeRef());
        body.add(addToTypes.makeStmt());
        InterfaceType superType = classElement.getSupertype();
        if (superType != null && !superType.getElement().isObject()) {
            ClassElement interfaceElement = superType.getElement();
            JsInvocation callAddTo = AstUtil.newInvocation(this.getRTTAddToMethodName(interfaceElement), targetType.makeRef());
            if (this.hasTypeParameters(interfaceElement) && !superType.hasDynamicTypeArgs()) {
                JsArrayLiteral superTypeArgs = new JsArrayLiteral();
                List<? extends Type> typeParams = classElement.getTypeParameters();
                for (Type type : superType.getArguments()) {
                    superTypeArgs.getExpressions().add(this.buildTypeLookupExpression(type, typeParams, AstUtil.nameref(null, targetType.makeRef(), "typeArgs")));
                }
                callAddTo.getArguments().add(superTypeArgs);
            }
            body.add(callAddTo.makeStmt());
        }
        for (InterfaceType interfaceType : classElement.getInterfaces()) {
            ClassElement interfaceElement = interfaceType.getElement();
            if (interfaceElement instanceof DynamicElement) continue;
            JsInvocation callAddTo = AstUtil.call(null, this.getRTTAddToMethodName(interfaceElement), targetType.makeRef());
            if (this.hasTypeParameters(interfaceElement) && !interfaceType.hasDynamicTypeArgs()) {
                JsArrayLiteral interfaceTypeArgs = new JsArrayLiteral();
                List<? extends Type> list = classElement.getTypeParameters();
                for (Type type : interfaceType.getArguments()) {
                    interfaceTypeArgs.getExpressions().add(this.buildTypeLookupExpression(type, list, AstUtil.nameref(null, targetType.makeRef(), "typeArgs")));
                }
                callAddTo.getArguments().add(interfaceTypeArgs);
            }
            body.add(callAddTo.makeStmt());
        }
        JsBinaryOperation fnDecl = AstUtil.newAssignment(this.getRTTAddToMethodName(classElement), (JsExpression)addToFn);
        this.globalBlock.getStatements().add(fnDecl.makeStmt());
    }

    private void generateRTTLookupMethod(DartMethodDefinition x) {
        this.generateRTTLookupMethod(x.getSymbol(), null);
    }

    private void generateRTTLookupMethod(DartFunctionExpression x, String overrideName) {
        this.generateRTTLookupMethod(x.getSymbol(), overrideName);
    }

    private ClassElement getEnclosingClassElement(EnclosingElement enclosingElement) {
        while (enclosingElement != null) {
            if (enclosingElement.getKind().equals((Object)ElementKind.CLASS)) {
                return (ClassElement)enclosingElement;
            }
            enclosingElement = enclosingElement.getEnclosingElement();
        }
        return null;
    }

    private void generateRTTLookupMethod(MethodElement methodElement, String overrideName) {
        JsExpression fnDecl;
        boolean hasTypeArguments = false;
        if (ElementKind.of(methodElement).equals((Object)ElementKind.CONSTRUCTOR) || methodElement.getModifiers().isNative()) {
            return;
        }
        ClassElement classElement = this.getEnclosingClassElement(methodElement.getEnclosingElement());
        hasTypeArguments = classElement != null ? this.hasTypeParameters(classElement) : false;
        JsProgram program = this.translationContext.getProgram();
        JsExpression typeArgContextExpr = hasTypeArguments ? this.buildTypeArgsReferenceFromThis(classElement) : null;
        JsFunction lookupFn = new JsFunction(this.globalScope);
        lookupFn.setBody(new JsBlock());
        JsScope scope = new JsScope(this.globalScope, "temp");
        List<JsStatement> body = lookupFn.getBody().getStatements();
        JsInvocation callLookup = AstUtil.newInvocation(AstUtil.newQualifiedNameRef("RTT.createFunction"), new JsExpression[0]);
        JsArrayLiteral arr = this.generateTypeArrayFromElements(methodElement.getParameters(), classElement, typeArgContextExpr);
        JsInvocation returnExpr = this.generateRTTLookupForType(methodElement, methodElement.getReturnType(), classElement, typeArgContextExpr);
        callLookup.getArguments().add(arr.getExpressions().isEmpty() ? program.getNullLiteral() : arr);
        callLookup.getArguments().add(returnExpr);
        body.add(new JsReturn(callLookup));
        if (overrideName == null) {
            JsNameRef methodToCall = this.getRTTLookupMethodNameRef(methodElement);
            if (methodElement.getEnclosingElement().getKind().equals((Object)ElementKind.CLASS)) {
                fnDecl = AstUtil.assign(null, methodToCall, lookupFn);
            } else {
                lookupFn.setName(scope.declareFreshName(methodToCall.getIdent()));
                fnDecl = lookupFn;
            }
        } else {
            lookupFn.setName(scope.declareName(overrideName));
            fnDecl = lookupFn;
        }
        this.globalBlock.getStatements().add(fnDecl.makeStmt());
    }

    private JsInvocation generateRTTCreate(VariableElement element, ClassElement classElement) {
        boolean hasTypes = false;
        FunctionType type = (FunctionType)element.getType();
        if (ElementKind.of(element).equals((Object)ElementKind.CONSTRUCTOR) || element.getModifiers().isNative()) {
            return AstUtil.newInvocation(AstUtil.newQualifiedNameRef(RTT_DYNAMIC_LOOKUP), new JsExpression[0]);
        }
        hasTypes = classElement != null ? this.hasTypeParameters(classElement) : false;
        JsProgram program = this.translationContext.getProgram();
        JsExpression typeArgContextExpr = hasTypes ? this.buildTypeArgsReference(classElement) : null;
        JsInvocation callLookup = AstUtil.newInvocation(AstUtil.newQualifiedNameRef("RTT.createFunction"), new JsExpression[0]);
        JsArrayLiteral arr = this.generateTypeArrayFromTypes(type.getParameterTypes(), classElement, typeArgContextExpr);
        if (arr == null) {
            return AstUtil.newInvocation(AstUtil.newQualifiedNameRef(RTT_DYNAMIC_LOOKUP), new JsExpression[0]);
        }
        JsInvocation returnExpr = this.generateRTTLookupForType(element, type.getReturnType(), classElement, typeArgContextExpr);
        callLookup.getArguments().add(arr.getExpressions().isEmpty() ? program.getNullLiteral() : arr);
        callLookup.getArguments().add(returnExpr);
        return callLookup;
    }

    private JsArrayLiteral generateTypeArrayFromTypes(List<? extends Type> parameterTypes, ClassElement classElement, JsExpression typeArgContextExpr) {
        JsArrayLiteral jsTypeArray = new JsArrayLiteral();
        for (Type type : parameterTypes) {
            JsInvocation elementExpr = this.generateRTTLookupForType(type.getElement(), type, classElement, typeArgContextExpr);
            jsTypeArray.getExpressions().add(elementExpr);
        }
        return jsTypeArray;
    }

    private JsArrayLiteral generateTypeArrayFromParameters(List<DartParameter> params, ClassElement classElement, JsExpression typeArgContextExpr) {
        JsArrayLiteral jsTypeArray = new JsArrayLiteral();
        for (DartParameter param : params) {
            Type paramType = param.getTypeNode() == null ? null : param.getTypeNode().getType();
            JsInvocation elementInvoke = this.generateRTTLookupForType(param.getSymbol(), paramType, classElement, typeArgContextExpr);
            jsTypeArray.getExpressions().add(elementInvoke);
        }
        return jsTypeArray;
    }

    private JsArrayLiteral generateTypeArrayFromElements(List<VariableElement> elements, ClassElement classElement, JsExpression typeArgContextExpr) {
        JsArrayLiteral jsTypeArray = new JsArrayLiteral();
        for (VariableElement element : elements) {
            JsInvocation rttTypeExpression = this.generateRTTLookupForType(element, element.getType(), classElement, typeArgContextExpr);
            jsTypeArray.getExpressions().add(rttTypeExpression);
        }
        return jsTypeArray;
    }

    private JsInvocation generateRTTLookupForType(Element element, Type elementType, ClassElement classElement, JsExpression typeArgContextExpr) {
        return this.generateRTTLookupForType(element, elementType, classElement, typeArgContextExpr, element.getModifiers().isNamed() ? element.getName() : null);
    }

    private JsInvocation generateRTTLookupForType(Element element, Type elementType, ClassElement classElement, JsExpression typeArgContextExpr, String named) {
        JsInvocation elementInvoke = null;
        switch (TypeKind.of(elementType)) {
            case VARIABLE: {
                elementInvoke = this.buildTypeLookupExpression(elementType, classElement.getTypeParameters(), typeArgContextExpr);
                break;
            }
            case INTERFACE: {
                elementInvoke = this.generateRTTLookup((ClassElement)elementType.getElement(), (InterfaceType)elementType, classElement);
                break;
            }
            case FUNCTION: {
                elementInvoke = this.generateRTTCreate((VariableElement)element, classElement);
                break;
            }
            case FUNCTION_ALIAS: {
                elementInvoke = this.buildTypeLookupExpression(elementType, classElement != null ? classElement.getTypeParameters() : null, typeArgContextExpr);
                break;
            }
            case DYNAMIC: 
            case VOID: 
            case NONE: {
                elementInvoke = AstUtil.newInvocation(AstUtil.newQualifiedNameRef(RTT_DYNAMIC_LOOKUP), new JsExpression[0]);
                break;
            }
            default: {
                elementInvoke = this.buildTypeLookupExpression(elementType, classElement.getTypeParameters(), typeArgContextExpr);
            }
        }
        if (named != null) {
            if (elementInvoke.getArguments().size() == 0) {
                elementInvoke.getArguments().add(this.translationContext.getProgram().getNullLiteral());
            }
            elementInvoke.getArguments().add(this.translationContext.getProgram().getStringLiteral(named));
        }
        assert (elementInvoke != null);
        return elementInvoke;
    }

    private JsName getJsName(Symbol symbol) {
        return this.translationContext.getNames().getName(symbol);
    }

    private void generateRTTLookupMethod(DartFunctionTypeAlias x) {
        FunctionAliasElementImplementation classElement = (FunctionAliasElementImplementation)x.getSymbol();
        FunctionType funcType = classElement.getFunctionType();
        JsFunction lookupFn = new JsFunction(this.globalScope);
        lookupFn.setBody(new JsBlock());
        List<JsStatement> body = lookupFn.getBody().getStatements();
        JsScope scope = new JsScope(this.globalScope, "temp");
        JsProgram program = this.translationContext.getProgram();
        JsInvocation invokeCreate = AstUtil.call(null, AstUtil.newQualifiedNameRef("RTT.createFunction"), new JsExpression[0]);
        List<JsExpression> callArgs = invokeCreate.getArguments();
        JsName typeArgs = scope.declareName("typeArgs");
        JsNameRef typeArgsExpr = new JsNameRef("typeArgs");
        lookupFn.getParameters().add(new JsParameter(typeArgs));
        JsArrayLiteral arr = this.generateTypeArrayFromParameters(x.getParameters(), classElement, typeArgsExpr);
        callArgs.add(arr.getExpressions().isEmpty() ? program.getNullLiteral() : arr);
        JsInvocation returnExpr = this.generateRTTLookupForType(funcType.getElement(), funcType.getReturnType(), classElement, typeArgsExpr);
        callArgs.add(returnExpr);
        JsName named = scope.declareName(RTT_NAMED_PARAMETER);
        lookupFn.getParameters().add(new JsParameter(named));
        callArgs.add(named.makeRef());
        body.add(new JsReturn(invokeCreate));
        JsExpression fnDecl = AstUtil.assign(null, this.getRTTLookupMethodNameRef(classElement), lookupFn);
        this.globalBlock.getStatements().add(fnDecl.makeStmt());
    }

    static JsExpression getRTTClassId(TranslationContext translationContext, ClassElement classElement) {
        JsName classJsName = translationContext.getNames().getName(classElement);
        JsProgram program = translationContext.getProgram();
        JsStringLiteral clsid = program.getStringLiteral(classJsName.getShortIdent());
        return AstUtil.call(null, AstUtil.nameref(null, "$cls"), clsid);
    }

    JsExpression getRTTClassId(ClassElement classElement) {
        return RuntimeTypeInjector.getRTTClassId(this.translationContext, classElement);
    }

    private JsNameRef getRTTLookupMethodNameRef(ClassElement classElement) {
        return AstUtil.nameref(null, this.translationContext.getNames().getName(classElement), "$lookupRTT");
    }

    public JsNameRef getRTTLookupMethodNameRef(MethodElement methodElement) {
        JsNameRef methodToCall;
        if (ElementKind.of(methodElement.getEnclosingElement()) == ElementKind.CLASS) {
            JsNameRef classJsNameRef = this.getJsName(methodElement.getEnclosingElement()).makeRef();
            String mangledMethodName = this.mangler.mangleRttLookupMethod(methodElement, this.unitLibrary);
            if (methodElement.getModifiers().isStatic()) {
                methodToCall = AstUtil.newNameRef((JsExpression)classJsNameRef, mangledMethodName);
            } else {
                JsNameRef prototypeRef = AstUtil.newPrototypeNameRef(classJsNameRef);
                methodToCall = AstUtil.newNameRef((JsExpression)prototypeRef, mangledMethodName);
            }
        } else {
            methodToCall = AstUtil.newQualifiedNameRef(this.mangler.mangleRttLookupMethod(methodElement, this.unitLibrary));
        }
        return methodToCall;
    }

    private JsNameRef getRTTImplementsMethodName(ClassElement classElement) {
        return AstUtil.nameref(null, this.translationContext.getNames().getName(classElement), "$RTTimplements");
    }

    private JsNameRef getRTTAddToMethodName(ClassElement classElement) {
        return AstUtil.nameref(null, this.translationContext.getNames().getName(classElement), "$addTo");
    }

    private JsExpression buildTypeArgsReference(ClassElement classElement) {
        JsExpression typeArgs = this.inFactory() ? (this.hasTypeParameters(classElement) ? AstUtil.nameref(null, "$typeArgs") : new JsArrayLiteral()) : this.buildTypeArgsReferenceFromThis(classElement);
        return typeArgs;
    }

    private JsExpression buildTypeArgsReferenceFromThis(ClassElement classElement) {
        return AstUtil.call(null, AstUtil.newQualifiedNameRef("RTT.getTypeArgsFor"), new JsThisRef(), this.getRTTClassId(classElement));
    }

    private JsExpression buildTypeArgs(InterfaceType instanceType, List<? extends Type> listTypeVars, JsExpression contextTypeArgs) {
        ClassElement classElement = instanceType.getElement();
        if (!this.hasTypeParameters(classElement)) {
            return null;
        }
        if (instanceType.hasDynamicTypeArgs()) {
            JsProgram program = this.translationContext.getProgram();
            return program.getNullLiteral();
        }
        JsArrayLiteral arr = new JsArrayLiteral();
        assert (instanceType.getArguments().size() > 0);
        for (Type type : instanceType.getArguments()) {
            JsInvocation typeExpr = this.buildTypeLookupExpression(type, listTypeVars, contextTypeArgs);
            arr.getExpressions().add(typeExpr);
        }
        return arr;
    }

    private JsExpression buildTypeArgsForFactory(FunctionType functionType, InterfaceType instanceType, List<? extends Type> listTypeVars, JsExpression contextTypeArgs) {
        if (instanceType.getElement().getTypeParameters().size() == 0) {
            return null;
        }
        if (instanceType.hasDynamicTypeArgs()) {
            return this.translationContext.getProgram().getNullLiteral();
        }
        JsArrayLiteral arr = new JsArrayLiteral();
        for (Type type : instanceType.getArguments()) {
            JsInvocation typeExpr = this.buildTypeLookupExpression(type, listTypeVars, contextTypeArgs);
            arr.getExpressions().add(typeExpr);
        }
        return arr;
    }

    private JsExpression generateRawRTTLookup(ClassElement classElement) {
        JsInvocation invokeLookup = AstUtil.call(null, this.getRTTLookupMethodNameRef(classElement), new JsExpression[0]);
        return invokeLookup;
    }

    private JsExpression generateRTTLookup(InterfaceType instanceType, ClassElement contextClassElement) {
        return this.generateRTTLookup(instanceType.getElement(), instanceType, contextClassElement);
    }

    private JsInvocation generateRTTLookup(ClassElement classElement, InterfaceType instanceType, ClassElement contextClassElement) {
        JsInvocation invokeLookup = AstUtil.call(null, this.getRTTLookupMethodNameRef(classElement), new JsExpression[0]);
        if (this.hasTypeParameters(instanceType.getElement()) && !instanceType.hasDynamicTypeArgs()) {
            JsExpression typeArgs = this.generateTypeArgsArray(instanceType, contextClassElement);
            assert (typeArgs != null);
            invokeLookup.getArguments().add(typeArgs);
        }
        return invokeLookup;
    }

    private JsExpression generateTypeArgsArray(InterfaceType instanceType, ClassElement contextClassElement) {
        JsExpression typeArgs;
        if (this.inStaticNotFactory(contextClassElement)) {
            typeArgs = ElementKind.of(contextClassElement) == ElementKind.FUNCTION_TYPE_ALIAS ? this.buildTypeArgs(instanceType, contextClassElement.getTypeParameters(), new JsNameRef("typeArgs")) : this.buildTypeArgs(instanceType, null, null);
        } else {
            JsExpression typeArgContextExpr = this.buildTypeArgsReference(contextClassElement);
            typeArgs = this.buildTypeArgs(instanceType, contextClassElement.getTypeParameters(), typeArgContextExpr);
        }
        return typeArgs;
    }

    private JsExpression generateTypeArgsArrayForFactory(FunctionType functionType, InterfaceType instanceType, ClassElement contextClassElement) {
        JsExpression typeArgs;
        if (this.inStaticNotFactory(contextClassElement)) {
            typeArgs = this.buildTypeArgsForFactory(functionType, instanceType, null, null);
        } else {
            JsExpression typeArgContextExpr = this.buildTypeArgsReference(contextClassElement);
            typeArgs = this.buildTypeArgsForFactory(functionType, instanceType, contextClassElement.getTypeParameters(), typeArgContextExpr);
        }
        return typeArgs;
    }

    private boolean hasTypeParameters(ClassElement classElement) {
        return classElement.getTypeParameters().size() > 0;
    }

    private boolean hasRTTImplements(ClassElement classElement) {
        InterfaceType superType = classElement.getSupertype();
        return superType != null && !superType.getElement().isObject() || !classElement.getInterfaces().isEmpty();
    }

    private JsInvocation buildTypeLookupExpression(Type type, List<? extends Type> list, JsExpression contextTypeArgs) {
        switch (TypeKind.of(type)) {
            case INTERFACE: 
            case FUNCTION_ALIAS: {
                InterfaceType interfaceType = (InterfaceType)type;
                JsInvocation callLookup = AstUtil.call(null, this.getRTTLookupMethodNameRef(interfaceType.getElement()), new JsExpression[0]);
                if (this.hasTypeParameters(interfaceType.getElement()) && !interfaceType.hasDynamicTypeArgs()) {
                    JsArrayLiteral typeArgs = new JsArrayLiteral();
                    for (Type type2 : interfaceType.getArguments()) {
                        typeArgs.getExpressions().add(this.buildTypeLookupExpression(type2, list, contextTypeArgs));
                    }
                    callLookup.getArguments().add(typeArgs);
                }
                return callLookup;
            }
            case FUNCTION: {
                FunctionType functionType = (FunctionType)type;
                JsInvocation functionTypeCallLookup = AstUtil.call(null, this.getRTTLookupMethodNameRef(functionType.getElement()), new JsExpression[0]);
                if (this.hasTypeParameters(functionType.getElement())) {
                    JsArrayLiteral jsArrayLiteral = new JsArrayLiteral();
                    functionTypeCallLookup.getArguments().add(jsArrayLiteral);
                }
                return functionTypeCallLookup;
            }
            case VARIABLE: {
                TypeVariable typeVariable = (TypeVariable)type;
                JsProgram program = this.translationContext.getProgram();
                int varIndex = 0;
                for (Type type3 : list) {
                    if (type3.equals(type)) {
                        return AstUtil.call(null, AstUtil.newQualifiedNameRef("RTT.getTypeArg"), Cloner.clone(contextTypeArgs), program.getNumberLiteral(varIndex));
                    }
                    ++varIndex;
                }
                throw new AssertionError((Object)("unresolved type variable:" + typeVariable));
            }
        }
        throw new AssertionError((Object)("unexpected type kind:" + (Object)((Object)type.getKind())));
    }

    void maybeAddClassRuntimeTypeToConstructor(ClassElement classElement, JsFunction factory, JsExpression thisRef) {
        JsExpression typeInfo;
        JsScope factoryScope = factory.getScope();
        if (this.hasTypeParameters(classElement)) {
            JsName typeinfoParameter = factoryScope.declareName("$rtt");
            factory.getParameters().add(0, new JsParameter(typeinfoParameter));
            typeInfo = typeinfoParameter.makeRef();
        } else {
            typeInfo = this.generateRawRTTLookup(classElement);
        }
        JsExpression setTypeInfo = AstUtil.assign(null, AstUtil.nameref(null, Cloner.clone(thisRef), "$typeInfo"), typeInfo);
        factory.getBody().getStatements().add(0, setTypeInfo.makeStmt());
    }

    void maybeAddTypeParameterToFactory(DartMethodDefinition method, JsFunction factory) {
        if (this.isParameterizedFactoryMethod(method)) {
            JsScope scope = factory.getScope();
            JsName typeArgs = scope.declareName("$typeArgs");
            factory.getParameters().add(0, new JsParameter(typeArgs));
        }
    }

    private boolean isParameterizedFactoryMethod(DartMethodDefinition method) {
        assert (method.getModifiers().isFactory());
        EnclosingElement enclosingElement = method.getSymbol().getEnclosingElement();
        if (ElementKind.of(enclosingElement).equals((Object)ElementKind.CLASS)) {
            ClassElement enclosingClass = (ClassElement)enclosingElement;
            return !enclosingClass.getTypeParameters().isEmpty();
        }
        return false;
    }

    JsExpression maybeAddRuntimeTypeForArrayLiteral(ClassElement enclosingClass, DartArrayLiteral x, JsArrayLiteral jsArray) {
        InterfaceType instanceType = this.typeProvider.getArrayLiteralType(x.getType().getArguments().get(0));
        JsExpression rtt = this.generateRTTLookup(instanceType, enclosingClass);
        return AstUtil.call(x, AstUtil.newQualifiedNameRef("RTT.setTypeInfo"), jsArray, rtt);
    }

    void maybeAddRuntimeTypeToMapLiteralConstructor(ClassElement enclosingClass, DartMapLiteral x, JsInvocation invoke) {
        List<? extends Type> typeArgs = x.getType().getArguments();
        InterfaceType instanceType = this.typeProvider.getMapLiteralType(typeArgs.get(0), typeArgs.get(1));
        JsExpression rtt = this.generateRTTLookup(instanceType, enclosingClass);
        invoke.getArguments().add(rtt);
    }

    void mayAddRuntimeTypeToConstrutorOrFactoryCall(ClassElement enclosingClass, DartNewExpression x, JsInvocation invoke) {
        InterfaceType instanceType = Types.constructorType(x);
        if (instanceType == null) {
            assert (this.typeProvider.getFallThroughError().getElement().lookupConstructor("").equals(x.getSymbol()));
        } else if (this.constructorHasTypeParameters(x)) {
            ConstructorElement constructor = x.getSymbol();
            ClassElement containingClassElement = enclosingClass;
            if (constructor.getModifiers().isFactory()) {
                FunctionType functionType = (FunctionType)constructor.getType();
                JsExpression typeArgs = this.generateTypeArgsArrayForFactory(functionType, instanceType, containingClassElement);
                assert (typeArgs != null);
                invoke.getArguments().add(0, typeArgs);
            } else {
                ClassElement constructorClassElement = constructor.getConstructorType();
                invoke.getArguments().add(0, this.generateRTTLookup(constructorClassElement, instanceType, containingClassElement));
            }
        }
    }

    private boolean constructorHasTypeParameters(DartNewExpression x) {
        ConstructorElement element = x.getSymbol();
        if (element.getModifiers().isFactory()) {
            return this.isParameterizedFactoryMethod((DartMethodDefinition)element.getNode());
        }
        InterfaceType instanceType = Types.constructorType(x);
        return this.hasTypeParameters(instanceType.getElement());
    }

    JsExpression generateInstanceOfComparison(ClassElement enclosingClass, JsExpression lhs, DartTypeNode typeNode, SourceInfo src) {
        ClassElement currentClass = enclosingClass;
        Type type = typeNode.getType();
        switch (TypeKind.of(type)) {
            case INTERFACE: {
                InterfaceType interfaceType = (InterfaceType)type;
                if (this.hasTypeParameters(interfaceType.getElement()) && !interfaceType.hasDynamicTypeArgs()) {
                    return this.generateRefiedInterfaceTypeComparison(lhs, interfaceType, currentClass, src);
                }
                return this.generateRawInterfaceTypeComparison(lhs, typeNode, src);
            }
            case VARIABLE: {
                TypeVariable typeVar = (TypeVariable)type;
                return this.generateRefiedTypeVariableComparison(lhs, typeVar, currentClass, src);
            }
            case DYNAMIC: {
                JsProgram program = this.translationContext.getProgram();
                return program.getTrueLiteral();
            }
            case FUNCTION_ALIAS: {
                FunctionAliasType aliasType = (FunctionAliasType)type;
                return this.generateRefiedInterfaceTypeComparison(lhs, aliasType, currentClass, src);
            }
        }
        throw new IllegalStateException("unexpected");
    }

    private JsExpression generateRefiedInterfaceTypeComparison(JsExpression lhs, InterfaceType type, ClassElement contextClassElement, SourceInfo src) {
        JsExpression rtt = this.generateRTTLookup(type, contextClassElement);
        return AstUtil.call(src, AstUtil.nameref(src, rtt, "implementedBy"), lhs);
    }

    private JsExpression getReifiedTypeVariableRTT(TypeVariable type, ClassElement contextClassElement) {
        JsExpression rttContext = this.buildTypeArgsReference(contextClassElement);
        JsInvocation rtt = this.buildTypeLookupExpression(type, contextClassElement.getTypeParameters(), rttContext);
        return rtt;
    }

    private JsExpression generateRefiedTypeVariableComparison(JsExpression lhs, TypeVariable type, ClassElement contextClassElement, SourceInfo src) {
        JsExpression rtt = this.getReifiedTypeVariableRTT(type, contextClassElement);
        return AstUtil.call(src, AstUtil.nameref(src, rtt, "implementedBy"), lhs);
    }

    private JsExpression generateRawInterfaceTypeComparison(JsExpression lhs, DartTypeNode typeNode, SourceInfo src) {
        ClassElement element = (ClassElement)typeNode.getType().getElement();
        if (element.equals(this.typeProvider.getObjectType().getElement())) {
            return this.translationContext.getProgram().getTrueLiteral();
        }
        String builtin = this.builtInTypeChecks.get(element);
        if (builtin != null) {
            return AstUtil.call(src, AstUtil.nameref(src, builtin), lhs);
        }
        JsProgram program = this.translationContext.getProgram();
        JsName tmp = this.context.createTemporary();
        String mangledClass = this.translationContext.getMangler().mangleClassName(element);
        return AstUtil.not(src, AstUtil.not(src, AstUtil.comma(src, AstUtil.assign(src, tmp.makeRef(), lhs), AstUtil.and(src, AstUtil.neq(src, tmp.makeRef().setSourceRef(src), program.getNullLiteral()), AstUtil.nameref(src, tmp, "$implements$" + mangledClass)))));
    }

    private boolean inFactory() {
        DartClassMember<?> member = this.context.getCurrentClassMember();
        return member != null && member.getModifiers().isFactory();
    }

    private boolean inStaticNotFactory(ClassElement containingClass) {
        return !this.inFactory() && this.inStatic(containingClass);
    }

    private boolean inStatic(ClassElement containingClass) {
        DartClassMember<?> member = this.context.getCurrentClassMember();
        return containingClass == null || containingClass.getKind() != ElementKind.CLASS || member == null || member.getModifiers().isStatic();
    }

    JsExpression addTypeCheck(ClassElement enclosingClass, JsExpression expr, Type type, Type exprType, SourceInfo src) {
        if (!this.emitTypeChecks || this.isStaticallyGoodAssignment(type, exprType)) {
            return expr;
        }
        if (this.isStaticallyBadAssignment(type, exprType, expr)) {
            return this.injectTypeError(enclosingClass, expr, type, src);
        }
        return this.injectTypeCheck(enclosingClass, expr, type, src);
    }

    private boolean isStaticallyBadAssignment(Type type, Type exprType, JsExpression expr) {
        if (!expr.isDefinitelyNotNull() || type == null || exprType == null || type.getKind() == TypeKind.DYNAMIC || exprType.getKind() == TypeKind.DYNAMIC) {
            return false;
        }
        return !this.types.isAssignable(type, exprType);
    }

    private boolean isStaticallyGoodAssignment(Type type, Type exprType) {
        if (type == null || type.getKind() == TypeKind.DYNAMIC) {
            return true;
        }
        if (exprType == null || exprType.getKind() == TypeKind.DYNAMIC) {
            return false;
        }
        return this.types.isAssignable(type, exprType);
    }

    private JsExpression injectTypeError(ClassElement enclosingClass, JsExpression expr, Type type, SourceInfo src) {
        JsExpression rtt = this.getRtt(enclosingClass, expr, type);
        if (rtt != null) {
            expr = AstUtil.call(src, AstUtil.nameref(src, "$te"), rtt, expr);
        }
        return expr;
    }

    private JsExpression injectTypeCheck(ClassElement enclosingClass, JsExpression expr, Type type, SourceInfo src) {
        JsExpression rtt = this.getRtt(enclosingClass, expr, type);
        if (rtt != null) {
            expr = AstUtil.call(src, AstUtil.nameref(src, "$chk"), rtt, expr);
        }
        return expr;
    }

    private JsExpression getRtt(ClassElement enclosingClass, JsExpression expr, Type type) {
        if (!this.emitTypeChecks || type == null) {
            return null;
        }
        switch (TypeKind.of(type)) {
            case INTERFACE: {
                InterfaceType interfaceType = (InterfaceType)type;
                return this.generateRTTLookup(interfaceType, enclosingClass);
            }
            case VARIABLE: {
                TypeVariable typeVar = (TypeVariable)type;
                return this.getReifiedTypeVariableRTT(typeVar, enclosingClass);
            }
            case FUNCTION: {
                return this.generateRTTLookup(this.typeProvider.getFunctionType(), enclosingClass);
            }
            case FUNCTION_ALIAS: 
            case DYNAMIC: 
            case VOID: {
                return null;
            }
        }
        throw new IllegalStateException("unexpected type " + type);
    }
}

