/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsModVisitor;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperation;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;

public class JsNormalizer {
    private final JsProgram program;

    public static void exec(JsProgram program) {
        new JsNormalizer(program).execImpl();
    }

    private JsNormalizer(JsProgram program) {
        this.program = program;
    }

    private void execImpl() {
        JsNormalizing normalizer = new JsNormalizing();
        normalizer.accept(this.program);
    }

    private static class JsNormalizing
    extends JsModVisitor {
        private JsNormalizing() {
        }

        @Override
        public void endVisit(JsBinaryOperation x, JsContext ctx) {
            this.maybeShuffleModifyingBinary(x, ctx);
        }

        @Override
        public void endVisit(JsPostfixOperation x, JsContext ctx) {
            this.maybeShuffleModifyingUnary(x, ctx);
        }

        @Override
        public void endVisit(JsPrefixOperation x, JsContext ctx) {
            this.maybeShuffleModifyingUnary(x, ctx);
        }

        private void maybeShuffleModifyingBinary(JsBinaryOperation x, JsContext ctx) {
            JsBinaryOperator myOp = x.getOperator();
            JsExpression lhs = x.getArg1();
            if (myOp.isAssignment() && lhs instanceof JsBinaryOperation) {
                JsBinaryOperation curLhs = (JsBinaryOperation)lhs;
                assert (curLhs.getOperator() == JsBinaryOperator.COMMA);
                while (curLhs.getArg2() instanceof JsBinaryOperation) {
                    curLhs = (JsBinaryOperation)curLhs.getArg2();
                    assert (curLhs.getOperator() == JsBinaryOperator.COMMA);
                }
                x.setArg1(curLhs.getArg2());
                curLhs.setArg2(x);
                ctx.replaceMe(lhs);
            }
        }

        private void maybeShuffleModifyingUnary(JsUnaryOperation x, JsContext ctx) {
            JsUnaryOperator myOp = x.getOperator();
            JsExpression arg = x.getArg();
            if (myOp.isModifying() && arg instanceof JsBinaryOperation) {
                JsBinaryOperation curArg = (JsBinaryOperation)arg;
                assert (curArg.getOperator() == JsBinaryOperator.COMMA);
                while (curArg.getArg2() instanceof JsBinaryOperation) {
                    curArg = (JsBinaryOperation)curArg.getArg2();
                    assert (curArg.getOperator() == JsBinaryOperator.COMMA);
                }
                x.setArg(curArg.getArg2());
                curArg.setArg2(x);
                ctx.replaceMe(arg);
            }
        }
    }
}

