/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.ast.LibraryNode;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.backend.js.AbstractJsBackend;
import com.google.dart.compiler.backend.js.analysis.TreeShaker;
import com.google.dart.compiler.common.GenerateSourceMap;
import com.google.dart.compiler.metrics.CompilerMetrics;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapSection;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavascriptBackend
extends AbstractJsBackend {
    public static final String EXTENSION_APP_JS_COMPLETE = "app.js.complete";

    private static long packageLibs(Writer w, List<SourceMapSection> appSections, DartCompilerContext context) throws IOException {
        CountingAppendable out = new CountingAppendable(w);
        DepsWritingCallback callback = new DepsWritingCallback(context, out, appSections);
        AbstractJsBackend.DependencyBuilder.build(context.getAppLibraryUnit(), callback);
        return callback.getCharsWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void packageApp(LibrarySource app, Collection<LibraryUnit> libraries, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        CompilerMetrics compilerMetrics;
        LibraryUnit appLibraryUnit = context.getAppLibraryUnit();
        boolean hasEntryPoint = appLibraryUnit.getElement().getEntryPoint() != null;
        ArrayList appSections = Lists.newArrayList();
        String completeArtifactName = "app.js";
        if (hasEntryPoint) {
            completeArtifactName = EXTENSION_APP_JS_COMPLETE;
        }
        Writer out = context.getArtifactWriter(app, "", completeArtifactName);
        long outputFileSize = 0L;
        boolean failed = true;
        try {
            outputFileSize = JavascriptBackend.packageLibs(out, appSections, context);
            outputFileSize += (long)this.writeEntryPointCall(this.getMangledEntryPoint(context), out);
            failed = false;
        }
        finally {
            Closeables.close((Closeable)out, (boolean)failed);
        }
        if (hasEntryPoint) {
            Writer artifactWriter = context.getArtifactWriter(app, "", "app.js");
            try {
                failed = true;
                outputFileSize = TreeShaker.reduce(app, context, completeArtifactName, artifactWriter);
                failed = false;
            }
            finally {
                Closeables.close((Closeable)artifactWriter, (boolean)failed);
            }
        }
        if ((compilerMetrics = context.getCompilerMetrics()) != null) {
            compilerMetrics.packagedJsApplication(outputFileSize, -1L);
        }
        Writer srcMapOut = context.getArtifactWriter(app, "", "app.js.map");
        failed = true;
        try {
            new GenerateSourceMap().appendIndexMapTo(srcMapOut, app.getName() + "." + "js", appSections);
            failed = false;
        }
        finally {
            Closeables.close((Closeable)srcMapOut, (boolean)failed);
        }
    }

    @Override
    public String getAppExtension() {
        return "app.js";
    }

    @Override
    public String getSourceMapExtension() {
        return "app.js.map";
    }

    @Override
    protected boolean shouldOptimize() {
        return false;
    }

    private static class DepsWritingCallback
    implements AbstractJsBackend.DepsCallback {
        private final DartCompilerContext context;
        private CountingAppendable out;
        private final List<SourceMapSection> appSections;

        DepsWritingCallback(DartCompilerContext context, CountingAppendable out, List<SourceMapSection> appSections) {
            this.out = out;
            this.context = context;
            this.appSections = appSections;
        }

        @Override
        public void visitNative(LibraryUnit libUnit, LibraryNode node) throws IOException {
            DartSource nativeSrc = libUnit.getSource().getSourceFor(node.getText());
            Reader r = nativeSrc.getSourceReader();
            long charsWrittenForFile = CharStreams.copy((Readable)r, (Appendable)this.out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitPart(AbstractJsBackend.Part part) throws IOException {
            DartSource src = part.unit.getSource();
            assert (src != null);
            Reader r = this.context.getArtifactReader(src, part.part, "js");
            if (r == null) {
                return;
            }
            FilePosition offset = this.out.getOffset();
            assert (src != null);
            long partSize = 0L;
            boolean failed = true;
            try {
                partSize = CharStreams.copy((Readable)r, (Appendable)this.out);
                failed = false;
            }
            finally {
                Closeables.close((Closeable)r, (boolean)failed);
            }
            if (partSize > 0L) {
                String mapUrl = this.context.getArtifactUri(src, part.part, "js.map").toString();
                SourceMapSection sourceMapSection = SourceMapSection.forURL((String)mapUrl, (int)offset.getLine(), (int)offset.getColumn());
                this.appSections.add(sourceMapSection);
            }
        }

        public long getCharsWritten() {
            return this.out.charCount;
        }
    }

    static class CountingAppendable
    implements Appendable {
        private int line = 0;
        private int column = 0;
        private Appendable out;
        private long charCount = 0L;

        FilePosition getOffset() {
            return new FilePosition(this.line, this.column);
        }

        CountingAppendable(Appendable out) {
            this.out = out;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.incCount(csq, 0, csq.length());
            return this.out.append(csq);
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.incCount(c);
            return this.out.append(c);
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.incCount(csq, start, end);
            return this.out.append(csq, start, end);
        }

        private void incCount(CharSequence cs, int start, int end) {
            for (int i = 0; i < cs.length(); ++i) {
                this.incCount(cs.charAt(i));
            }
        }

        private void incCount(char c) {
            ++this.charCount;
            if (c == '\n') {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
        }
    }
}

