/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.common.collect.ImmutableSet;
import com.google.dart.compiler.InternalCompilerException;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.backend.js.DartMangler;
import com.google.dart.compiler.parser.Token;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FieldElement;
import com.google.dart.compiler.resolver.LibraryElement;
import com.google.dart.compiler.resolver.MethodElement;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;

public class DollarMangler
implements DartMangler {
    private static final Set<String> BLACKLISTED_LIBRARIES = ImmutableSet.of((Object)"corelib", (Object)"corelib_impl", (Object)"dom");
    private static final String OPERATOR_SUFFIX = "$operator";
    private static final String GETTER_SUFFIX = "$getter";
    private static final String SETTER_SUFFIX = "$setter";
    private static final String FIELD_SUFFIX = "$field";
    private static final String METHOD_SUFFIX = "$member";
    private static final String NAMED_SUFFIX = "$named";
    private static final String CONSTRUCTOR_SUFFIX = "$Constructor";
    private static final String FACTORY_SUFFIX = "$Factory";
    private static final String INITIALIZER_SUFFIX = "$Initializer";
    private static final String CLASS_SUFFIX = "$Dart";
    private static final String HOISTED_METHOD_SUFFIX = "$Hoisted";
    private static final String HOISTED_OPERATOR_SUFFIX = "$HoistedOperator";
    private static final String HOISTED_CONSTRUCTOR_SUFFIX = "$HoistedConstructor";
    private static final String HOISTED_STATIC_SUFFIX = "$HoistedStatic";
    private static final String DYNAMIC_CLASS_NAME = "$_Dynamic_";
    private static final String RTT_LOOKUP_NAME = "_$lookupRTT";
    private static final String NATIVE_PREFIX = "native_";

    private boolean isLibraryPrivate(String id) {
        return id.length() > 0 && id.charAt(0) == '_';
    }

    private String attachSuffix(String name, String suffix, boolean isLibraryPrivate, LibraryElement currentLibrary) {
        if (isLibraryPrivate) {
            return name + '$' + this.mangleLibraryName(currentLibrary) + suffix + '_';
        }
        return name + suffix;
    }

    private String attachSuffix(String name, String suffix, LibraryElement currentLibrary) {
        return this.attachSuffix(name, suffix, this.isLibraryPrivate(name), currentLibrary);
    }

    private String mangleLibraryName(LibraryElement element) {
        MessageDigest md;
        LibraryUnit library = element.getLibraryUnit();
        if (this.isInBlacklist(library)) {
            return "";
        }
        String libName = library.getName();
        if (libName == null || libName.isEmpty()) {
            libName = "unnamed";
        }
        int nameStart = libName.lastIndexOf(47) + 1;
        StringBuilder sb = new StringBuilder(libName.length() + 8);
        char startChar = libName.charAt(nameStart);
        if ('0' <= startChar && startChar <= '9') {
            sb.append('l');
        }
        sb.append(libName.substring(nameStart));
        this.replaceNonWordChars(sb);
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"Could not find MD5 digest");
        }
        byte[] md5 = md.digest(library.getSource().getUri().toString().getBytes());
        for (int i = 0; i < 3; ++i) {
            sb.append(Integer.toHexString((md5[i] & 0xF0) >> 4));
            sb.append(Integer.toHexString(md5[i] & 0xF));
        }
        sb.append("$");
        return sb.toString();
    }

    private void replaceNonWordChars(StringBuilder sb) {
        int len = sb.length();
        for (int idx = 0; idx < len; ++idx) {
            char ch = sb.charAt(idx);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') continue;
            sb.setCharAt(idx, '_');
        }
    }

    @Override
    public String mangleClassName(ClassElement classElement) {
        String className = !classElement.isDynamic() ? classElement.getName() : DYNAMIC_CLASS_NAME;
        return this.mangleClassNameHack(classElement.getLibrary(), className);
    }

    @Override
    @Deprecated
    public String mangleClassNameHack(LibraryElement library, String className) {
        String libraryToken = library == null ? "" : this.mangleLibraryName(library);
        return libraryToken + className + CLASS_SUFFIX;
    }

    private boolean isInBlacklist(LibraryUnit libraryUnit) {
        if (libraryUnit.getName() == null) {
            return false;
        }
        if (BLACKLISTED_LIBRARIES.contains(libraryUnit.getName())) {
            return true;
        }
        for (String name : BLACKLISTED_LIBRARIES) {
            if (!libraryUnit.getName().endsWith(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String mangleConstructor(String constructorName, LibraryElement currentLibrary) {
        return this.attachSuffix(constructorName, CONSTRUCTOR_SUFFIX, currentLibrary);
    }

    @Override
    public String createInitializerSyntax(String constructorName, LibraryElement currentLibrary) {
        return this.attachSuffix(constructorName, INITIALIZER_SUFFIX, currentLibrary);
    }

    @Override
    public String createFactorySyntax(String className, String constructor, LibraryElement currentLibrary) {
        className = className.equals("<dynamic>") ? DYNAMIC_CLASS_NAME : className;
        String factoryName = constructor.equals("") ? className + "$" : className + "$" + constructor + "$" + className.length();
        return this.attachSuffix(factoryName, FACTORY_SUFFIX, this.isLibraryPrivate(constructor), currentLibrary);
    }

    private boolean containsDollar(String str) {
        return str.indexOf(36) >= 0;
    }

    private String createHoistedFunctionName(String holderName, String elementName, String closureIdentifier, String closureName, String suffix) {
        String result;
        boolean containsDollar;
        assert (closureIdentifier.indexOf(36) == -1);
        boolean bl = containsDollar = this.containsDollar(holderName) || this.containsDollar(elementName) || closureName != null && this.containsDollar(closureName);
        if (closureName != null) {
            result = holderName + "$" + elementName + "$" + closureIdentifier + "$" + closureName + "$";
            if (containsDollar) {
                result = result + holderName.length() + "_" + elementName.length() + "_" + closureIdentifier.length();
            }
        } else {
            result = holderName + "$" + elementName + "$" + closureIdentifier + "$";
            if (containsDollar) {
                result = result + holderName.length() + "_" + holderName.length();
            }
        }
        return result + suffix;
    }

    @Override
    public String createHoistedFunctionName(Element holder, Element element, String closureIdentifier, String closureName) {
        String suffix;
        String holderName = "";
        switch (ElementKind.of(holder)) {
            case CLASS: {
                holderName = this.mangleClassName((ClassElement)holder);
                break;
            }
            case LIBRARY: {
                holderName = this.mangleLibraryName((LibraryElement)holder);
            }
        }
        String name = element.getName();
        switch (ElementKind.of(element)) {
            case METHOD: {
                if (element.getModifiers().isOperator()) {
                    suffix = HOISTED_OPERATOR_SUFFIX;
                    if (name.equals("negate")) break;
                    name = Token.lookup(name).name();
                    break;
                }
                suffix = HOISTED_METHOD_SUFFIX;
                break;
            }
            case CONSTRUCTOR: {
                suffix = HOISTED_CONSTRUCTOR_SUFFIX;
                break;
            }
            default: {
                suffix = HOISTED_STATIC_SUFFIX;
            }
        }
        return this.createHoistedFunctionName(holderName, name, closureIdentifier, closureName, suffix);
    }

    private String createFieldOrMethodBaseName(Element field, boolean accessor) {
        String prefix = "";
        EnclosingElement enclosing = field.getEnclosingElement();
        if (ElementKind.of(enclosing).equals((Object)ElementKind.LIBRARY)) {
            prefix = this.mangleLibraryName((LibraryElement)enclosing);
        } else if (!accessor && field.getModifiers().isStatic()) {
            prefix = this.mangleClassName((ClassElement)enclosing);
        }
        return prefix + field.getName();
    }

    @Override
    public String mangleField(FieldElement field, LibraryElement currentLibrary) {
        return this.attachSuffix(this.createFieldOrMethodBaseName(field, false), FIELD_SUFFIX, this.isLibraryPrivate(field.getName()), currentLibrary);
    }

    @Override
    public String mangleMethod(MethodElement method, LibraryElement currentLibrary) {
        String methodName = method.getName();
        methodName = method.getModifiers().isOperator() ? this.createOperatorSyntax(methodName) : (method.getModifiers().isGetter() ? this.createGetterSyntax(methodName, currentLibrary) : (method.getModifiers().isSetter() ? this.createSetterSyntax(methodName, currentLibrary) : this.attachSuffix(methodName, METHOD_SUFFIX, currentLibrary)));
        String prefix = "";
        if (ElementKind.of(method.getEnclosingElement()).equals((Object)ElementKind.LIBRARY)) {
            prefix = this.mangleLibraryName((LibraryElement)method.getEnclosingElement());
        }
        return prefix + methodName;
    }

    @Override
    public String mangleNamedMethod(MethodElement method, LibraryElement currentLibrary) {
        String methodName = method.getName();
        methodName = this.attachSuffix(methodName, NAMED_SUFFIX, currentLibrary);
        String prefix = "";
        if (ElementKind.of(method.getEnclosingElement()).equals((Object)ElementKind.LIBRARY)) {
            prefix = this.mangleLibraryName((LibraryElement)method.getEnclosingElement());
        }
        return prefix + methodName;
    }

    @Override
    public String mangleNamedMethod(String methodName, LibraryElement currentLibrary) {
        return this.attachSuffix(methodName, NAMED_SUFFIX, currentLibrary);
    }

    @Override
    public String mangleEntryPoint(MethodElement method, LibraryElement library) {
        EnclosingElement holder = method.getEnclosingElement();
        switch (ElementKind.of(holder)) {
            case CLASS: {
                String mangledClassName = this.mangleClassName((ClassElement)holder);
                return mangledClassName + "." + this.mangleMethod(method.getName(), library);
            }
            case LIBRARY: {
                return this.mangleMethod(method, library);
            }
        }
        throw new InternalCompilerException("Unknown entry point kind" + method);
    }

    @Override
    public String createGetterSyntax(FieldElement field, LibraryElement currentLibrary) {
        return this.attachSuffix(this.createFieldOrMethodBaseName(field, true), GETTER_SUFFIX, this.isLibraryPrivate(field.getName()), currentLibrary);
    }

    @Override
    public String createGetterSyntax(MethodElement field, LibraryElement currentLibrary) {
        return this.attachSuffix(this.createFieldOrMethodBaseName(field, true), GETTER_SUFFIX, this.isLibraryPrivate(field.getName()), currentLibrary);
    }

    @Override
    public String createSetterSyntax(FieldElement field, LibraryElement currentLibrary) {
        return this.attachSuffix(this.createFieldOrMethodBaseName(field, true), SETTER_SUFFIX, this.isLibraryPrivate(field.getName()), currentLibrary);
    }

    @Override
    public String mangleMethod(String methodName, LibraryElement currentLibrary) {
        return this.attachSuffix(methodName, METHOD_SUFFIX, currentLibrary);
    }

    private static String getNegateOperator() {
        return "negate$operator";
    }

    @Override
    public String createOperatorSyntax(Token token) {
        return token.name() + OPERATOR_SUFFIX;
    }

    @Override
    public String createOperatorSyntax(String operation) {
        if (operation.equals("negate")) {
            return DollarMangler.getNegateOperator();
        }
        return Token.lookup(operation).name() + OPERATOR_SUFFIX;
    }

    @Override
    public String createGetterSyntax(String member, LibraryElement currentLibrary) {
        return this.attachSuffix(member, GETTER_SUFFIX, currentLibrary);
    }

    @Override
    public String createSetterSyntax(String member, LibraryElement currentLibrary) {
        return this.attachSuffix(member, SETTER_SUFFIX, currentLibrary);
    }

    @Override
    public String mangleNativeMethod(MethodElement element) {
        String elementName = element.getName();
        String encodedName = null;
        encodedName = element.getModifiers().isOperator() ? ("negate".equals(elementName) ? elementName : Token.lookup(elementName).name()) : (element.getModifiers().isGetter() ? "get$" + elementName : (element.getModifiers().isSetter() ? "set$" + elementName : elementName));
        String holderName = element.getEnclosingElement().getName();
        return NATIVE_PREFIX + holderName + "_" + encodedName;
    }

    @Override
    public String mangleRttLookupMethod(MethodElement method, LibraryElement currentLibrary) {
        return this.mangleNamedMethod(method, currentLibrary) + RTT_LOOKUP_NAME;
    }

    @Override
    public String mangleRttLookupMethod(String methodName, LibraryElement currentLibrary) {
        return this.mangleNamedMethod(methodName, currentLibrary) + RTT_LOOKUP_NAME;
    }
}

