/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.LimitInputStream;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.LibraryNode;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.backend.js.AbstractJsBackend;
import com.google.dart.compiler.backend.js.ClosureJsAst;
import com.google.dart.compiler.backend.js.ClosureJsCodingConvention;
import com.google.dart.compiler.backend.js.ClosureJsErrorCode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.metrics.CompilerMetrics;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WarningLevel;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClosureJsBackend
extends AbstractJsBackend {
    private static final String EXTENSION_OPT_JS = "opt.js";
    private static final String EXTENSION_OPT_JS_SRC_MAP = "opt.js.map";
    private Map<String, DartUnit> dartSrcToUnitMap = Maps.newHashMap();
    private long totalJsOutputCharCount;
    private final boolean generateHumanReadableOutput;
    private final boolean fastOutput;
    private final boolean incremental;
    private final boolean validate;
    private final boolean checkedMode;
    private static final List<String> DEFAULT_EXTERNS_NAMES = ImmutableList.of((Object)"es3.js", (Object)"es5.js", (Object)"w3c_event.js", (Object)"w3c_event3.js", (Object)"gecko_event.js", (Object)"ie_event.js", (Object)"webkit_event.js", (Object)"w3c_dom1.js", (Object)"w3c_dom2.js", (Object)"w3c_dom3.js", (Object)"gecko_dom.js", (Object)"ie_dom.js", (Object[])new String[]{"webkit_dom.js", "w3c_css.js", "gecko_css.js", "ie_css.js", "webkit_css.js", "google.js", "deprecated.js", "fileapi.js", "flash.js", "gears_symbols.js", "gears_types.js", "gecko_xml.js", "html5.js", "ie_vml.js", "iphone.js", "webstorage.js", "w3c_anim_timing.js", "w3c_css3d.js", "w3c_elementtraversal.js", "w3c_geolocation.js", "w3c_indexeddb.js", "w3c_navigation_timing.js", "w3c_range.js", "w3c_selectors.js", "w3c_xml.js", "window.js", "webkit_notifications.js", "webgl.js"});
    private static final String UNIT_TEST_EXTERN_STUBS = "var write;";
    private static final String CLOSURE_PRIMITIVES = "function JSCompiler_renameProperty() {};";
    private static final String MISSING_EXTERNS = "var JSON = {};\n/**\n * @param {string} jsonStr The string to parse.\n * @param {(function(string, *) : *)=} opt_reviver\n * @return {*} The JSON object.\n */\nJSON.parse = function(jsonStr, opt_reviver) {};\n\n/**\n * @param {*} jsonObj Input object.\n * @param {(Array.<string>|(function(string, *) : *)|null)=} opt_replacer\n * @param {(number|string)=} opt_space\n * @return {string} json string which represents jsonObj.\n */\nJSON.stringify = function(jsonObj, opt_replacer, opt_space) {};\n";

    public ClosureJsBackend() {
        this(false, false);
    }

    public ClosureJsBackend(boolean checkedMode, boolean generateHumanReadableOutput) {
        this(false, false, true, checkedMode, generateHumanReadableOutput);
    }

    public ClosureJsBackend(boolean fastOutput, boolean incremental, boolean validate, boolean checkedMode, boolean generateHumanReadableOutput) {
        this.fastOutput = fastOutput;
        this.incremental = incremental;
        this.validate = validate;
        this.checkedMode = checkedMode;
        this.generateHumanReadableOutput = generateHumanReadableOutput;
    }

    @Override
    public boolean isOutOfDate(DartSource src, DartCompilerContext context) {
        if (!this.incremental) {
            return true;
        }
        return super.isOutOfDate(src, context);
    }

    @Override
    public void compileUnit(DartUnit unit, DartSource src, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        if (!this.incremental) {
            this.dartSrcToUnitMap.put(src.getName(), unit);
        } else {
            super.compileUnit(unit, src, context, typeProvider);
        }
    }

    private Map<String, CompilerInput> createClosureJsAst(Map<String, JsProgram> parts, Source source) {
        String name = source.getName();
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"A source name is required");
        HashMap<String, CompilerInput> translatedParts = new HashMap<String, CompilerInput>();
        for (Map.Entry<String, JsProgram> part : parts.entrySet()) {
            String partName = part.getKey();
            String inputName = name + ':' + partName;
            ClosureJsAst sourceAst = new ClosureJsAst(part.getValue(), inputName, source, this.validate);
            CompilerInput input = new CompilerInput((SourceAst)sourceAst, false);
            translatedParts.put(part.getKey(), input);
        }
        return translatedParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageAppOptimized(LibrarySource app, Collection<LibraryUnit> libraries, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        LinkedList inputs = Lists.newLinkedList();
        HashMap sourcesByName = Maps.newHashMap();
        DepsWritingCallback callback = new DepsWritingCallback(context, typeProvider, inputs, sourcesByName);
        AbstractJsBackend.DependencyBuilder.build(context.getAppLibraryUnit(), callback);
        inputs.add(this.getCompilerInputForEntry(context));
        JSModule mainModule = new JSModule("main");
        for (CompilerInput input : inputs) {
            if (input == null) continue;
            mainModule.add(input);
        }
        Writer out = context.getArtifactWriter(app, "", this.getAppExtension());
        boolean failed = true;
        try {
            this.compileModule(app, context, mainModule, sourcesByName, out);
            failed = false;
        }
        finally {
            Closeables.close((Closeable)out, (boolean)failed);
        }
    }

    private Map<String, CompilerInput> translateUnit(DartUnit unit, DartSource src, DartCompilerContext context, CoreTypeProvider typeProvider) {
        Map<String, JsProgram> parts = this.translateToJS(unit, context, typeProvider);
        return this.createClosureJsAst(parts, src);
    }

    private CompilerInput getCompilerInputForEntry(DartCompilerContext context) throws IOException {
        StringWriter entry = new StringWriter();
        this.writeEntryPointCall(this.getMangledEntryPoint(context), entry);
        return new CompilerInput((SourceFile)JSSourceFile.fromCode((String)"entry", (String)entry.toString()), false);
    }

    private void compileModule(LibrarySource src, DartCompilerContext context, JSModule module, Map<String, Source> sourcesByName, Writer out) throws IOException {
        CompilerOptions options = this.getClosureCompilerOptions(context);
        Logger.getLogger("com.google.javascript.jscomp").setLevel(Level.OFF);
        Compiler compiler = new Compiler();
        List<JSSourceFile> externs = ClosureJsBackend.getDefaultExterns();
        LinkedList modules = Lists.newLinkedList();
        modules.add(module);
        compiler.disableThreads();
        Result result = compiler.compileModules(externs, (List)modules, options);
        if (this.processResults(src, context, compiler, result, module, out) != 0) {
            for (JSError error : result.errors) {
                Source source = sourcesByName.get(error.sourceName);
                if (source == null) {
                    source = new MockSource(error.sourceName);
                }
                System.err.println("error optimizing:" + error.toString());
                DartCompilationError dartError = new DartCompilationError(new JSErrorSourceInfo(error, source), (ErrorCode)ClosureJsErrorCode.INTERNAL_ERROR, error.description);
                context.onError(dartError);
            }
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processResults(LibrarySource src, DartCompilerContext context, Compiler compiler, Result result, JSModule module, Writer out) throws IOException {
        if (result.success) {
            String output = compiler.toSource(module);
            out.append(output);
            out.append('\n');
            if (this.generateSourceMap(context)) {
                Writer srcMapOut = context.getArtifactWriter(src, "", this.getSourceMapExtension());
                boolean failed = true;
                try {
                    compiler.getSourceMap().appendTo((Appendable)srcMapOut, module.getName());
                    failed = false;
                }
                finally {
                    Closeables.close((Closeable)srcMapOut, (boolean)failed);
                }
            }
            this.totalJsOutputCharCount = output.length();
        }
        return Math.min(result.errors.length, 127);
    }

    private CompilerOptions getClosureCompilerOptions(DartCompilerContext context) {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureJsCodingConvention());
        if (this.fastOutput) {
            options.smartNameRemoval = true;
            options.collapseProperties = true;
            options.removeUnusedPrototypeProperties = true;
            options.removeUnusedVars = true;
            options.setRenamingPolicy(VariableRenamingPolicy.ALL, PropertyRenamingPolicy.ALL_UNQUOTED);
            options.setReplaceIdGenerators(false);
        } else {
            CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
            options.setAssumeStrictThis(true);
            options.rewriteFunctionExpressions = false;
            options.aliasKeywords = false;
            options.setPropertyAffinity(false);
            options.computeFunctionSideEffects = false;
            options.devirtualizePrototypeMethods = true;
            options.inlineGetters = true;
            options.removeUnusedPrototypePropertiesInExterns = false;
        }
        if (this.generateSourceMap(context)) {
            options.sourceMapOutputPath = "placeholder";
            options.sourceMapDetailLevel = SourceMap.DetailLevel.SYMBOLS;
            options.sourceMapFormat = SourceMap.Format.V3;
        }
        options.closurePass = false;
        options.setInferTypes(false);
        options.checkTypes = false;
        options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, CheckLevel.OFF);
        options.checkSuspiciousCode = false;
        options.checkGlobalThisLevel = CheckLevel.OFF;
        options.checkMissingReturn = CheckLevel.OFF;
        options.checkGlobalNamesLevel = CheckLevel.OFF;
        options.aggressiveVarCheck = CheckLevel.OFF;
        options.setWarningLevel(DiagnosticGroups.DEPRECATED, CheckLevel.OFF);
        if (this.validate) {
            options.checkSymbols = true;
            options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.ERROR);
        } else {
            WarningLevel.QUIET.setOptionsForWarningLevel(options);
            options.checkSymbols = false;
            options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.OFF);
        }
        if (this.generateHumanReadableOutput) {
            options.prettyPrint = true;
            options.generatePseudoNames = true;
            options.printInputDelimiter = true;
            options.inputDelimiter = "// Input %name%";
        }
        if (this.checkedMode) {
            options.setReplaceIdGenerators(false);
        }
        return options;
    }

    private static List<JSSourceFile> getDefaultExterns() throws IOException {
        Class<ClosureJsBackend> clazz = ClosureJsBackend.class;
        InputStream input = clazz.getResourceAsStream("/com/google/javascript/jscomp/externs.zip");
        if (input == null) {
            input = clazz.getResourceAsStream("/externs.zip");
        }
        ZipInputStream zip = new ZipInputStream(input);
        HashMap externsMap = Maps.newHashMap();
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            BufferedInputStream entryStream = new BufferedInputStream((InputStream)new LimitInputStream((InputStream)zip, entry.getSize()));
            externsMap.put(entry.getName(), JSSourceFile.fromInputStream((String)("externs.zip//" + entry.getName()), (InputStream)entryStream));
        }
        Preconditions.checkState((boolean)((Object)externsMap.keySet()).equals(Sets.newHashSet(DEFAULT_EXTERNS_NAMES)), (Object)"Externs zip must match our hard-coded list of externs.");
        ArrayList externs = Lists.newArrayList();
        for (String key : DEFAULT_EXTERNS_NAMES) {
            externs.add(externsMap.get(key));
        }
        externs.add(JSSourceFile.fromCode((String)"missingExterns", (String)MISSING_EXTERNS));
        externs.add(JSSourceFile.fromCode((String)"unitTestStubs", (String)UNIT_TEST_EXTERN_STUBS));
        externs.add(JSSourceFile.fromCode((String)"closureCompilerPrimitives", (String)CLOSURE_PRIMITIVES));
        return externs;
    }

    @Override
    public void packageApp(LibrarySource app, Collection<LibraryUnit> libraries, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        this.totalJsOutputCharCount = 0L;
        this.packageAppOptimized(app, libraries, context, typeProvider);
        CompilerMetrics compilerMetrics = context.getCompilerMetrics();
        if (compilerMetrics != null) {
            compilerMetrics.packagedJsApplication(this.totalJsOutputCharCount, -1L);
        }
    }

    @Override
    public String getAppExtension() {
        return this.incremental ? "app.js" : EXTENSION_OPT_JS;
    }

    @Override
    public String getSourceMapExtension() {
        return this.incremental ? "app.js.map" : EXTENSION_OPT_JS_SRC_MAP;
    }

    @Override
    protected boolean shouldOptimize() {
        return !this.fastOutput;
    }

    @Override
    protected boolean generateClosureCompatibleCode() {
        return true;
    }

    static class JSErrorSourceInfo
    implements SourceInfo {
        final JSError error;
        final Source source;

        JSErrorSourceInfo(JSError error, Source source) {
            this.error = error;
            this.source = source;
        }

        @Override
        public Source getSource() {
            return this.source;
        }

        @Override
        public int getSourceColumn() {
            return this.error.getCharno();
        }

        @Override
        public int getSourceLength() {
            return -1;
        }

        @Override
        public int getSourceLine() {
            return this.error.lineNumber;
        }

        @Override
        public int getSourceStart() {
            return -1;
        }
    }

    class MockSource
    implements Source {
        private String sourceName;

        MockSource(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.sourceName;
        }

        @Override
        public Reader getSourceReader() {
            return new StringReader("");
        }

        @Override
        public URI getUri() {
            return null;
        }
    }

    private class DepsWritingCallback
    implements AbstractJsBackend.DepsCallback {
        private final DartCompilerContext context;
        private final CoreTypeProvider typeProvider;
        private final List<CompilerInput> inputs;
        private final Map<String, Source> sourcesByName;
        private final Map<DartUnit, Map<String, CompilerInput>> translatedUnits = Maps.newHashMap();

        DepsWritingCallback(DartCompilerContext context, CoreTypeProvider typeProvider, List<CompilerInput> inputs, Map<String, Source> sourcesByName) {
            this.context = context;
            this.typeProvider = typeProvider;
            this.inputs = inputs;
            this.sourcesByName = sourcesByName;
        }

        @Override
        public void visitNative(LibraryUnit libUnit, LibraryNode node) throws IOException {
            String name = node.getText();
            DartSource nativeSrc = libUnit.getSource().getSourceFor(name);
            StringWriter w = new StringWriter();
            Reader r = nativeSrc.getSourceReader();
            CharStreams.copy((Readable)r, (Appendable)w);
            this.inputs.add(new CompilerInput((SourceFile)this.createSource(name, w), false));
        }

        @Override
        public void visitPart(AbstractJsBackend.Part part) throws IOException {
            DartSource src = part.unit.getSource();
            if (!ClosureJsBackend.this.incremental) {
                Map translatedParts = this.translatedUnits.get(part.unit);
                if (translatedParts == null) {
                    assert (!this.sourcesByName.containsKey(src.getName()));
                    this.sourcesByName.put(src.getName(), src);
                    Preconditions.checkNotNull((Object)part.unit, (Object)("src: " + src.getName()));
                    translatedParts = ClosureJsBackend.this.translateUnit(part.unit, src, this.context, this.typeProvider);
                    Preconditions.checkState((!this.translatedUnits.containsKey(part.unit) ? 1 : 0) != 0);
                    this.translatedUnits.put(part.unit, translatedParts);
                }
                this.inputs.add(translatedParts.get(part.part));
                return;
            }
            Reader r = this.context.getArtifactReader(src, part.part, "js");
            if (r == null) {
                return;
            }
            StringWriter w = new StringWriter();
            CharStreams.copy((Readable)r, (Appendable)w);
            String inputName = src.getName() + ':' + part.part;
            this.inputs.add(new CompilerInput((SourceFile)this.createSource(inputName, w), false));
        }

        private JSSourceFile createSource(String name, Writer w) {
            return JSSourceFile.fromCode((String)name, (String)w.toString());
        }
    }
}

