/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.common.base.Preconditions;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBooleanLiteral;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsCase;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsDebugger;
import com.google.dart.compiler.backend.js.ast.JsDefault;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExprStmt;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsForIn;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsRegExp;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsSwitch;
import com.google.dart.compiler.backend.js.ast.JsSwitchMember;
import com.google.dart.compiler.backend.js.ast.JsThisRef;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsWhile;
import com.google.dart.compiler.common.HasSymbol;
import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.common.Symbol;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.SimpleSourceFile;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClosureJsAstTranslator {
    private final Map<Source, StaticSourceFile> sourceCache = new HashMap<Source, StaticSourceFile>();
    private final boolean validate;

    ClosureJsAstTranslator(boolean validate) {
        this.validate = validate;
    }

    private StaticSourceFile getClosureSourceFile(Source source) {
        StaticSourceFile closureSourceFile = this.sourceCache.get(source);
        if (closureSourceFile == null) {
            closureSourceFile = new SimpleSourceFile(source.getName(), false);
            this.sourceCache.put(source, closureSourceFile);
        }
        return closureSourceFile;
    }

    public Node translate(JsProgram program, InputId inputId, Source source) {
        Node script = new Node(132);
        script.putBooleanProp(38, true);
        script.setInputId(inputId);
        script.putProp(16, (Object)source.getName());
        script.setStaticSourceFile(this.getClosureSourceFile(source));
        for (JsStatement s : program.getGlobalBlock().getStatements()) {
            script.addChildToBack(this.transform(s));
        }
        if (this.validate) {
            new AstValidator().validateScript(script);
        }
        return script;
    }

    private Node transform(JsStatement x) {
        switch (x.getKind()) {
            case BLOCK: {
                return this.transform((JsBlock)x);
            }
            case BREAK: {
                return this.transform((JsBreak)x);
            }
            case CONTINUE: {
                return this.transform((JsContinue)x);
            }
            case DEBUGGER: {
                return this.transform((JsDebugger)x);
            }
            case DO: {
                return this.transform((JsDoWhile)x);
            }
            case EMPTY: {
                return this.transform((JsEmpty)x);
            }
            case EXPR_STMT: {
                return this.transform((JsExprStmt)x);
            }
            case FOR: {
                return this.transform((JsFor)x);
            }
            case FOR_IN: {
                return this.transform((JsForIn)x);
            }
            case IF: {
                return this.transform((JsIf)x);
            }
            case LABEL: {
                return this.transform((JsLabel)x);
            }
            case RETURN: {
                return this.transform((JsReturn)x);
            }
            case SWITCH: {
                return this.transform((JsSwitch)x);
            }
            case THROW: {
                return this.transform((JsThrow)x);
            }
            case TRY: {
                return this.transform((JsTry)x);
            }
            case VARS: {
                return this.transform((JsVars)x);
            }
            case WHILE: {
                return this.transform((JsWhile)x);
            }
        }
        throw new IllegalStateException("Unexpected statement type: " + x.getClass().getSimpleName());
    }

    private Node transform(JsExpression x) {
        assert (x != null);
        switch (x.getKind()) {
            case ARRAY: {
                return this.transform((JsArrayLiteral)x);
            }
            case ARRAY_ACCESS: {
                return this.transform((JsArrayAccess)x);
            }
            case BINARY_OP: {
                return this.transform((JsBinaryOperation)x);
            }
            case CONDITIONAL: {
                return this.transform((JsConditional)x);
            }
            case INVOKE: {
                return this.transform((JsInvocation)x);
            }
            case FUNCTION: {
                return this.transform((JsFunction)x);
            }
            case OBJECT: {
                return this.transform((JsObjectLiteral)x);
            }
            case BOOLEAN: {
                return this.transform((JsBooleanLiteral)x);
            }
            case NULL: {
                return this.transform((JsNullLiteral)x);
            }
            case NUMBER: {
                return this.transform((JsNumberLiteral)x);
            }
            case REGEXP: {
                return this.transform((JsRegExp)x);
            }
            case STRING: {
                return this.transform((JsStringLiteral)x);
            }
            case THIS: {
                return this.transform((JsThisRef)x);
            }
            case NAME_REF: {
                return this.transform((JsNameRef)x);
            }
            case NEW: {
                return this.transform((JsNew)x);
            }
            case POSTFIX_OP: {
                return this.transform((JsPostfixOperation)x);
            }
            case PREFIX_OP: {
                return this.transform((JsPrefixOperation)x);
            }
        }
        throw new IllegalStateException("Unexpected expression type: " + x.getClass().getSimpleName());
    }

    private Node transform(JsSwitchMember x) {
        switch (x.getKind()) {
            case CASE: {
                return this.transform((JsCase)x);
            }
            case DEFAULT: {
                return this.transform((JsDefault)x);
            }
        }
        throw new IllegalStateException("Unexpected switch member type: " + x.getClass().getSimpleName());
    }

    private Node transform(JsArrayAccess x) {
        Node n = new Node(35, this.transform(x.getArrayExpr()), this.transform(x.getIndexExpr()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsArrayLiteral x) {
        Node n = new Node(63);
        Iterator<JsExpression> i$ = x.getExpressions().iterator();
        while (i$.hasNext()) {
            JsExpression element;
            JsExpression arg = element = i$.next();
            n.addChildToBack(this.transform(arg));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsBinaryOperation x) {
        JsBinaryOperator op = x.getOperator();
        Node n = new Node(this.getTokenForOp(op), this.transform(x.getArg1()), this.transform(x.getArg2()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsBlock x) {
        Node n = new Node(125);
        for (JsStatement s : x.getStatements()) {
            n.addChildToBack(this.transform(s));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsBooleanLiteral x) {
        Node n = new Node(x.getValue() ? 44 : 43);
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsBreak x) {
        Node n = new Node(116);
        JsNameRef label = x.getLabel();
        if (label != null) {
            n.addChildToBack(this.transformLabel(label));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsCase x) {
        Node n = new Node(111);
        n.addChildToBack(this.transform(x.getCaseExpr()));
        Node body = new Node(125);
        body.putBooleanProp(38, true);
        this.applySourceInfo(body, x);
        n.addChildToBack(body);
        Iterator<JsStatement> i$ = x.getStmts().iterator();
        while (i$.hasNext()) {
            JsStatement element;
            JsStatement stmt = element = i$.next();
            body.addChildToBack(this.transform(stmt));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsCatch x) {
        Node n = new Node(120, this.transformName(x.getParameter().getName()), this.transform(x.getBody()));
        Preconditions.checkState((x.getCondition() == null ? 1 : 0) != 0);
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsConditional x) {
        Node n = new Node(98, this.transform(x.getTestExpression()), this.transform(x.getThenExpression()), this.transform(x.getElseExpression()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsContinue x) {
        Node n = new Node(117);
        JsNameRef label = x.getLabel();
        if (label != null) {
            n.addChildToBack(this.transformLabel(label));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsDebugger x) {
        Node n = new Node(152);
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsDefault x) {
        Node n = new Node(112);
        Node body = new Node(125);
        body.putBooleanProp(38, true);
        this.applySourceInfo(body, x);
        n.addChildToBack(body);
        Iterator<JsStatement> i$ = x.getStmts().iterator();
        while (i$.hasNext()) {
            JsStatement element;
            JsStatement stmt = element = i$.next();
            body.addChildToBack(this.transform(stmt));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsDoWhile x) {
        Node n = new Node(114, this.transformBody(x.getBody(), x), this.transform(x.getCondition()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsEmpty x) {
        return new Node(124);
    }

    private Node transform(JsExprStmt x) {
        Node expr = this.transform(x.getExpression());
        if (expr.getType() != 105) {
            return new Node(130, expr);
        }
        return expr;
    }

    private Node transform(JsFor x) {
        Node n = new Node(115);
        if (x.getInitExpr() != null) {
            n.addChildToBack(this.transform(x.getInitExpr()));
        } else if (x.getInitVars() != null) {
            n.addChildToBack(this.transform(x.getInitVars()));
        } else {
            n.addChildToBack(new Node(124));
        }
        if (x.getCondition() != null) {
            n.addChildToBack(this.transform(x.getCondition()));
        } else {
            n.addChildToBack(new Node(124));
        }
        if (x.getIncrExpr() != null) {
            n.addChildToBack(this.transform(x.getIncrExpr()));
        } else {
            n.addChildToBack(new Node(124));
        }
        n.addChildToBack(this.transformBody(x.getBody(), x));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsForIn x) {
        Node n = new Node(115);
        if (x.getIterVarName() != null) {
            Node expr = new Node(118, this.transformName(x.getIterVarName()));
            n.addChildToBack(expr);
        } else {
            n.addChildToBack(this.transform(x.getIterExpr()));
        }
        n.addChildToBack(this.transform(x.getObjExpr()));
        n.addChildToBack(this.transformBody(x.getBody(), x));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsFunction x) {
        Node n = new Node(105);
        if (x.getName() != null) {
            n.addChildToBack(this.getNameNodeFor(x));
            this.applyOriginalName(n, x);
        } else {
            Node emptyName = Node.newString((int)38, (String)"");
            this.applySourceInfo(emptyName, x);
            n.addChildToBack(emptyName);
            n.putProp(40, (Object)"");
        }
        Node params = new Node(83);
        Iterator<JsParameter> i$ = x.getParameters().iterator();
        while (i$.hasNext()) {
            JsParameter element;
            JsParameter param = element = i$.next();
            params.addChildToBack(this.transform(param));
        }
        this.applySourceInfo(n, x);
        n.addChildToBack(params);
        n.addChildToBack(this.transform(x.getBody()));
        if (x.isConstructor()) {
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordConstructor();
            n.setJSDocInfo(builder.build(n));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsIf x) {
        Node n = new Node(108, this.transform(x.getIfExpr()), this.transformBody(x.getThenStmt(), x));
        if (x.getElseStmt() != null) {
            n.addChildToBack(this.transformBody(x.getElseStmt(), x));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsInvocation x) {
        Node n = new Node(37, this.transform(x.getQualifier()));
        Iterator<JsExpression> i$ = x.getArguments().iterator();
        while (i$.hasNext()) {
            JsExpression element;
            JsExpression arg = element = i$.next();
            n.addChildToBack(this.transform(arg));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsLabel x) {
        Node n = new Node(126, this.transformLabel(x.getName()), this.transform(x.getStmt()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsNameRef x) {
        Node n = x.getQualifier() != null ? new Node(33, this.transform(x.getQualifier()), this.transformNameAsString(x.getShortIdent(), x)) : this.transformName(x.getShortIdent(), x);
        this.applyOriginalName(n, x);
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsNew x) {
        Node n = new Node(30, this.transform(x.getConstructorExpression()));
        Iterator<JsExpression> i$ = x.getArguments().iterator();
        while (i$.hasNext()) {
            JsExpression element;
            JsExpression arg = element = i$.next();
            n.addChildToBack(this.transform(arg));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsNullLiteral x) {
        return new Node(41);
    }

    private Node transform(JsNumberLiteral x) {
        return Node.newNumber((double)x.getValue());
    }

    private Node transform(JsObjectLiteral x) {
        Node n = new Node(64);
        for (JsPropertyInitializer element : x.getPropertyInitializers()) {
            JsPropertyInitializer propInit = element;
            Node key = this.transform(propInit.getLabelExpr());
            Preconditions.checkState((key.getType() == 40 ? 1 : 0) != 0);
            key.addChildToBack(this.transform(propInit.getValueExpr()));
            n.addChildToBack(key);
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsParameter x) {
        return this.getNameNodeFor(x);
    }

    private Node transform(JsPostfixOperation x) {
        Node n = new Node(this.getTokenForOp(x.getOperator()), this.transform(x.getArg()));
        n.putBooleanProp(32, true);
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsPrefixOperation x) {
        Node n = new Node(this.getTokenForOp(x.getOperator()), this.transform(x.getArg()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsRegExp x) {
        String flags = x.getFlags();
        Node n = new Node(47, Node.newString((String)x.getPattern()), Node.newString((String)(flags != null ? x.getFlags() : "")));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsReturn x) {
        Node n = new Node(4);
        JsExpression result = x.getExpr();
        if (result != null) {
            n.addChildToBack(this.transform(x.getExpr()));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsStringLiteral x) {
        return Node.newString((String)x.getValue());
    }

    private Node transform(JsSwitch x) {
        Node n = new Node(110, this.transform(x.getExpr()));
        for (JsSwitchMember member : x.getCases()) {
            n.addChildToBack(this.transform(member));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsThisRef x) {
        Node n = new Node(42);
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsThrow x) {
        Node n = new Node(49, this.transform(x.getExpr()));
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsTry x) {
        Node n = new Node(77, this.transform(x.getTryBlock()));
        Node catches = new Node(125);
        for (JsCatch catchBlock : x.getCatches()) {
            catches.addChildToBack(this.transform(catchBlock));
        }
        n.addChildToBack(catches);
        JsBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            n.addChildToBack(this.transform(finallyBlock));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsVars.JsVar x) {
        Node n = this.getNameNodeFor(x);
        JsExpression initExpr = x.getInitExpr();
        if (initExpr != null) {
            n.addChildToBack(this.transform(initExpr));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsVars x) {
        Node n = new Node(118);
        for (JsVars.JsVar var : x) {
            n.addChildToBack(this.transform(var));
        }
        return this.applySourceInfo(n, x);
    }

    private Node transform(JsWhile x) {
        Node n = new Node(113, this.transform(x.getCondition()), this.transformBody(x.getBody(), x));
        return this.applySourceInfo(n, x);
    }

    private Node transformBody(JsStatement x, SourceInfo parent) {
        Node n = this.transform(x);
        if (n.getType() != 125) {
            Node stmt = n;
            n = new Node(125);
            if (n.getType() != 124) {
                n.addChildToBack(stmt);
            }
            this.applySourceInfo(n, parent);
        }
        return n;
    }

    private Node transformLabel(JsNameRef label) {
        Node n = Node.newString((int)153, (String)this.getName(label));
        return this.applySourceInfo(n, label);
    }

    private Node transformLabel(JsName label) {
        Node n = Node.newString((int)153, (String)this.getName(label));
        return this.applySourceInfo(n, label.getStaticRef());
    }

    private Node transformName(JsName name) {
        Node n = Node.newString((int)38, (String)this.getName(name));
        return this.applySourceInfo(n, name.getStaticRef());
    }

    private Node transformName(String name, SourceInfo info) {
        Node n = Node.newString((int)38, (String)name);
        return this.applySourceInfo(n, info);
    }

    private Node transformNameAsString(String name, SourceInfo info) {
        Node n = Node.newString((String)name);
        return this.applySourceInfo(n, info);
    }

    private Node getNameNodeFor(HasName hasName) {
        Node n = Node.newString((int)38, (String)this.getName(hasName.getName()));
        this.applyOriginalName(n, (JsNode)((Object)hasName));
        return this.applySourceInfo(n, (SourceInfo)((Object)hasName));
    }

    private String getName(JsName name) {
        return name.getShortIdent();
    }

    private String getName(JsNameRef name) {
        return name.getShortIdent();
    }

    private int getTokenForOp(JsUnaryOperator op) {
        switch (op) {
            case BIT_NOT: {
                return 27;
            }
            case DEC: {
                return 103;
            }
            case DELETE: {
                return 31;
            }
            case INC: {
                return 102;
            }
            case NEG: {
                return 29;
            }
            case POS: {
                return 28;
            }
            case NOT: {
                return 26;
            }
            case TYPEOF: {
                return 32;
            }
            case VOID: {
                return 122;
            }
        }
        throw new IllegalStateException();
    }

    private int getTokenForOp(JsBinaryOperator op) {
        switch (op) {
            case MUL: {
                return 23;
            }
            case DIV: {
                return 24;
            }
            case MOD: {
                return 25;
            }
            case ADD: {
                return 21;
            }
            case SUB: {
                return 22;
            }
            case SHL: {
                return 18;
            }
            case SHR: {
                return 19;
            }
            case SHRU: {
                return 20;
            }
            case LT: {
                return 14;
            }
            case LTE: {
                return 15;
            }
            case GT: {
                return 16;
            }
            case GTE: {
                return 17;
            }
            case INSTANCEOF: {
                return 52;
            }
            case INOP: {
                return 51;
            }
            case EQ: {
                return 12;
            }
            case NEQ: {
                return 13;
            }
            case REF_EQ: {
                return 45;
            }
            case REF_NEQ: {
                return 46;
            }
            case BIT_AND: {
                return 11;
            }
            case BIT_XOR: {
                return 10;
            }
            case BIT_OR: {
                return 9;
            }
            case AND: {
                return 101;
            }
            case OR: {
                return 100;
            }
            case ASG: {
                return 86;
            }
            case ASG_ADD: {
                return 93;
            }
            case ASG_SUB: {
                return 94;
            }
            case ASG_MUL: {
                return 95;
            }
            case ASG_DIV: {
                return 96;
            }
            case ASG_MOD: {
                return 97;
            }
            case ASG_SHL: {
                return 90;
            }
            case ASG_SHR: {
                return 91;
            }
            case ASG_SHRU: {
                return 92;
            }
            case ASG_BIT_AND: {
                return 89;
            }
            case ASG_BIT_OR: {
                return 87;
            }
            case ASG_BIT_XOR: {
                return 88;
            }
            case COMMA: {
                return 85;
            }
        }
        return 0;
    }

    private Node applyOriginalName(Node n, JsNode x) {
        Symbol symbol;
        if (x instanceof HasSymbol && (symbol = ((HasSymbol)((Object)x)).getSymbol()) != null) {
            String originalName = symbol.getOriginalSymbolName();
            n.putProp(40, (Object)originalName);
        }
        return n;
    }

    private Node applySourceInfo(Node n, SourceInfo info) {
        if (info != null && info.getSource() != null) {
            n.setStaticSourceFile(this.getClosureSourceFile(info.getSource()));
            n.setLineno(info.getSourceLine());
            n.setCharno(info.getSourceColumn());
        }
        return n;
    }
}

