/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.Source;
import com.google.dart.compiler.backend.js.ClosureJsAstTranslator;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;

public class ClosureJsAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private Node root;
    private final JsProgram program;
    private final Source source;
    private final InputId inputId;
    private final boolean validate;

    public ClosureJsAst(JsProgram program, String inputName, Source source, boolean validate) {
        assert (inputName != null);
        this.program = program;
        this.source = source;
        this.inputId = new InputId(inputName);
        this.validate = validate;
    }

    public void clearAst() {
        this.root = null;
    }

    public Node getAstRoot(AbstractCompiler compiler) {
        if (this.root == null) {
            this.createAst(compiler);
        }
        return this.root;
    }

    public InputId getInputId() {
        return this.inputId;
    }

    public SourceFile getSourceFile() {
        return null;
    }

    public void setSourceFile(SourceFile file) {
        throw new UnsupportedOperationException("ClosureJsAst cannot be associated with a SourceFile instance.");
    }

    public String getSourceName() {
        return this.source.getName();
    }

    private void createAst(AbstractCompiler compiler) {
        this.root = new ClosureJsAstTranslator(this.validate).translate(this.program, this.inputId, this.source);
    }
}

