/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.InternalCompilerException;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBooleanLiteral;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsRegExp;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThisRef;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Cloner
extends JsVisitor {
    protected final Stack<JsExpression> stack = new Stack();
    private boolean successful = true;

    public static JsExpression clone(JsExpression expression) {
        Cloner c = new Cloner();
        c.accept(expression);
        return c.getExpression();
    }

    @Override
    public void endVisit(JsArrayAccess x, JsContext ctx) {
        JsArrayAccess newExpression = new JsArrayAccess();
        newExpression.setIndexExpr(this.stack.pop());
        newExpression.setArrayExpr(this.stack.pop());
        this.stack.push(newExpression);
    }

    @Override
    public void endVisit(JsArrayLiteral x, JsContext ctx) {
        JsArrayLiteral toReturn = new JsArrayLiteral();
        List<JsExpression> expressions = toReturn.getExpressions();
        int size = x.getExpressions().size();
        while (size-- > 0) {
            expressions.add(0, this.stack.pop());
        }
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsBinaryOperation x, JsContext ctx) {
        JsBinaryOperation toReturn = new JsBinaryOperation(x.getOperator());
        toReturn.setArg2(this.stack.pop());
        toReturn.setArg1(this.stack.pop());
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsBooleanLiteral x, JsContext ctx) {
        this.stack.push(x);
    }

    @Override
    public void endVisit(JsConditional x, JsContext ctx) {
        JsConditional toReturn = new JsConditional();
        toReturn.setElseExpression(this.stack.pop());
        toReturn.setThenExpression(this.stack.pop());
        toReturn.setTestExpression(this.stack.pop());
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsFunction x, JsContext ctx) {
        this.successful = false;
        this.stack.push(null);
    }

    @Override
    public void endVisit(JsInvocation x, JsContext ctx) {
        JsInvocation toReturn = new JsInvocation();
        List<JsExpression> params = toReturn.getArguments();
        int size = x.getArguments().size();
        while (size-- > 0) {
            params.add(0, this.stack.pop());
        }
        toReturn.setQualifier(this.stack.pop());
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsNameRef x, JsContext ctx) {
        JsName name = x.getName();
        JsNameRef toReturn = name != null ? new JsNameRef(name) : new JsNameRef(x.getIdent());
        if (x.getQualifier() != null) {
            toReturn.setQualifier(this.stack.pop());
        }
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsNew x, JsContext ctx) {
        int size = x.getArguments().size();
        ArrayList<JsExpression> arguments = new ArrayList<JsExpression>(size);
        while (size-- > 0) {
            arguments.add(0, this.stack.pop());
        }
        JsNew toReturn = new JsNew(this.stack.pop());
        toReturn.getArguments().addAll(arguments);
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsNullLiteral x, JsContext ctx) {
        this.stack.push(x);
    }

    @Override
    public void endVisit(JsNumberLiteral x, JsContext ctx) {
        this.stack.push(x);
    }

    @Override
    public void endVisit(JsObjectLiteral x, JsContext ctx) {
        JsObjectLiteral toReturn = new JsObjectLiteral();
        List<JsPropertyInitializer> inits = toReturn.getPropertyInitializers();
        int size = x.getPropertyInitializers().size();
        while (size-- > 0) {
            JsPropertyInitializer newInit = new JsPropertyInitializer();
            newInit.setValueExpr(this.stack.pop());
            newInit.setLabelExpr(this.stack.pop());
            inits.add(0, newInit);
        }
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsPostfixOperation x, JsContext ctx) {
        JsPostfixOperation toReturn = new JsPostfixOperation(x.getOperator());
        toReturn.setArg(this.stack.pop());
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsPrefixOperation x, JsContext ctx) {
        JsPrefixOperation toReturn = new JsPrefixOperation(x.getOperator());
        toReturn.setArg(this.stack.pop());
        this.stack.push(toReturn);
    }

    @Override
    public void endVisit(JsRegExp x, JsContext ctx) {
        this.stack.push(x);
    }

    @Override
    public void endVisit(JsStringLiteral x, JsContext ctx) {
        this.stack.push(x);
    }

    @Override
    public void endVisit(JsThisRef x, JsContext ctx) {
        this.stack.push(new JsThisRef());
    }

    public JsExpression getExpression() {
        return this.successful && this.checkStack() ? this.stack.peek() : null;
    }

    private boolean checkStack() {
        if (this.stack.size() > 1) {
            throw new InternalCompilerException("Too many expressions on stack");
        }
        return this.stack.size() == 1;
    }
}

