/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.common.collect.Sets;
import com.google.dart.compiler.ast.DartArrayAccess;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNullLiteral;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.backend.common.TypeHeuristic;
import com.google.dart.compiler.backend.common.TypeHeuristicImplementation;
import com.google.dart.compiler.backend.js.OptimizationStrategy;
import com.google.dart.compiler.parser.Token;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.ConstructorElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FieldElement;
import com.google.dart.compiler.resolver.MethodElement;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeKind;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class BasicOptimizationStrategy
implements OptimizationStrategy {
    private final TypeHeuristic typeHeuristic;
    private final CoreTypeProvider typeProvider;
    private static final String NUMBER_IMPLEMENTATION = "NumberImplementation";
    private static final String STRING_IMPLEMENTATION = "StringImplementation";
    private static final String BOOL_IMPLEMENTATION = "BoolImplementation";

    public BasicOptimizationStrategy(DartUnit unit, CoreTypeProvider typeProvider) {
        this.typeHeuristic = new TypeHeuristicImplementation(unit, typeProvider);
        this.typeProvider = typeProvider;
    }

    @Override
    public boolean canSkipOperatorShim(DartBinaryExpression x) {
        Token operator = x.getOperator();
        switch (operator) {
            case SHL: 
            case SAR: 
            case SHR: 
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case LT: 
            case GT: 
            case LTE: 
            case GTE: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: {
                return this.isNumericType(x.getArg1()) && this.isNumericType(x.getArg2());
            }
            case OR: 
            case AND: {
                return this.isNumericType(x.getArg1()) && this.isNumericType(x.getArg2()) || this.isBooleanType(x.getArg1()) && this.isBooleanType(x.getArg2());
            }
            case NE: 
            case EQ: {
                DartExpression lhs = x.getArg1();
                DartExpression rhs = x.getArg2();
                return this.isNumericType(lhs) && (this.isNumericType(rhs) || this.isNullLiteral(rhs)) || this.isStringType(lhs) && (this.isStringType(rhs) || this.isNullLiteral(rhs)) || this.isBooleanType(lhs) && (this.isBooleanType(rhs) || this.isNullLiteral(rhs)) || this.isNullLiteral(lhs) || this.hasSingleImplementation(x);
            }
            case EQ_STRICT: 
            case NE_STRICT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canSkipOperatorShim(DartUnaryExpression x) {
        Token op = x.getOperator();
        switch (op) {
            case SUB: 
            case BIT_NOT: {
                return this.isNumericType(x.getArg()) && this.hasSingleImplementation(x);
            }
            case INC: 
            case DEC: {
                assert (!op.isUserDefinableOperator());
                return this.isNumericType(x.getArg());
            }
            case NOT: {
                assert (!op.isUserDefinableOperator());
                return this.isBooleanType(x.getArg());
            }
        }
        return false;
    }

    @Override
    public boolean canSkipArrayAccessShim(DartArrayAccess array, boolean isAssignee) {
        Set<MethodElement> impls = this.typeHeuristic.getImplementationsOf(array);
        if (impls != null && impls.size() == 1) {
            MethodElement impl = impls.iterator().next();
            Element arrayElement = TypeHeuristicImplementation.maybeGetTargetElement(array);
            if (isAssignee && (arrayElement == null || arrayElement.getModifiers().isFinal())) {
                return false;
            }
            return impl.getEnclosingElement().equals(this.typeProvider.getObjectArrayType().getElement());
        }
        return false;
    }

    private boolean isStringType(DartExpression expr) {
        return this.isSingleType(expr, STRING_IMPLEMENTATION);
    }

    static boolean isStringType(Set<Type> types) {
        return BasicOptimizationStrategy.isSingleType(types, STRING_IMPLEMENTATION);
    }

    private boolean isBooleanType(DartExpression expr) {
        return this.isSingleType(expr, BOOL_IMPLEMENTATION);
    }

    static boolean isBooleanType(Set<Type> types) {
        return BasicOptimizationStrategy.isSingleType(types, BOOL_IMPLEMENTATION);
    }

    private boolean isNumericType(DartExpression expr) {
        return BasicOptimizationStrategy.isSingleType(this.typeHeuristic.getTypesOf(expr), NUMBER_IMPLEMENTATION);
    }

    static boolean isNumericType(Set<Type> types) {
        return BasicOptimizationStrategy.isSingleType(types, NUMBER_IMPLEMENTATION);
    }

    private boolean isSingleType(DartExpression expr, String className) {
        Set<Type> types = this.typeHeuristic.getTypesOf(expr);
        return BasicOptimizationStrategy.isSingleType(types, className);
    }

    private boolean hasSingleImplementation(DartBinaryExpression expr) {
        Set<MethodElement> impl = this.typeHeuristic.getImplementationsOf(expr);
        return impl != null && impl.size() == 1;
    }

    private boolean isNullLiteral(DartExpression expr) {
        return expr instanceof DartNullLiteral;
    }

    private static boolean isSingleType(Set<Type> types, String className) {
        if (types.size() != 1) {
            return false;
        }
        Type type = types.iterator().next();
        if (type.getKind() == TypeKind.INTERFACE) {
            return className.equals(type.getElement().getName());
        }
        return false;
    }

    @Override
    public FieldElement findOptimizableFieldElementFor(DartExpression expr, TypeHeuristic.FieldKind fieldKind) {
        HashSet visited = Sets.newHashSet();
        FieldElement field = this.maybeGetInlineableField(expr, fieldKind, visited);
        visited = null;
        return field;
    }

    private FieldElement maybeGetInlineableField(DartExpression expr, TypeHeuristic.FieldKind fieldKind, Set<DartNode> visited) {
        if (expr.getParent() instanceof DartFunctionObjectInvocation) {
            return null;
        }
        Set<FieldElement> impls = this.typeHeuristic.getFieldImplementationsOf(expr, fieldKind);
        if (impls != null && impls.size() == 1) {
            FieldElement field = impls.iterator().next();
            if (this.isFieldInlinable(field, fieldKind)) {
                return field;
            }
            if (this.isWhitelistedNativeField(field, fieldKind)) {
                return field;
            }
            FieldElement backingField = this.maybeGetNonAbstractFieldGetter(field, fieldKind, visited);
            if (backingField != null) {
                return backingField;
            }
        }
        return null;
    }

    private FieldElement maybeGetNonAbstractFieldGetter(FieldElement field, TypeHeuristic.FieldKind fieldKind, Set<DartNode> visited) {
        DartStatement stmt;
        DartFunction fnGetter;
        DartMethodDefinition getter;
        if (visited.contains(field.getNode())) {
            return null;
        }
        visited.add(field.getNode());
        if (field.getModifiers().isAbstractField() && fieldKind.equals((Object)TypeHeuristic.FieldKind.GETTER) && field.getGetter() != null && (getter = (DartMethodDefinition)field.getGetter().getNode()) != null && getter.getFunction() != null && (fnGetter = getter.getFunction()).getBody() != null && fnGetter.getBody().getStatements() != null && fnGetter.getBody().getStatements().size() == 1 && (stmt = fnGetter.getBody().getStatements().iterator().next()) instanceof DartReturnStatement) {
            DartPropertyAccess propAccess;
            DartReturnStatement returnStmt = (DartReturnStatement)stmt;
            DartExpression retExpr = returnStmt.getValue();
            if (retExpr instanceof DartIdentifier) {
                return this.maybeGetInlineableField(retExpr, fieldKind, visited);
            }
            if (retExpr instanceof DartPropertyAccess && (propAccess = (DartPropertyAccess)retExpr).getQualifier() instanceof DartThisExpression) {
                return this.maybeGetInlineableField(propAccess, fieldKind, visited);
            }
        }
        return null;
    }

    @Override
    public Element findElementFor(DartMethodInvocation expr) {
        Set<MethodElement> impls = this.typeHeuristic.getImplementationsOf(expr);
        if (impls != null && impls.size() == 1) {
            return impls.iterator().next();
        }
        return (Element)expr.getTargetSymbol();
    }

    @Override
    public boolean canSkipNormalization(DartBinaryExpression expr) {
        Token operator = expr.getOperator();
        Set<Type> types = this.typeHeuristic.getTypesOf(expr.getArg1());
        switch (operator) {
            case ASSIGN_ADD: {
                if (!this.canInlineSideEffect(expr.getArg1())) {
                    return false;
                }
                return BasicOptimizationStrategy.isNumericType(types) || BasicOptimizationStrategy.isStringType(types);
            }
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_SHR: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: {
                if (!this.canInlineSideEffect(expr.getArg1())) {
                    return false;
                }
                return BasicOptimizationStrategy.isNumericType(types);
            }
            case OR: 
            case AND: {
                return BasicOptimizationStrategy.isNumericType(types) || BasicOptimizationStrategy.isBooleanType(types);
            }
            case ASSIGN_TRUNC: 
            case ASSIGN_MOD: {
                return false;
            }
        }
        throw new AssertionError((Object)("Internal Error: Unknown operator " + (Object)((Object)operator)));
    }

    @Override
    public boolean canSkipNormalization(DartUnaryExpression expr) {
        Token operator = expr.getOperator();
        Set<Type> types = this.typeHeuristic.getTypesOf(expr.getArg());
        switch (operator) {
            case INC: 
            case DEC: {
                if (!this.canInlineSideEffect(expr.getArg())) {
                    return false;
                }
                return BasicOptimizationStrategy.isNumericType(types);
            }
        }
        throw new AssertionError((Object)("Internal Error: Unknown operator " + (Object)((Object)operator)));
    }

    @Override
    public boolean isWhitelistedNativeField(FieldElement field, TypeHeuristic.FieldKind fieldKind) {
        EnclosingElement fieldHolder;
        if (this.isNativeFieldWithAccessor(field, fieldKind) && ((fieldHolder = field.getEnclosingElement()).equals(this.typeProvider.getObjectArrayType().getElement()) || fieldHolder.equals(this.typeProvider.getStringImplementationType().getElement()))) {
            return field.getName().equals("length");
        }
        return false;
    }

    private boolean canInlineSideEffect(DartExpression expr) {
        if (expr instanceof DartArrayAccess) {
            Set<MethodElement> impls = this.typeHeuristic.getImplementationsOf(expr);
            if (impls != null) {
                for (MethodElement impl : impls) {
                    ClassElement cls;
                    Element indexAssignOp;
                    if (!ElementKind.of(impl.getEnclosingElement()).equals((Object)ElementKind.CLASS) || (indexAssignOp = (cls = (ClassElement)impl.getEnclosingElement()).lookupLocalElement("operator []=")) == null || cls.getType().equals(this.typeProvider.getObjectArrayType())) continue;
                    return false;
                }
                return true;
            }
        } else {
            Element element = TypeHeuristicImplementation.maybeGetTargetElement(expr);
            if (element != null && element.getModifiers().isFinal()) {
                return false;
            }
            switch (ElementKind.of(element)) {
                case FIELD: {
                    return this.isFieldInlinable((FieldElement)element);
                }
                case PARAMETER: 
                case VARIABLE: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isFieldInlinable(FieldElement field) {
        return !field.isStatic() && !field.isDynamic() && !field.getModifiers().isAbstractField();
    }

    private boolean isFieldInlinable(FieldElement field, TypeHeuristic.FieldKind fieldKind) {
        return this.isFieldInlinable(field) && (fieldKind != TypeHeuristic.FieldKind.SETTER || !field.getModifiers().isFinal());
    }

    private boolean isNativeFieldWithAccessor(FieldElement field, TypeHeuristic.FieldKind fieldKind) {
        if (fieldKind == TypeHeuristic.FieldKind.GETTER && field.getGetter() != null) {
            return field.getGetter().getModifiers().isNative();
        }
        if (fieldKind == TypeHeuristic.FieldKind.SETTER && field.getSetter() != null) {
            return field.getSetter().getModifiers().isNative();
        }
        return false;
    }

    private boolean hasSingleImplementation(DartExpression expr) {
        Set<MethodElement> impls = this.typeHeuristic.getImplementationsOf(expr);
        return impls != null && impls.size() == 1;
    }

    @Override
    public boolean canInlineInitializers(ConstructorElement constructorElement) {
        ClassElement classElement = (ClassElement)constructorElement.getEnclosingElement();
        if (this.canEmitOptimizedClassConstructor(classElement)) {
            Modifiers modifiers = constructorElement.getModifiers();
            if (modifiers.isRedirectedConstructor() || modifiers.isConstant()) {
                return false;
            }
            return classElement.isObjectChild() && classElement.getSubtypes().size() == 1;
        }
        return false;
    }

    @Override
    public boolean canEmitOptimizedClassConstructor(ClassElement classElement) {
        if (classElement.getModifiers().isNative()) {
            return false;
        }
        List<ConstructorElement> constructors = classElement.getConstructors();
        if (constructors.size() != 1) {
            return false;
        }
        ConstructorElement constructor = constructors.iterator().next();
        Modifiers modifiers = constructor.getModifiers();
        if (modifiers.isStatic() || modifiers.isConstant() || modifiers.isNative()) {
            return false;
        }
        DartMethodDefinition method = (DartMethodDefinition)constructor.getNode();
        for (DartParameter param : method.getFunction().getParams()) {
            if (!param.getModifiers().isNamed() && param.getDefaultExpr() == null) continue;
            return false;
        }
        for (DartInitializer initializer : method.getInitializers()) {
            if (!(initializer.getValue() instanceof DartFunctionExpression)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canOptimizeFunctionExpressionBind(DartFunctionExpression expr) {
        DartFunction fn = expr.getFunction();
        if (fn != null) {
            for (DartParameter param : fn.getParams()) {
                if (!param.getModifiers().isNamed()) continue;
                return false;
            }
        }
        return true;
    }
}

