/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.isolate;

import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.backend.common.AbstractBackend;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DartIsolateStubGenerator
extends AbstractBackend {
    private final Set<String> stubInterfaces;
    private PrintStream outStream;

    public DartIsolateStubGenerator(Set<String> classes, String out) throws FileNotFoundException {
        this.outStream = new PrintStream(out);
        this.stubInterfaces = classes;
    }

    private void autoGenerate(DartUnit unit) {
        if (this.stubInterfaces.isEmpty()) {
            return;
        }
        DartVisitor visitor = new DartVisitor(){
            private boolean first = true;

            @Override
            public boolean visit(DartClass clazz, DartContext ctx) {
                if (clazz.isInterface() && DartIsolateStubGenerator.this.stubInterfaces.contains(clazz.getClassName())) {
                    if (!this.first) {
                        DartIsolateStubGenerator.this.nl();
                    }
                    this.first = false;
                    DartIsolateStubGenerator.this.p("/* class = " + clazz.getClassName() + " (" + clazz.getSource().getName() + ": " + clazz.getSourceLine() + ") */");
                    DartIsolateStubGenerator.this.nl();
                    DartIsolateStubGenerator.this.nl();
                    DartIsolateStubGenerator.this.generateProxyClass(clazz);
                    DartIsolateStubGenerator.this.nl();
                    DartIsolateStubGenerator.this.generateDispatchClass(clazz);
                    DartIsolateStubGenerator.this.nl();
                    DartIsolateStubGenerator.this.generateIsolateClass(clazz);
                }
                return false;
            }
        };
        visitor.accept(unit);
        this.outStream.flush();
    }

    private static boolean isConstructor(DartMethodDefinition x) {
        return x.getSymbol().isConstructor();
    }

    private static boolean isSimpleType(DartTypeNode x) {
        if (!(x.getIdentifier() instanceof DartIdentifier)) {
            return false;
        }
        String name = ((DartIdentifier)x.getIdentifier()).getTargetName();
        if (name.equals("Promise")) {
            return true;
        }
        if (!x.getTypeArguments().isEmpty()) {
            return false;
        }
        return name.equals("int") || name.equals("void");
    }

    private static boolean isPromise(DartTypeNode x) {
        if (!(x.getIdentifier() instanceof DartIdentifier)) {
            return false;
        }
        String name = ((DartIdentifier)x.getIdentifier()).getTargetName();
        return name.equals("Promise");
    }

    private String getPromiseType(DartTypeNode x) {
        assert (DartIsolateStubGenerator.isPromise(x));
        List<DartTypeNode> types = x.getTypeArguments();
        assert (types.size() == 1);
        return ((DartIdentifier)types.get(0).getIdentifier()).getTargetName();
    }

    private static boolean isPromiseForProxy(DartTypeNode x) {
        if (!DartIsolateStubGenerator.isPromise(x)) {
            return false;
        }
        List<DartTypeNode> types = x.getTypeArguments();
        if (types.size() != 1) {
            return false;
        }
        String name = ((DartIdentifier)types.get(0).getIdentifier()).getTargetName();
        return name.endsWith("$Proxy");
    }

    private static boolean isVoid(DartTypeNode x) {
        if (!DartIsolateStubGenerator.isSimpleType(x)) {
            return false;
        }
        return ((DartIdentifier)x.getIdentifier()).getTargetName().equals("void");
    }

    private static boolean isProxyType(DartTypeNode x) {
        if (!(x.getIdentifier() instanceof DartIdentifier)) {
            return false;
        }
        String name = ((DartIdentifier)x.getIdentifier()).getTargetName();
        if (name.equals("Promise")) {
            return true;
        }
        if (!x.getTypeArguments().isEmpty()) {
            return false;
        }
        return name.endsWith("$Proxy");
    }

    private void p(String str) {
        this.outStream.print(str);
    }

    private void nl() {
        this.outStream.println();
    }

    private void printTypeArguments(DartTypeNode x) {
        List<DartTypeNode> arguments = x.getTypeArguments();
        if (arguments != null && !arguments.isEmpty()) {
            this.p("<");
            this.printParams(arguments);
            this.p(">");
        }
    }

    private void printParams(List<? extends DartNode> nodes) {
        boolean first = true;
        for (DartNode dartNode : nodes) {
            if (!first) {
                this.p(", ");
            }
            DartVisitor param = new DartVisitor(){

                @Override
                public boolean visit(DartParameter x, DartContext ctx) {
                    if (x.getModifiers().isFinal()) {
                        DartIsolateStubGenerator.this.p("final ");
                    }
                    if (x.getTypeNode() != null) {
                        this.accept(x.getTypeNode());
                        DartIsolateStubGenerator.this.p(" ");
                    }
                    this.accept(x.getName());
                    if (x.getFunctionParameters() != null) {
                        DartIsolateStubGenerator.this.p("(");
                        DartIsolateStubGenerator.this.printParams(x.getFunctionParameters());
                        DartIsolateStubGenerator.this.p(")");
                    }
                    if (x.getDefaultExpr() != null) {
                        DartIsolateStubGenerator.this.p(" = ");
                        this.accept(x.getDefaultExpr());
                    }
                    return false;
                }

                @Override
                public boolean visit(DartTypeNode x, DartContext ctx) {
                    this.accept(x.getIdentifier());
                    DartIsolateStubGenerator.this.printTypeArguments(x);
                    return false;
                }

                @Override
                public boolean visit(DartIdentifier x, DartContext ctx) {
                    DartIsolateStubGenerator.this.p(x.getTargetName());
                    return false;
                }
            };
            param.accept(dartNode);
            first = false;
        }
    }

    private void printProxyInterfaceFunctions(DartClass clazz) {
        DartVisitor visitor = new DartVisitor(){

            @Override
            public boolean visit(DartMethodDefinition x, DartContext ctx) {
                if (!DartIsolateStubGenerator.this.printFunctionDeclaration(this, x)) {
                    return false;
                }
                DartIsolateStubGenerator.this.p(";");
                DartIsolateStubGenerator.this.nl();
                return false;
            }

            @Override
            public boolean visit(DartTypeNode x, DartContext ctx) {
                this.accept(x.getIdentifier());
                DartIsolateStubGenerator.this.printTypeArguments(x);
                return false;
            }

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }
        };
        visitor.acceptList(clazz.getMembers());
    }

    private void generateProxyClass(DartClass clazz) {
        String name = clazz.getClassName();
        this.p("interface " + name + "$Proxy extends Proxy {");
        this.printProxyInterfaceFunctions(clazz);
        this.p("}");
        this.nl();
        this.nl();
        this.p("class " + name + "$ProxyImpl extends ProxyImpl implements " + name + "$Proxy {");
        this.nl();
        this.p("  " + name + "$ProxyImpl(Promise<SendPort> port) : super.forReply(port) { }");
        this.nl();
        this.p("  " + name + "$ProxyImpl.forIsolate(Proxy isolate) : super.forReply(isolate.call([null])) { }");
        this.nl();
        this.p("  factory " + name + "$ProxyImpl.createIsolate() {");
        this.nl();
        this.p("    Proxy isolate = new Proxy.forIsolate(new " + name + "$Dispatcher$Isolate());");
        this.nl();
        this.p("    return new " + name + "$ProxyImpl.forIsolate(isolate);");
        this.nl();
        this.p("  }");
        this.nl();
        this.p("  factory " + name + "$ProxyImpl.localProxy(" + name + " obj) {");
        this.nl();
        this.p("    return new " + name + "$ProxyImpl(new Promise<SendPort>.fromValue(Dispatcher.serve(new " + name + "$Dispatcher(obj))));");
        this.nl();
        this.p("  }");
        this.nl();
        DartVisitor visitor = new DartVisitor(){

            @Override
            public boolean visit(DartMethodDefinition x, DartContext ctx) {
                if (!DartIsolateStubGenerator.this.printFunctionDeclaration(this, x)) {
                    return false;
                }
                DartIsolateStubGenerator.this.p(" {");
                DartIsolateStubGenerator.this.nl();
                DartIsolateStubGenerator.this.p("    ");
                DartFunction func = x.getFunction();
                DartTypeNode returnTypeNode = func.getReturnTypeNode();
                boolean isVoid = DartIsolateStubGenerator.isVoid(returnTypeNode);
                boolean isSimple = DartIsolateStubGenerator.isSimpleType(returnTypeNode);
                boolean isProxy = DartIsolateStubGenerator.isProxyType(returnTypeNode);
                boolean isPromise = DartIsolateStubGenerator.isPromise(returnTypeNode);
                boolean isPromiseForProxy = DartIsolateStubGenerator.isPromiseForProxy(returnTypeNode);
                if (isPromiseForProxy) {
                    String type = DartIsolateStubGenerator.this.getPromiseType(returnTypeNode);
                    DartIsolateStubGenerator.this.p("return new Promise<" + type + ">.fromValue(new " + type + "Impl(new PromiseProxy<SendPort>(new PromiseProxy<SendPort>(");
                } else {
                    if (!isVoid) {
                        DartIsolateStubGenerator.this.p("return ");
                        if (!isSimple) {
                            DartIsolateStubGenerator.this.p("new ");
                            this.accept(returnTypeNode);
                            if (!isProxy) {
                                DartIsolateStubGenerator.this.p("$Proxy");
                            }
                            DartIsolateStubGenerator.this.p("Impl(");
                        }
                    }
                    if (isProxy) {
                        DartIsolateStubGenerator.this.p("new PromiseProxy");
                        if (isPromise) {
                            DartIsolateStubGenerator.this.printTypeArguments(returnTypeNode);
                        } else {
                            DartIsolateStubGenerator.this.p("<SendPort>");
                        }
                        DartIsolateStubGenerator.this.p("(");
                    }
                }
                DartIsolateStubGenerator.this.p("this.");
                if (isVoid) {
                    DartIsolateStubGenerator.this.p("send");
                } else {
                    DartIsolateStubGenerator.this.p("call");
                }
                DartIsolateStubGenerator.this.p("([\"");
                this.accept(x.getName());
                DartIsolateStubGenerator.this.p("\"");
                DartVisitor params = new DartVisitor(){

                    @Override
                    public boolean visit(DartIdentifier x, DartContext ctx) {
                        DartIsolateStubGenerator.this.p(", ");
                        DartIsolateStubGenerator.this.p(x.getTargetName());
                        return false;
                    }

                    @Override
                    public boolean visit(DartParameter x, DartContext ctx) {
                        this.accept(x.getName());
                        return false;
                    }
                };
                params.acceptList(func.getParams());
                DartIsolateStubGenerator.this.p("])");
                if (isPromiseForProxy) {
                    DartIsolateStubGenerator.this.p("))))");
                } else {
                    if (isProxy) {
                        DartIsolateStubGenerator.this.p(")");
                    }
                    if (!isSimple) {
                        DartIsolateStubGenerator.this.p(")");
                    }
                }
                DartIsolateStubGenerator.this.p(";");
                DartIsolateStubGenerator.this.nl();
                DartIsolateStubGenerator.this.p("  }");
                DartIsolateStubGenerator.this.nl();
                return false;
            }

            @Override
            public boolean visit(DartTypeNode x, DartContext ctx) {
                this.accept(x.getIdentifier());
                DartIsolateStubGenerator.this.printTypeArguments(x);
                return false;
            }

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }
        };
        visitor.acceptList(clazz.getMembers());
        this.p("}");
        this.nl();
    }

    private void printSelector(List<DartNode> members, String dispatcherName) {
        boolean first = true;
        for (DartNode member : members) {
            if (first) {
                this.p("    ");
            } else {
                this.p(" else ");
            }
            this.p("if (command == \"");
            this.printFunctionName(member);
            this.p("\") {");
            this.nl();
            int proxies = this.unpackParams(member);
            if (proxies != 0) {
                this.gatherProxies(member);
            }
            this.callTarget((DartMethodDefinition)member, "");
            this.p("    }");
            first = false;
        }
        this.p(" else {");
        this.nl();
        this.p("      // TODO(kasperl,benl): Somehow throw an exception instead.");
        this.nl();
        this.p("      reply(\"Exception: command '\" + command + \"' not understood by " + dispatcherName + ".\");");
        this.nl();
        this.p("    }");
        this.nl();
    }

    private void callTarget(DartMethodDefinition member, String extra) {
        if (DartIsolateStubGenerator.isConstructor(member)) {
            return;
        }
        this.p(extra + "      ");
        boolean isVoid = DartIsolateStubGenerator.isVoid(member.getFunction().getReturnTypeNode());
        if (!isVoid) {
            this.printReturnType(member);
            this.p(" ");
            this.printFunctionName(member);
            this.p(" = ");
        }
        this.p("target.");
        this.printFunctionName(member);
        this.p("(");
        this.printParamNames(member);
        this.p(");");
        this.nl();
        String returnType = DartIsolateStubGenerator.stringReturnType(member);
        if (this.stubInterfaces.contains(returnType)) {
            this.p(extra + "      SendPort port = Dispatcher.serve(new " + returnType + "$Dispatcher(");
            this.printFunctionName(member);
            this.p("));");
            this.nl();
            this.p(extra + "      reply(port);");
            this.nl();
        } else if (!isVoid) {
            this.p(extra + "      reply(");
            this.printFunctionName(member);
            this.p(");");
            this.nl();
        }
    }

    private static String stringReturnType(DartMethodDefinition member) {
        return DartIsolateStubGenerator.stringType(member.getFunction().getReturnTypeNode());
    }

    private void printParamNames(DartMethodDefinition member) {
        boolean first = true;
        for (DartParameter param : member.getFunction().getParams()) {
            if (!first) {
                this.p(", ");
            }
            this.printName((DartExpression)param.getName());
            first = false;
        }
    }

    private void printName(DartExpression name) {
        DartVisitor visitor = new DartVisitor(){

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }
        };
        visitor.accept(name);
    }

    private void printReturnType(DartMethodDefinition member) {
        this.printType(member.getFunction().getReturnTypeNode());
    }

    private void printType(DartTypeNode type) {
        DartVisitor visitor = new DartVisitor(){

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }

            @Override
            public boolean visit(DartTypeNode x, DartContext ctx) {
                this.accept(x.getIdentifier());
                DartIsolateStubGenerator.this.printTypeArguments(x);
                return false;
            }
        };
        visitor.accept(type);
    }

    private static String stringType(DartTypeNode type) {
        final StringBuilder strType = new StringBuilder();
        DartVisitor visitor = new DartVisitor(){

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                strType.append(x.getTargetName());
                return false;
            }

            @Override
            public boolean visit(DartTypeNode x, DartContext ctx) {
                this.accept(x.getIdentifier());
                List<DartTypeNode> arguments = x.getTypeArguments();
                if (arguments != null && !arguments.isEmpty()) {
                    strType.append("<");
                    strType.append("...");
                    strType.append(">");
                }
                return false;
            }
        };
        visitor.accept(type);
        return strType.toString();
    }

    private int unpackParams(DartNode member) {
        class UnpackVisitor
        extends DartVisitor {
            private int pos;
            int proxies;

            UnpackVisitor() {
            }

            @Override
            public boolean visit(DartTypeNode x, DartContext ctx) {
                this.accept(x.getIdentifier());
                DartIsolateStubGenerator.this.printTypeArguments(x);
                return false;
            }

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }

            @Override
            public boolean visit(DartMethodDefinition x, DartContext ctx) {
                this.pos = 1;
                this.proxies = 0;
                for (DartParameter param : x.getFunction().getParams()) {
                    DartIsolateStubGenerator.this.p("      ");
                    this.accept(param);
                    DartIsolateStubGenerator.this.nl();
                    ++this.pos;
                }
                return false;
            }

            @Override
            public boolean visit(DartParameter x, DartContext ctx) {
                boolean isSimpleType = DartIsolateStubGenerator.isSimpleType(x.getTypeNode());
                if (isSimpleType) {
                    this.accept(x.getTypeNode());
                    DartIsolateStubGenerator.this.p(" ");
                    this.accept(x.getName());
                    DartIsolateStubGenerator.this.p(" = ");
                } else {
                    if (this.proxies == 0) {
                        DartIsolateStubGenerator.this.p("List<Promise<SendPort>> promises = new List<Promise<SendPort>>();");
                        DartIsolateStubGenerator.this.nl();
                        DartIsolateStubGenerator.this.p("      ");
                    }
                    DartIsolateStubGenerator.this.p("promises.add(new PromiseProxy<SendPort>(new Promise<SendPort>.fromValue(");
                    ++this.proxies;
                }
                DartIsolateStubGenerator.this.p("message[" + this.pos + "]");
                if (!isSimpleType) {
                    DartIsolateStubGenerator.this.p(")))");
                }
                DartIsolateStubGenerator.this.p(";");
                return false;
            }
        }
        UnpackVisitor visitor = new UnpackVisitor();
        visitor.accept(member);
        return visitor.proxies;
    }

    private void gatherProxies(DartNode member) {
        class GatherVisitor
        extends DartVisitor {
            private int proxies;

            GatherVisitor() {
            }

            @Override
            public boolean visit(DartTypeNode x, DartContext ctx) {
                this.accept(x.getIdentifier());
                DartIsolateStubGenerator.this.printTypeArguments(x);
                return false;
            }

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }

            @Override
            public boolean visit(DartMethodDefinition x, DartContext ctx) {
                this.proxies = 0;
                for (DartParameter param : x.getFunction().getParams()) {
                    this.accept(param);
                }
                return false;
            }

            @Override
            public boolean visit(DartParameter x, DartContext ctx) {
                boolean isSimpleType = DartIsolateStubGenerator.isSimpleType(x.getTypeNode());
                if (!isSimpleType) {
                    DartIsolateStubGenerator.this.p("      ");
                    this.accept(x.getTypeNode());
                    DartIsolateStubGenerator.this.p(" ");
                    this.accept(x.getName());
                    DartIsolateStubGenerator.this.p(" = new ");
                    this.accept(x.getTypeNode());
                    DartIsolateStubGenerator.this.p("Impl(promises[" + this.proxies + "]);");
                    ++this.proxies;
                    DartIsolateStubGenerator.this.nl();
                }
                return false;
            }
        }
        GatherVisitor visitor = new GatherVisitor();
        visitor.accept(member);
    }

    private void printFunctionName(DartNode member) {
        DartVisitor functionName = new DartVisitor(){

            @Override
            public boolean visit(DartMethodDefinition x, DartContext ctx) {
                this.accept(x.getName());
                return false;
            }

            @Override
            public boolean visit(DartIdentifier x, DartContext ctx) {
                DartIsolateStubGenerator.this.p(x.getTargetName());
                return false;
            }
        };
        functionName.accept(member);
    }

    private void generateDispatchClass(DartClass clazz) {
        String name = clazz.getClassName();
        this.p("class " + name + "$Dispatcher extends Dispatcher<" + name + "> {");
        this.nl();
        this.p("  " + name + "$Dispatcher(" + name + " thing) : super(thing) { }");
        this.nl();
        this.nl();
        this.p("  void process(var message, void reply(var response)) {");
        this.nl();
        this.p("    String command = message[0];");
        this.nl();
        this.printSelector(clazz.getMembers(), name);
        this.p("  }");
        this.nl();
        this.p("}");
        this.nl();
    }

    private void generateIsolateClass(DartClass clazz) {
        String name = clazz.getClassName();
        this.p("class " + name + "$Dispatcher$Isolate extends Isolate {");
        this.nl();
        this.p("  " + name + "$Dispatcher$Isolate() : super() { }");
        this.nl();
        this.nl();
        this.p("  void main() {");
        this.nl();
        this.p("    this.port.receive(void _(var message, SendPort replyTo) {");
        this.nl();
        this.p("      " + name + " thing = new " + name + "();");
        this.nl();
        this.p("      SendPort port = Dispatcher.serve(new " + name + "$Dispatcher(thing));");
        this.nl();
        this.p("      Proxy proxy = new Proxy.forPort(replyTo);");
        this.nl();
        this.p("      proxy.send([port]);");
        this.nl();
        this.p("    });");
        this.nl();
        this.p("  }");
        this.nl();
        this.p("}");
        this.nl();
    }

    @Override
    public boolean isOutOfDate(DartSource src, DartCompilerContext context) {
        return true;
    }

    @Override
    public void compileUnit(DartUnit unit, DartSource src, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
        this.autoGenerate(unit);
    }

    @Override
    public void packageApp(LibrarySource app, Collection<LibraryUnit> libraries, DartCompilerContext context, CoreTypeProvider typeProvider) throws IOException {
    }

    @Override
    public String getAppExtension() {
        return null;
    }

    @Override
    public String getSourceMapExtension() {
        return null;
    }

    private boolean printFunctionDeclaration(DartVisitor visitor, DartMethodDefinition x) {
        if (DartIsolateStubGenerator.isConstructor(x)) {
            return false;
        }
        this.nl();
        DartFunction func = x.getFunction();
        DartTypeNode returnTypeNode = func.getReturnTypeNode();
        boolean isVoid = DartIsolateStubGenerator.isVoid(returnTypeNode);
        boolean isSimple = DartIsolateStubGenerator.isSimpleType(returnTypeNode);
        boolean isProxy = DartIsolateStubGenerator.isProxyType(returnTypeNode);
        boolean isPromise = DartIsolateStubGenerator.isPromise(returnTypeNode);
        this.p("  ");
        if (!isVoid && isSimple && !isPromise) {
            this.p("Promise<");
        }
        visitor.accept(returnTypeNode);
        if (!isVoid) {
            if (isSimple && !isPromise) {
                this.p(">");
            } else if (!isProxy) {
                this.p("$Proxy");
            }
        }
        this.p(" ");
        visitor.accept(x.getName());
        this.p("(");
        this.printParams(func.getParams());
        this.p(")");
        return true;
    }

    class ProxifyingVisitor
    extends DartVisitor {
        ProxifyingVisitor() {
        }

        @Override
        public boolean visit(DartTypeNode x, DartContext ctx) {
            this.accept(x.getIdentifier());
            DartIsolateStubGenerator.this.printTypeArguments(x);
            if (!DartIsolateStubGenerator.isSimpleType(x)) {
                DartIsolateStubGenerator.this.p("$Proxy");
            }
            return false;
        }

        @Override
        public boolean visit(DartIdentifier x, DartContext ctx) {
            DartIsolateStubGenerator.this.p(x.getTargetName());
            return false;
        }
    }
}

