/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.common;

import com.google.common.collect.Sets;
import com.google.dart.compiler.ast.DartArrayAccess;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartAssertion;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartBreakStatement;
import com.google.dart.compiler.ast.DartCase;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartConditional;
import com.google.dart.compiler.ast.DartContinueStatement;
import com.google.dart.compiler.ast.DartDefault;
import com.google.dart.compiler.ast.DartDoWhileStatement;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartEmptyStatement;
import com.google.dart.compiler.ast.DartExprStmt;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartForInStatement;
import com.google.dart.compiler.ast.DartForStatement;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIfStatement;
import com.google.dart.compiler.ast.DartImportDirective;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartLabel;
import com.google.dart.compiler.ast.DartLibraryDirective;
import com.google.dart.compiler.ast.DartLiteral;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMapLiteralEntry;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNamedExpression;
import com.google.dart.compiler.ast.DartNativeBlock;
import com.google.dart.compiler.ast.DartNativeDirective;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNullLiteral;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartParenthesizedExpression;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartResourceDirective;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartSourceDirective;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartSwitchStatement;
import com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import com.google.dart.compiler.ast.DartSyntheticErrorStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartThrowStatement;
import com.google.dart.compiler.ast.DartTryStatement;
import com.google.dart.compiler.ast.DartTypeExpression;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartWhileStatement;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.backend.common.TypeHeuristic;
import com.google.dart.compiler.parser.Token;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FieldElement;
import com.google.dart.compiler.resolver.MethodElement;
import com.google.dart.compiler.resolver.VariableElement;
import com.google.dart.compiler.type.FunctionType;
import com.google.dart.compiler.type.InterfaceType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeKind;
import com.google.dart.compiler.type.Types;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeHeuristicImplementation
implements TypeHeuristic {
    private ExpressionTypeInfo typeInfo;
    private final Set<Type> dynTypes;

    public TypeHeuristicImplementation(DartUnit unit, CoreTypeProvider typeProvider) {
        this.typeInfo = TypeInfoVisitor.computeTypeInfo(unit, typeProvider);
        this.dynTypes = Sets.newHashSet((Object[])new Type[]{typeProvider.getDynamicType()});
    }

    @Override
    public Set<Type> getTypesOf(DartExpression expr) {
        Set<Type> types = this.typeInfo.getTypeSets().get(expr.getNormalizedNode());
        if (types != null) {
            return types;
        }
        return this.dynTypes;
    }

    @Override
    public boolean isDynamic(Set<Type> types) {
        return types == this.dynTypes || types.size() > 1 || TypeKind.of(types.iterator().next()).equals((Object)TypeKind.DYNAMIC);
    }

    @Override
    public Set<MethodElement> getImplementationsOf(DartExpression expr) {
        return this.typeInfo.getMethodImpl().get(expr.getNormalizedNode());
    }

    @Override
    public Set<FieldElement> getFieldImplementationsOf(DartExpression expr, TypeHeuristic.FieldKind fieldKind) {
        Set<FieldElement> fields = null;
        fields = fieldKind == TypeHeuristic.FieldKind.GETTER ? this.typeInfo.getGettersImpl().get(expr.getNormalizedNode()) : this.typeInfo.getSettersImpl().get(expr.getNormalizedNode());
        assert (TypeHeuristicImplementation.assertFieldsMatch(fields, fieldKind));
        return fields;
    }

    public static Element maybeGetTargetElement(DartExpression expr) {
        return TypeHeuristicImplementation.maybeGetTargetElement(expr, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element maybeGetTargetElement(DartNode dartNode, Set<Element> elements) {
        Element element = null;
        String propName = null;
        elements = Sets.newHashSet();
        if (dartNode instanceof DartPropertyAccess) {
            DartPropertyAccess propAccess = (DartPropertyAccess)dartNode;
            propName = propAccess.getPropertyName();
            element = TypeHeuristicImplementation.maybeGetTargetElement(propAccess.getQualifier(), elements);
        } else if (dartNode instanceof DartIdentifier) {
            element = ((DartIdentifier)dartNode).getTargetSymbol();
            if (!ElementKind.of(element).equals((Object)ElementKind.FIELD)) return element;
            propName = element.getName();
            element = element.getEnclosingElement();
        } else if (dartNode instanceof DartArrayAccess) {
            return TypeHeuristicImplementation.maybeGetTargetElement(((DartArrayAccess)dartNode).getTarget());
        }
        if (element == null) return element;
        if (!TypeKind.of(element.getType()).equals((Object)TypeKind.INTERFACE)) return null;
        InterfaceType iType = (InterfaceType)element.getType();
        InterfaceType.Member member = iType.lookupMember(propName);
        if (member != null) {
            element = member.getElement();
            elements.add(element);
        }
        ClassElement classElement = iType.getElement();
        for (InterfaceType subType : classElement.getSubtypes()) {
            member = subType.lookupMember(propName);
            if (member == null) continue;
            elements.add(member.getElement());
        }
        if (elements.size() == 1) return element;
        return null;
    }

    private static boolean assertFieldsMatch(Set<FieldElement> fields, TypeHeuristic.FieldKind fieldKind) {
        if (fields == null) {
            return true;
        }
        boolean allMatch = true;
        for (FieldElement fieldElement : fields) {
            Modifiers modifiers = fieldElement.getModifiers();
            boolean singleMatch = modifiers.isAbstractField() ? (fieldKind == TypeHeuristic.FieldKind.GETTER ? fieldElement.getGetter() != null : fieldElement.getSetter() != null) : true;
            allMatch &= singleMatch;
        }
        return allMatch;
    }

    static class ExpressionTypeInfo {
        private final Map<DartExpression, Set<Type>> typeSets = new HashMap<DartExpression, Set<Type>>();
        private final Map<DartExpression, Set<FieldElement>> getterImpl = new HashMap<DartExpression, Set<FieldElement>>();
        private final Map<DartExpression, Set<FieldElement>> setterImpl = new HashMap<DartExpression, Set<FieldElement>>();
        private final Map<DartExpression, Set<MethodElement>> methodImpl = new HashMap<DartExpression, Set<MethodElement>>();

        static ExpressionTypeInfo create() {
            return new ExpressionTypeInfo();
        }

        private ExpressionTypeInfo() {
        }

        Map<DartExpression, Set<Type>> getTypeSets() {
            return this.typeSets;
        }

        Map<DartExpression, Set<FieldElement>> getGettersImpl() {
            return this.getterImpl;
        }

        Map<DartExpression, Set<FieldElement>> getSettersImpl() {
            return this.setterImpl;
        }

        Map<DartExpression, Set<MethodElement>> getMethodImpl() {
            return this.methodImpl;
        }
    }

    private static class TypeInfoVisitor
    implements DartPlainVisitor<Type> {
        private final ExpressionTypeInfo typeInfo;
        private final CoreTypeProvider typeProvider;
        private final Types typeUtils;
        private InterfaceType currentClass;
        Set<Element> visitedConstants;

        public static ExpressionTypeInfo computeTypeInfo(DartUnit unit, CoreTypeProvider typeProvider) {
            TypeInfoVisitor typeInfoVisitor = new TypeInfoVisitor(typeProvider);
            typeInfoVisitor.visitUnit(unit);
            return typeInfoVisitor.typeInfo;
        }

        private TypeInfoVisitor(CoreTypeProvider typeProvider) {
            this.typeProvider = typeProvider;
            this.typeUtils = Types.getInstance(typeProvider);
            this.typeInfo = ExpressionTypeInfo.create();
        }

        @Override
        public Type visitUnit(DartUnit node) {
            this.visitedConstants = Sets.newHashSet();
            Type type = this.visitChildrenAndReturnVoid(node);
            this.visitedConstants = null;
            return type;
        }

        @Override
        public Type visitClass(DartClass node) {
            this.beginClassContext(node);
            this.visitChildren(node);
            this.endClassContext();
            return this.dynamicType();
        }

        private void beginClassContext(DartClass node) {
            this.currentClass = node.getSymbol().getType();
        }

        private void endClassContext() {
            this.currentClass = null;
        }

        @Override
        public Type visitThisExpression(DartThisExpression node) {
            return this.recordTypeInfo((DartExpression)node, this.currentClass.getElement().getType());
        }

        @Override
        public Type visitArrayLiteral(DartArrayLiteral node) {
            this.visit(node.getExpressions());
            return this.getType(node);
        }

        @Override
        public Type visitMapLiteral(DartMapLiteral node) {
            return this.recordTypeInfo((DartExpression)node, this.getType(node));
        }

        @Override
        public Type visitMapLiteralEntry(DartMapLiteralEntry node) {
            return this.computeType(node);
        }

        @Override
        public Type visitBooleanLiteral(DartBooleanLiteral node) {
            return this.recordTypeInfo((DartExpression)node, this.getType(node));
        }

        @Override
        public Type visitDoubleLiteral(DartDoubleLiteral node) {
            return this.recordTypeInfo((DartExpression)node, this.getType(node));
        }

        @Override
        public Type visitIntegerLiteral(DartIntegerLiteral node) {
            return this.recordTypeInfo((DartExpression)node, this.getType(node));
        }

        @Override
        public Type visitStringLiteral(DartStringLiteral node) {
            return this.recordTypeInfo((DartExpression)node, this.getType(node));
        }

        @Override
        public Type visitStringInterpolation(DartStringInterpolation node) {
            return this.recordTypeInfo((DartExpression)node, this.getType(node));
        }

        @Override
        public Type visitNullLiteral(DartNullLiteral node) {
            return this.recordTypeInfo((DartExpression)node, this.nullType());
        }

        @Override
        public Type visitParenthesizedExpression(DartParenthesizedExpression node) {
            return this.recordTypeInfo((DartExpression)node, this.computeType(node.getExpression()));
        }

        @Override
        public Type visitTypeNode(DartTypeNode node) {
            return node.getType() == null ? this.dynamicType() : node.getType();
        }

        @Override
        public Type visitBlock(DartBlock node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitBreakStatement(DartBreakStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitContinueStatement(DartContinueStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitDefault(DartDefault node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitEmptyStatement(DartEmptyStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitExprStmt(DartExprStmt node) {
            return this.visit(node.getExpression());
        }

        @Override
        public Type visitParameter(DartParameter node) {
            this.visit(node.getDefaultExpr());
            return this.getType(node);
        }

        @Override
        public Type visitMethodDefinition(DartMethodDefinition node) {
            this.visitChildren(node);
            return this.getType(node);
        }

        @Override
        public Type visitNewExpression(DartNewExpression node) {
            this.visit(node.getArgs());
            return this.getType(node);
        }

        @Override
        public Type visitMethodInvocation(DartMethodInvocation node) {
            this.visit(node.getArgs());
            Type type = this.computeType(node.getTarget());
            String selectorName = node.getFunctionNameString();
            type = this.computeAndRecordSelectorTypes(node, type, selectorName);
            return type;
        }

        @Override
        public Type visitFunction(DartFunction node) {
            this.visit(node.getParams());
            this.computeType(node.getBody());
            return this.getType(node.getReturnTypeNode());
        }

        @Override
        public Type visitAssertion(DartAssertion node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitImportDirective(DartImportDirective node) {
            return this.voidType();
        }

        @Override
        public Type visitLibraryDirective(DartLibraryDirective node) {
            return this.voidType();
        }

        @Override
        public Type visitNativeDirective(DartNativeDirective node) {
            return this.voidType();
        }

        @Override
        public Type visitResourceDirective(DartResourceDirective node) {
            return this.voidType();
        }

        @Override
        public Type visitSourceDirective(DartSourceDirective node) {
            return this.voidType();
        }

        @Override
        public void visit(List<? extends DartNode> nodes) {
            if (nodes != null) {
                for (DartNode dartNode : nodes) {
                    dartNode.getNormalizedNode().accept(this);
                }
            }
        }

        @Override
        public Type visitArrayAccess(DartArrayAccess node) {
            Type type = this.computeType(node.getTarget());
            type = this.computeAndRecordSelectorTypes(node, type, this.getOperatorSelectorName(Token.INDEX));
            this.visit(node.getKey());
            return type;
        }

        @Override
        public Type visitPropertyAccess(DartPropertyAccess node) {
            String selectorName = node.getPropertyName();
            Type receiver = this.computeType(node.getQualifier());
            Type selectorType = this.computeAndRecordSelectorTypes(node, receiver, selectorName);
            return selectorType;
        }

        private boolean canBindConstantValue(DartExpression expr) {
            if (expr instanceof DartLiteral) {
                return true;
            }
            if (expr instanceof DartBinaryExpression) {
                DartBinaryExpression binExpr = (DartBinaryExpression)expr;
                return this.canBindConstantValue(binExpr.getArg1()) && this.canBindConstantValue(binExpr.getArg2());
            }
            if (expr instanceof DartUnaryExpression) {
                return this.canBindConstantValue(((DartUnaryExpression)expr).getArg());
            }
            if (expr instanceof DartParenthesizedExpression) {
                return this.canBindConstantValue(((DartParenthesizedExpression)expr).getExpression());
            }
            if (expr instanceof DartIdentifier || expr instanceof DartPropertyAccess) {
                Element e = TypeHeuristicImplementation.maybeGetTargetElement(expr);
                switch (ElementKind.of(e)) {
                    case FIELD: {
                        if (this.visitedConstants.contains(e)) {
                            return false;
                        }
                        this.visitedConstants.add(e);
                        FieldElement field = (FieldElement)e;
                        DartField fieldNode = (DartField)field.getNode();
                        boolean result = field.getModifiers().isFinal() && this.canBindConstantValue(fieldNode.getValue());
                        this.visitedConstants.remove(e);
                        return result;
                    }
                    case VARIABLE: {
                        VariableElement var = (VariableElement)e;
                        DartVariable varNode = (DartVariable)var.getNode();
                        return var.getModifiers().isFinal() && this.canBindConstantValue(varNode.getValue());
                    }
                }
            }
            return false;
        }

        private void maybeBindConstantValues(DartExpression expr, boolean isAssignee) {
            if (this.canBindConstantValue(expr) && expr == expr.getNormalizedNode()) {
                DartExpression foldedExpr = null;
                Element target = TypeHeuristicImplementation.maybeGetTargetElement(expr);
                switch (ElementKind.of(target)) {
                    case VARIABLE: {
                        if (isAssignee || !target.getModifiers().isFinal()) break;
                        DartVariable var = (DartVariable)target.getNode();
                        foldedExpr = (DartExpression)var.getValue().clone();
                        break;
                    }
                    case FIELD: {
                        if (!target.getModifiers().isFinal()) break;
                        DartField field = (DartField)target.getNode();
                        foldedExpr = (DartExpression)field.getValue().clone();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (foldedExpr != null) {
                    if (expr instanceof DartIdentifier) {
                        ((DartIdentifier)expr).setNormalizedNode(foldedExpr);
                    } else if (expr instanceof DartPropertyAccess) {
                        ((DartPropertyAccess)expr).setNormalizedNode(foldedExpr);
                    }
                }
            }
        }

        @Override
        public Type visitBinaryExpression(DartBinaryExpression node) {
            Token opToken = node.getOperator();
            this.maybeBindConstantValues(node.getArg1(), opToken.isAssignmentOperator());
            Type receiver = this.computeType(node.getArg1());
            this.maybeBindConstantValues(node.getArg2(), false);
            this.computeType(node.getArg2());
            switch (opToken) {
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: 
                case BIT_AND: 
                case BIT_OR: 
                case BIT_XOR: 
                case SAR: 
                case SHL: 
                case SHR: 
                case ASSIGN_ADD: 
                case ASSIGN_SUB: 
                case ASSIGN_MUL: 
                case ASSIGN_DIV: 
                case ASSIGN_MOD: 
                case ASSIGN_BIT_AND: 
                case ASSIGN_BIT_OR: 
                case ASSIGN_BIT_XOR: 
                case ASSIGN_SAR: 
                case ASSIGN_SHL: 
                case ASSIGN_SHR: {
                    this.computeAndRecordSelectorTypes(node, receiver, this.getOperatorSelectorName(opToken));
                    return receiver;
                }
                case NE: {
                    assert (!opToken.isUserDefinableOperator()) : "Transformation at the line below is not valid anymore";
                    opToken = Token.EQ;
                }
                case AND: 
                case OR: 
                case NOT: 
                case EQ: 
                case EQ_STRICT: 
                case NE_STRICT: 
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    Type opType = this.boolType();
                    this.computeAndRecordSelectorTypes(node, receiver, this.getOperatorSelectorName(opToken));
                    this.recordTypeInfo((DartExpression)node, Sets.newHashSet((Object[])new Type[]{opType}));
                    return opType;
                }
                case ASSIGN: {
                    return receiver;
                }
                case COMMA: {
                    return this.computeType(node.getArg2());
                }
            }
            return this.dynamicType();
        }

        private void maybeAddObjectSelectors(DartExpression node, Type receiver, String selectorName) {
            InterfaceType.Member iMember = this.typeProvider.getObjectType().lookupMember(selectorName);
            if (iMember != null && ElementKind.of(iMember.getElement()).equals((Object)ElementKind.METHOD)) {
                this.recordMethodImpl(node, (MethodElement)iMember.getElement());
            }
        }

        private Type computeAndRecordSelectorTypes(DartExpression expression, Type receiver, String selectorName) {
            Type type = this.dynamicType();
            if (receiver != null && TypeKind.of(receiver).equals((Object)TypeKind.INTERFACE)) {
                InterfaceType baseType = (InterfaceType)receiver;
                HashSet types = Sets.newHashSet();
                for (InterfaceType subType : baseType.getElement().getSubtypes()) {
                    Type computedType;
                    InterfaceType sType = subType;
                    if (this.isParameterizedType(sType)) {
                        sType = this.substSubType(sType, baseType);
                    }
                    if ((computedType = this.computeAndRecordSelectorType(expression, sType, selectorName)) == null) continue;
                    type = computedType;
                    types.addAll(this.getConcreteSubTypes(type));
                }
                if (types.size() > 1) {
                    type = this.getCommonSuperType(types);
                    types = Sets.newHashSet((Object[])new Type[]{this.dynamicType()});
                }
                this.recordTypeInfo(expression, types);
            }
            return type;
        }

        private Type computeAndRecordSelectorType(DartExpression expression, InterfaceType type, String selectorName) {
            InterfaceType.Member iMember = type.lookupMember(selectorName);
            if (iMember != null) {
                Element element = iMember.getElement();
                switch (ElementKind.of(element)) {
                    case METHOD: {
                        if (!type.getElement().isInterface()) {
                            this.recordMethodImpl(expression, (MethodElement)element);
                            this.maybeAddObjectSelectors(expression, type, selectorName);
                        }
                        if (this.canInstantiateParametrizedType(iMember)) {
                            FunctionType ftype = (FunctionType)iMember.getType();
                            return ftype.getReturnType();
                        }
                        return this.dynamicType();
                    }
                    case FIELD: {
                        FieldElement fieldElement = (FieldElement)element;
                        this.recordFieldImpl(expression, fieldElement);
                        Modifiers modifiers = fieldElement.getModifiers();
                        if (modifiers.isAbstractField() && modifiers.isSetter()) {
                            return null;
                        }
                        return iMember.getType();
                    }
                }
            }
            return this.dynamicType();
        }

        private Set<Type> getConcreteSubTypes(Type type) {
            HashSet concreteTypes = Sets.newHashSet();
            if (TypeKind.of(type).equals((Object)TypeKind.INTERFACE)) {
                ClassElement cls = (ClassElement)type.getElement();
                for (InterfaceType subType : cls.getSubtypes()) {
                    if (subType.getElement().isInterface()) continue;
                    concreteTypes.add(this.substSubType(subType, (InterfaceType)type));
                }
            }
            return concreteTypes;
        }

        private InterfaceType substSubType(InterfaceType subType, InterfaceType baseType) {
            List<? extends Type> typeArgs = baseType.getArguments();
            List<? extends Type> typeParams = this.asInstanceOf(subType, baseType.getElement()).getArguments();
            if (typeArgs != null && !typeArgs.isEmpty()) {
                return subType.subst(typeArgs, typeParams);
            }
            return subType;
        }

        private boolean isParameterizedType(InterfaceType type) {
            return type.getArguments() != null && !type.getArguments().isEmpty();
        }

        private boolean canInstantiateParametrizedType(InterfaceType.Member member) {
            InterfaceType iface = member.getHolder();
            List<? extends Type> typeArgs = iface.getArguments();
            List<? extends Type> typeParams = iface.getElement().getTypeParameters();
            return typeArgs.size() == typeParams.size();
        }

        @Override
        public Type visitIdentifier(DartIdentifier node) {
            Element element = node.getTargetSymbol();
            switch (ElementKind.of(element)) {
                case CLASS: {
                    this.recordTypeInfo((DartExpression)node, element.getType());
                    return element.getType();
                }
                case VARIABLE: 
                case PARAMETER: {
                    Type type = element.getType();
                    this.recordTypeInfo((DartExpression)node, Sets.newHashSet((Object[])new Type[]{type}));
                    return type;
                }
                case FIELD: {
                    EnclosingElement enclosing = element.getEnclosingElement();
                    switch (ElementKind.of(enclosing)) {
                        case CLASS: {
                            ClassElement cls = (ClassElement)enclosing;
                            this.computeAndRecordSelectorTypes(node, cls.getType(), element.getName());
                            break;
                        }
                    }
                    return element.getType();
                }
            }
            return this.dynamicType();
        }

        @Override
        public Type visitUnaryExpression(DartUnaryExpression node) {
            this.maybeBindConstantValues(node.getArg(), true);
            Type receiver = this.computeType(node.getArg());
            Token op = node.getOperator();
            switch (node.getOperator()) {
                case NOT: {
                    assert (!op.isUserDefinableOperator());
                    receiver = this.boolType();
                    break;
                }
                case INC: 
                case DEC: {
                    assert (!op.isUserDefinableOperator());
                    receiver = this.intType();
                    break;
                }
                case SUB: 
                case BIT_NOT: {
                    this.computeAndRecordSelectorTypes(node, receiver, this.getOperatorSelectorName(op));
                }
            }
            this.recordTypeInfo((DartExpression)node, receiver);
            return receiver;
        }

        @Override
        public Type visitUnqualifiedInvocation(DartUnqualifiedInvocation node) {
            this.visit(node.getArgs());
            Type type = this.getType(node);
            if (node.getTarget() != null) {
                String selectorName = node.getTarget().getTargetName();
                Element element = node.getTarget().getTargetSymbol();
                if (element == null) {
                    return type;
                }
                EnclosingElement enclosing = element.getEnclosingElement();
                block0 : switch (ElementKind.of(enclosing)) {
                    case CLASS: {
                        ClassElement cls = (ClassElement)element.getEnclosingElement();
                        switch (ElementKind.of(element)) {
                            case FIELD: {
                                this.computeAndRecordSelectorTypes(node, cls.getType(), selectorName);
                                type = element.getType();
                                break block0;
                            }
                            case METHOD: {
                                this.computeAndRecordSelectorTypes(node, cls.getType(), selectorName);
                                FunctionType fType = (FunctionType)element.getType();
                                type = fType.getReturnType();
                                break block0;
                            }
                        }
                        type = element.getType();
                        break;
                    }
                    case LIBRARY: {
                        break;
                    }
                    case NONE: {
                        if (!TypeKind.of(element.getType()).equals((Object)TypeKind.FUNCTION)) break;
                        type = ((FunctionType)element.getType()).getReturnType();
                        this.recordTypeInfo((DartExpression)node, type);
                    }
                }
            }
            return type;
        }

        @Override
        public Type visitField(DartField node) {
            this.visitChildren(node);
            return this.getType(node);
        }

        @Override
        public Type visitFieldDefinition(DartFieldDefinition node) {
            this.visitChildrenAndReturnVoid(node);
            Type type = this.getType(node);
            return type;
        }

        @Override
        public Type visitFunctionExpression(DartFunctionExpression node) {
            this.visitChildren(node);
            return this.dynamicType();
        }

        @Override
        public Type visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            return this.dynamicType();
        }

        @Override
        public Type visitFunctionObjectInvocation(DartFunctionObjectInvocation node) {
            this.visit(node.getArgs());
            Type type = this.computeType(node.getTarget());
            this.recordTypeInfo((DartExpression)node, type);
            return type;
        }

        @Override
        public Type visitCase(DartCase node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitConditional(DartConditional node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitDoWhileStatement(DartDoWhileStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitForInStatement(DartForInStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitForStatement(DartForStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitIfStatement(DartIfStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitInitializer(DartInitializer node) {
            this.visit(node.getValue());
            return this.voidType();
        }

        @Override
        public Type visitLabel(DartLabel node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitReturnStatement(DartReturnStatement node) {
            return node.getValue() == null ? this.voidType() : this.computeType(node.getValue());
        }

        @Override
        public Type visitSuperExpression(DartSuperExpression node) {
            this.visitChildren(node);
            return this.getType(node);
        }

        @Override
        public Type visitSwitchStatement(DartSwitchStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitSyntheticErrorExpression(DartSyntheticErrorExpression node) {
            this.visitChildren(node);
            return this.dynamicType();
        }

        @Override
        public Type visitSyntheticErrorStatement(DartSyntheticErrorStatement node) {
            this.visitChildren(node);
            return this.dynamicType();
        }

        @Override
        public Type visitThrowStatement(DartThrowStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitCatchBlock(DartCatchBlock node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitTryStatement(DartTryStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitVariable(DartVariable node) {
            this.maybeBindConstantValues(node.getValue(), false);
            this.visit(node.getValue());
            return this.dynamicType();
        }

        @Override
        public Type visitVariableStatement(DartVariableStatement node) {
            Type type = this.computeType(node.getTypeNode());
            this.visitChildren(node);
            return type;
        }

        @Override
        public Type visitWhileStatement(DartWhileStatement node) {
            return this.visitChildrenAndReturnVoid(node);
        }

        @Override
        public Type visitNamedExpression(DartNamedExpression node) {
            this.visit(node.getExpression());
            return this.getType(node.getExpression());
        }

        @Override
        public Type visitTypeExpression(DartTypeExpression node) {
            return this.getType(node);
        }

        @Override
        public Type visitTypeParameter(DartTypeParameter node) {
            return this.getType(node);
        }

        @Override
        public Type visitNativeBlock(DartNativeBlock node) {
            return this.dynamicType();
        }

        @Override
        public Type visitRedirectConstructorInvocation(DartRedirectConstructorInvocation node) {
            return this.getType(node);
        }

        @Override
        public Type visitSuperConstructorInvocation(DartSuperConstructorInvocation node) {
            return this.getType(node);
        }

        @Override
        public Type visitParameterizedTypeNode(DartParameterizedTypeNode node) {
            return node.getExpression().accept(this);
        }

        private Type recordTypeInfo(DartExpression node, Type type) {
            if (type == null) {
                return type;
            }
            DartExpression targetNode = node.getNormalizedNode();
            Map<DartExpression, Set<Type>> typeSets = this.typeInfo.getTypeSets();
            Set<Type> types = typeSets.get(targetNode);
            if (types == null) {
                types = new HashSet<Type>();
            }
            switch (TypeKind.of(type)) {
                case INTERFACE: {
                    ClassElement cls = (ClassElement)type.getElement();
                    for (InterfaceType subType : cls.getSubtypes()) {
                        InterfaceType rSubType = this.substSubType(subType, (InterfaceType)type);
                        if (rSubType.getElement().isInterface()) continue;
                        types.add(rSubType);
                    }
                    break;
                }
                case FUNCTION: 
                case FUNCTION_ALIAS: 
                case VARIABLE: 
                case DYNAMIC: 
                case NONE: {
                    types.add(this.dynamicType());
                }
            }
            if (!types.isEmpty()) {
                typeSets.put(targetNode, types);
            }
            return type;
        }

        private void recordMethodImpl(DartExpression expression, MethodElement method) {
            assert (method != null);
            HashSet methodImpls = this.typeInfo.getMethodImpl().get(expression);
            if (methodImpls == null) {
                methodImpls = Sets.newHashSet();
                this.typeInfo.getMethodImpl().put(expression, methodImpls);
            }
            methodImpls.add(method);
        }

        private void recordFieldImpl(DartExpression expression, FieldElement field) {
            Modifiers modifiers;
            HashSet setters;
            assert (field != null);
            HashSet getters = this.typeInfo.getGettersImpl().get(expression);
            if (getters == null) {
                getters = Sets.newHashSet();
                this.typeInfo.getGettersImpl().put(expression, getters);
            }
            if ((setters = this.typeInfo.getSettersImpl().get(expression)) == null) {
                setters = Sets.newHashSet();
                this.typeInfo.getSettersImpl().put(expression, setters);
            }
            if ((modifiers = field.getModifiers()).isAbstractField()) {
                if (field.getSetter() != null) {
                    setters.add(field);
                }
                if (field.getGetter() != null) {
                    getters.add(field);
                }
            } else {
                getters.add(field);
                setters.add(field);
            }
        }

        private void recordTypeInfo(DartExpression node, Set<Type> types) {
            for (Type type : types) {
                this.recordTypeInfo(node, type);
            }
        }

        void visitChildren(DartNode node) {
            node.getNormalizedNode().visitChildren(this);
        }

        private Type visitChildrenAndReturnVoid(DartNode node) {
            this.visitChildren(node);
            return this.voidType();
        }

        private Type visit(DartExpression expression) {
            if (expression != null) {
                return expression.getNormalizedNode().accept(this);
            }
            return this.voidType();
        }

        Type getType(DartNode node) {
            return node == null ? this.dynamicType() : node.getNormalizedNode().getType();
        }

        Type computeType(DartNode node) {
            return node == null ? this.dynamicType() : node.getNormalizedNode().accept(this);
        }

        private Type dynamicType() {
            return this.typeProvider.getDynamicType();
        }

        private Type nullType() {
            return this.typeProvider.getNullType();
        }

        private Type boolType() {
            return this.typeProvider.getBoolType();
        }

        private Type intType() {
            return this.typeProvider.getIntType();
        }

        private Type voidType() {
            return this.typeProvider.getVoidType();
        }

        private String getOperatorSelectorName(Token op) {
            switch (op) {
                case SUB: {
                    return "operator negate";
                }
                case ASSIGN_ADD: {
                    return this.getOperatorSelectorName(Token.ADD);
                }
                case ASSIGN_SUB: {
                    return this.getOperatorSelectorName(Token.SUB);
                }
                case ASSIGN_MUL: {
                    return this.getOperatorSelectorName(Token.MUL);
                }
                case ASSIGN_DIV: {
                    return this.getOperatorSelectorName(Token.DIV);
                }
                case ASSIGN_BIT_OR: {
                    return this.getOperatorSelectorName(Token.BIT_OR);
                }
                case ASSIGN_BIT_XOR: {
                    return this.getOperatorSelectorName(Token.BIT_XOR);
                }
                case ASSIGN_BIT_AND: {
                    return this.getOperatorSelectorName(Token.BIT_AND);
                }
                case ASSIGN_SHL: {
                    return this.getOperatorSelectorName(Token.SHL);
                }
                case ASSIGN_SAR: {
                    return this.getOperatorSelectorName(Token.SAR);
                }
                case ASSIGN_SHR: {
                    return this.getOperatorSelectorName(Token.SHR);
                }
            }
            return "operator " + op.getSyntax();
        }

        private InterfaceType asInstanceOf(Type t, ClassElement element) {
            return this.typeUtils.asInstanceOf(t, element);
        }

        private Type getCommonSuperType(Set<Type> ts) {
            if (ts.size() == 1) {
                return ts.iterator().next();
            }
            for (Type t : ts) {
                if (!TypeKind.of(t).equals((Object)TypeKind.INTERFACE) || !this.isSuperTypeOf(t, ts) || ((ClassElement)t.getElement()).isObject()) continue;
                return t;
            }
            return this.dynamicType();
        }

        private boolean isSuperTypeOf(Type type, Set<Type> sts) {
            for (Type st : sts) {
                st.getClass();
                type.getClass();
                if (this.typeUtils.isSubtype(st, type)) continue;
                return false;
            }
            return true;
        }
    }
}

