/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast.viz;

import com.google.common.io.Closeables;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.viz.BaseASTWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DotWriter
extends BaseASTWriter {
    private Map<DartNode, String> nodeMap;
    private FileWriter out;
    private StringBuffer edges;
    private StringBuffer nodes;
    private DartUnit currentUnit;
    private Set<String> printDataNodes = new HashSet<String>(Arrays.asList(dataLabels));
    private static final String[] dataLabels = new String[]{"DartIdentifier", "DartVariable", "DartField", "DartParameter", "DartClass", "DartMethodDefinition"};

    public DotWriter(String outputDir) {
        super(outputDir);
    }

    @Override
    protected void startHook(DartUnit unit) {
        String nodeData = String.format("%s", unit.getSourceName());
        this.nodeMap = new HashMap<DartNode, String>();
        this.nodeMap.put(unit, nodeData);
        this.edges = new StringBuffer();
        this.nodes = new StringBuffer();
        this.currentUnit = unit;
        if (!this.isIgnored(unit)) {
            String dotFilePath = this.outputDir + File.separator + unit.getSource().getUri() + ".ast.dot";
            this.makeParentDirs(dotFilePath);
            try {
                this.out = new FileWriter(new File(dotFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void endHook(DartUnit unit) {
        if (!this.isIgnored(unit)) {
            String dotGraph = "digraph G{\n" + this.nodes.toString() + this.edges.toString() + "}";
            try {
                this.out.append(dotGraph);
                Closeables.close((Closeable)this.out, (boolean)true);
            }
            catch (IOException e) {
                System.err.println("Error while writing AST to dot file");
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void write(String nodeType, DartNode node, String data) {
        String nodeId = node.getObjectIdentifier();
        this.nodeMap.put(node, nodeId);
        DartNode parent = node.getParent();
        if (parent == null) {
            parent = this.currentUnit;
        }
        String styleAttr = this.getStyleAttr(nodeType, node);
        String label = this.getLabel(nodeType, node, data);
        this.nodes.append(String.format("\t\"%s\" [label=\"%s\"%s];\n", nodeId, label, styleAttr));
        this.edges.append(String.format("\t\"%s\" -> \"%s\";\n", this.nodeMap.get(parent), nodeId));
    }

    private String getLabel(String nodeType, DartNode node, String data) {
        StringBuffer label = new StringBuffer(nodeType);
        if (this.printDataNodes.contains(nodeType) || node instanceof DartExpression) {
            label.append(String.format("\\n%s", this.escape(data)));
        }
        return label.toString();
    }

    private String escape(String data) {
        data = data.replaceAll("\"", "'");
        data = data.replaceAll("\n", "\\n");
        data = data.replaceAll("\r", "\\r");
        return data;
    }

    private String getStyleAttr(String nodeType, DartNode node) {
        StringBuffer style = new StringBuffer();
        if (nodeType.endsWith("Literal") || "DartIdentifier".equals(nodeType)) {
            style.append(", shape=box");
        } else if ("DartClass".equals(nodeType)) {
            style.append(", shape=doubleoctagon");
        } else if ("DartMethodDefinition".equals(nodeType)) {
            style.append(", color=blue");
        }
        if (node.isInstrumentedNode()) {
            style.append(", style=filled, fillcolor=yellow");
        }
        return style.toString();
    }
}

