/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast.viz;

import com.google.dart.compiler.ast.DartArrayAccess;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartAssertion;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartBreakStatement;
import com.google.dart.compiler.ast.DartCase;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartConditional;
import com.google.dart.compiler.ast.DartContinueStatement;
import com.google.dart.compiler.ast.DartDefault;
import com.google.dart.compiler.ast.DartDoWhileStatement;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartEmptyStatement;
import com.google.dart.compiler.ast.DartExprStmt;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartForInStatement;
import com.google.dart.compiler.ast.DartForStatement;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIfStatement;
import com.google.dart.compiler.ast.DartImportDirective;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartLabel;
import com.google.dart.compiler.ast.DartLibraryDirective;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMapLiteralEntry;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNamedExpression;
import com.google.dart.compiler.ast.DartNativeBlock;
import com.google.dart.compiler.ast.DartNativeDirective;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNodeTraverser;
import com.google.dart.compiler.ast.DartNullLiteral;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartParenthesizedExpression;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartResourceDirective;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartSourceDirective;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartSwitchStatement;
import com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import com.google.dart.compiler.ast.DartSyntheticErrorStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartThrowStatement;
import com.google.dart.compiler.ast.DartTryStatement;
import com.google.dart.compiler.ast.DartTypeExpression;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartWhileStatement;
import com.google.dart.compiler.ast.LibraryUnit;
import java.io.File;
import java.util.List;

public abstract class BaseASTWriter {
    private static final String[] ignoredLibs = new String[]{"corelib", "corelib_impl", "dom", "html", "htmlimpl", "base", "touch", "view", "utilslib", "observable", "layout.dart", "unittest", "dartest"};
    protected final String outputDir;
    private final ASTNodeTraverser visitor;

    BaseASTWriter(String outputDir) {
        this.outputDir = outputDir;
        this.visitor = new ASTNodeTraverser();
    }

    private void write(String nodeType, DartNode node) {
        this.write(nodeType, node, "");
    }

    protected abstract void write(String var1, DartNode var2, String var3);

    protected abstract void endHook(DartUnit var1);

    protected abstract void startHook(DartUnit var1);

    public void process(DartUnit unit) {
        this.startHook(unit);
        unit.accept(this.visitor);
        this.endHook(unit);
    }

    protected boolean makeParentDirs(String filePath) {
        int index = filePath.lastIndexOf(File.separator);
        String dirPath = filePath.substring(0, index);
        return new File(dirPath).mkdirs();
    }

    protected void visitChildren(DartNode node) {
        node.visitChildren(this.visitor);
    }

    boolean isIgnored(DartUnit unit) {
        LibraryUnit lu = unit.getLibrary();
        if (lu != null) {
            String libName = lu.getName();
            for (String ignoredLib : ignoredLibs) {
                if (!ignoredLib.equals(libName)) continue;
                return true;
            }
        }
        return false;
    }

    class ASTNodeTraverser
    extends DartNodeTraverser<Object> {
        ASTNodeTraverser() {
        }

        @Override
        public void visit(List<? extends DartNode> nodes) {
            if (nodes != null) {
                for (DartNode dartNode : nodes) {
                    dartNode.accept(this);
                }
            }
        }

        @Override
        public Object visitArrayAccess(DartArrayAccess node) {
            BaseASTWriter.this.write("DartArrayAccess", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitArrayLiteral(DartArrayLiteral node) {
            BaseASTWriter.this.write("DartArrayLiteral", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitAssertion(DartAssertion node) {
            BaseASTWriter.this.write("DartAssertion", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitBinaryExpression(DartBinaryExpression node) {
            BaseASTWriter.this.write("DartBinaryExpression", node, node.getOperator().name());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitBlock(DartBlock node) {
            BaseASTWriter.this.write("DartBlock", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitBooleanLiteral(DartBooleanLiteral node) {
            BaseASTWriter.this.write("DartBooleanLiteral", node, new Boolean(node.getValue()).toString());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitBreakStatement(DartBreakStatement node) {
            BaseASTWriter.this.write("DartBreakStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitFunctionObjectInvocation(DartFunctionObjectInvocation node) {
            BaseASTWriter.this.write("DartFunctionObjectInvocation", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitMethodInvocation(DartMethodInvocation node) {
            BaseASTWriter.this.write("DartMethodInvocation", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitSuperConstructorInvocation(DartSuperConstructorInvocation node) {
            BaseASTWriter.this.write("DartSuperConstructorInvocation", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitCase(DartCase node) {
            BaseASTWriter.this.write("DartCase", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitClass(DartClass node) {
            String type = "class ";
            if (node.isInterface()) {
                type = "interface ";
            }
            BaseASTWriter.this.write("DartClass", node, type + node.getClassName());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitConditional(DartConditional node) {
            BaseASTWriter.this.write("DartConditional", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitContinueStatement(DartContinueStatement node) {
            BaseASTWriter.this.write("DartContinueStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitDefault(DartDefault node) {
            BaseASTWriter.this.write("DartDefault", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitDoubleLiteral(DartDoubleLiteral node) {
            BaseASTWriter.this.write("DartDoubleLiteral", node, new Double(node.getValue()).toString());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitDoWhileStatement(DartDoWhileStatement node) {
            BaseASTWriter.this.write("DartDoWhileStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitEmptyStatement(DartEmptyStatement node) {
            BaseASTWriter.this.write("DartEmptyStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitExprStmt(DartExprStmt node) {
            BaseASTWriter.this.write("DartExprStmt", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitField(DartField node) {
            BaseASTWriter.this.write("DartField", node, ((DartIdentifier)node.getName()).getTargetName());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitFieldDefinition(DartFieldDefinition node) {
            BaseASTWriter.this.write("DartFieldDefinition", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitForInStatement(DartForInStatement node) {
            BaseASTWriter.this.write("DartForInStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitForStatement(DartForStatement node) {
            BaseASTWriter.this.write("DartForStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitFunction(DartFunction node) {
            BaseASTWriter.this.write("DartFunction", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitFunctionExpression(DartFunctionExpression node) {
            DartIdentifier name = node.getName();
            BaseASTWriter.this.write("DartFunctionExpression", node, name != null ? name.toString() : "");
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            BaseASTWriter.this.write("DartFunctionTypeAlias", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitIdentifier(DartIdentifier node) {
            BaseASTWriter.this.write("DartIdentifier", node, node.getTargetName());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitIfStatement(DartIfStatement node) {
            BaseASTWriter.this.write("DartIfStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitImportDirective(DartImportDirective node) {
            BaseASTWriter.this.write("DartImportDirective", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitInitializer(DartInitializer node) {
            BaseASTWriter.this.write("DartInitializer", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitIntegerLiteral(DartIntegerLiteral node) {
            BaseASTWriter.this.write("DartIntegerLiteral", node, node.getValue().toString());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitLabel(DartLabel node) {
            BaseASTWriter.this.write("DartLabel", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitLibraryDirective(DartLibraryDirective node) {
            BaseASTWriter.this.write("DartLibraryDirective", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitMapLiteral(DartMapLiteral node) {
            BaseASTWriter.this.write("DartMapLiteral", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitMapLiteralEntry(DartMapLiteralEntry node) {
            BaseASTWriter.this.write("DartMapLiteralEntry", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitMethodDefinition(DartMethodDefinition node) {
            BaseASTWriter.this.write("DartMethodDefinition", node, ((DartNode)node.getName()).toString());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitNativeDirective(DartNativeDirective node) {
            BaseASTWriter.this.write("DartNativeDirective", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitNewExpression(DartNewExpression node) {
            BaseASTWriter.this.write("DartNewExpression", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitNullLiteral(DartNullLiteral node) {
            BaseASTWriter.this.write("DartNullLiteral", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitParameter(DartParameter node) {
            BaseASTWriter.this.write("DartParameter", node, node.getParameterName());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitParameterizedTypeNode(DartParameterizedTypeNode node) {
            BaseASTWriter.this.write("DartParameterizedNode", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitParenthesizedExpression(DartParenthesizedExpression node) {
            BaseASTWriter.this.write("DartParenthesizedExpression", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitPropertyAccess(DartPropertyAccess node) {
            BaseASTWriter.this.write("DartPropertyAccess", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitTypeNode(DartTypeNode node) {
            BaseASTWriter.this.write("DartTypeNode", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitResourceDirective(DartResourceDirective node) {
            BaseASTWriter.this.write("DartResourceDirective", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitReturnStatement(DartReturnStatement node) {
            BaseASTWriter.this.write("DartReturnStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitSourceDirective(DartSourceDirective node) {
            BaseASTWriter.this.write("DartSourceDirective", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitStringLiteral(DartStringLiteral node) {
            BaseASTWriter.this.write("DartStringLiteral", node, '\"' + node.getValue() + '\"');
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitStringInterpolation(DartStringInterpolation node) {
            BaseASTWriter.this.write("DartStringInterpolation", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitSuperExpression(DartSuperExpression node) {
            BaseASTWriter.this.write("DartSuperExpression", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitSwitchStatement(DartSwitchStatement node) {
            BaseASTWriter.this.write("DartSwitchStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitSyntheticErrorExpression(DartSyntheticErrorExpression node) {
            BaseASTWriter.this.write("DartSyntheticErrorExpression(", node, node.getTokenString() + ")");
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitSyntheticErrorStatement(DartSyntheticErrorStatement node) {
            BaseASTWriter.this.write("DartSyntheticErrorStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitThisExpression(DartThisExpression node) {
            BaseASTWriter.this.write("DartThisExpression", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitThrowStatement(DartThrowStatement node) {
            BaseASTWriter.this.write("DartThrowStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitCatchBlock(DartCatchBlock node) {
            BaseASTWriter.this.write("DartCatchBlock", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitTryStatement(DartTryStatement node) {
            BaseASTWriter.this.write("DartTryStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitUnaryExpression(DartUnaryExpression node) {
            BaseASTWriter.this.write("DartUnaryExpression", node, node.getOperator().name());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitUnit(DartUnit node) {
            if (!BaseASTWriter.this.isIgnored(node)) {
                BaseASTWriter.this.visitChildren(node);
            }
            return null;
        }

        @Override
        public Object visitUnqualifiedInvocation(DartUnqualifiedInvocation node) {
            BaseASTWriter.this.write("DartUnqualifiedInvocation", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitVariable(DartVariable node) {
            BaseASTWriter.this.write("DartVariable", node, node.getVariableName());
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitVariableStatement(DartVariableStatement node) {
            BaseASTWriter.this.write("DartVariableStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitWhileStatement(DartWhileStatement node) {
            BaseASTWriter.this.write("DartWhileStatement", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitNamedExpression(DartNamedExpression node) {
            BaseASTWriter.this.write("DartNamedExpression", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitTypeExpression(DartTypeExpression node) {
            BaseASTWriter.this.write("DartTypeExpression", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitTypeParameter(DartTypeParameter node) {
            BaseASTWriter.this.write("DartTypeParameter", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitNativeBlock(DartNativeBlock node) {
            BaseASTWriter.this.write("DartNativeBlock", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }

        @Override
        public Object visitRedirectConstructorInvocation(DartRedirectConstructorInvocation node) {
            BaseASTWriter.this.write("DartRedirectConstructorInvocation", node);
            BaseASTWriter.this.visitChildren(node);
            return null;
        }
    }
}

