/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast.viz;

import com.google.dart.compiler.CommandLineOptions;
import com.google.dart.compiler.CompilerConfiguration;
import com.google.dart.compiler.ast.viz.BaseASTWriter;
import com.google.dart.compiler.ast.viz.ConsoleWriter;
import com.google.dart.compiler.ast.viz.DotWriter;
import com.google.dart.compiler.ast.viz.NullWriter;
import com.google.dart.compiler.ast.viz.TextWriter;

public class ASTWriterFactory {
    public static BaseASTWriter create(CompilerConfiguration config) {
        String astFormat = config.getCompilerOptions().dumpAST();
        CommandLineOptions.CompilerOptions compilerOptions = config.getCompilerOptions();
        String outDir = compilerOptions.getWorkDirectory().getAbsolutePath();
        if ("console".equals(astFormat)) {
            return new ConsoleWriter(outDir);
        }
        if ("text".equals(astFormat)) {
            return new TextWriter(outDir);
        }
        if ("dot".equals(astFormat)) {
            return new DotWriter(outDir);
        }
        return new NullWriter(outDir);
    }
}

