/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

public class Modifiers {
    public static final Modifiers NONE = new Modifiers();
    private static final int FLAG_STATIC = 1;
    private static final int FLAG_CONSTANT = 2;
    private static final int FLAG_FACTORY = 4;
    private static final int FLAG_ABSTRACT = 8;
    private static final int FLAG_GETTER = 16;
    private static final int FLAG_SETTER = 32;
    private static final int FLAG_OPERATOR = 64;
    private static final int FLAG_NATIVE = 128;
    private static final int FLAG_INLINABLE = 256;
    private static final int FLAG_ABSTRACTFIELD = 512;
    private static final int FLAG_REDIRECTEDCONSTRUCTOR = 1024;
    private static final int FLAG_FINAL = 2048;
    private static final int FLAG_NAMED = 4096;
    private final int value;

    public boolean isStatic() {
        return this.is(1);
    }

    public boolean isConstant() {
        return this.is(2);
    }

    public boolean isFactory() {
        return this.is(4);
    }

    public boolean isAbstract() {
        return this.is(8);
    }

    public boolean isGetter() {
        return this.is(16);
    }

    public boolean isSetter() {
        return this.is(32);
    }

    public boolean isOperator() {
        return this.is(64);
    }

    public boolean isNative() {
        return this.is(128);
    }

    public boolean isInlinable() {
        return this.is(256);
    }

    public boolean isAbstractField() {
        return this.is(512);
    }

    public boolean isRedirectedConstructor() {
        return this.is(1024);
    }

    public boolean isFinal() {
        return this.is(2048);
    }

    public boolean isNamed() {
        return this.is(4096);
    }

    public Modifiers makeStatic() {
        return this.make(1);
    }

    public Modifiers makeConstant() {
        return this.make(2);
    }

    public Modifiers makeFactory() {
        return this.make(4);
    }

    public Modifiers makeAbstract() {
        return this.make(8);
    }

    public Modifiers makeGetter() {
        return this.make(16);
    }

    public Modifiers makeSetter() {
        return this.make(32);
    }

    public Modifiers makeOperator() {
        return this.make(64);
    }

    public Modifiers makeNative() {
        return this.make(128);
    }

    public Modifiers makeInlinable() {
        return this.make(256);
    }

    public Modifiers makeAbstractField() {
        return this.make(512);
    }

    public Modifiers makeRedirectedConstructor() {
        return this.make(1024);
    }

    public Modifiers makeFinal() {
        return this.make(2048);
    }

    public Modifiers makeNamed() {
        return this.make(4096);
    }

    public Modifiers removeStatic() {
        return this.remove(1);
    }

    public Modifiers removeConstant() {
        return this.remove(2);
    }

    public Modifiers removeFactory() {
        return this.remove(4);
    }

    public Modifiers removeAbstract() {
        return this.remove(8);
    }

    public Modifiers removeGetter() {
        return this.remove(16);
    }

    public Modifiers removeSetter() {
        return this.remove(32);
    }

    public Modifiers removeOperator() {
        return this.remove(64);
    }

    public Modifiers removeNative() {
        return this.remove(128);
    }

    public Modifiers removeInlinable() {
        return this.remove(256);
    }

    public Modifiers removeAbstractField() {
        return this.remove(512);
    }

    public Modifiers removeRedirectedConstructor() {
        return this.remove(1024);
    }

    public Modifiers removeFinal() {
        return this.remove(2048);
    }

    public Modifiers removeNamed() {
        return this.remove(4096);
    }

    public boolean is(int flag) {
        return (this.value & flag) != 0;
    }

    public boolean is(Modifiers modifier) {
        return this.is(modifier.value);
    }

    public Modifiers make(int flag) {
        return new Modifiers(this.value | flag);
    }

    public Modifiers remove(int flag) {
        return new Modifiers(this.value & ~flag);
    }

    private Modifiers() {
        this.value = 0;
    }

    private Modifiers(int value) {
        this.value = value;
    }
}

