/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.ast.Modifiers;
import java.util.List;

public class DartVariableStatement
extends DartStatement {
    private final List<DartVariable> vars;
    private DartTypeNode typeNode;
    private final Modifiers modifiers;

    public DartVariableStatement(List<DartVariable> vars, DartTypeNode type) {
        this(vars, type, Modifiers.NONE);
    }

    public DartVariableStatement(List<DartVariable> vars, DartTypeNode type, Modifiers modifiers) {
        this.vars = this.becomeParentOf(vars);
        this.typeNode = this.becomeParentOf(type);
        this.modifiers = modifiers;
    }

    public List<DartVariable> getVariables() {
        return this.vars;
    }

    public DartTypeNode getTypeNode() {
        return this.typeNode;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.typeNode != null) {
                this.typeNode = (DartTypeNode)this.becomeParentOf((DartNode)v.accept(this.typeNode));
            }
            v.acceptWithInsertRemove(this, this.getVariables());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.typeNode != null) {
            this.typeNode.accept(visitor);
        }
        visitor.visit(this.vars);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitVariableStatement(this);
    }
}

