/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.common.collect.Lists;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ast.DartComment;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartDirective;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartToSourceVisitor;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.util.DefaultTextOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DartUnit
extends DartNode {
    private static final long serialVersionUID = -3407637869012712127L;
    private LibraryUnit library;
    private List<DartDirective> directives;
    private final List<DartNode> topLevelNodes = Lists.newArrayList();
    private final DartSource source;
    private List<DartComment> comments;
    private boolean isDiet;
    private String dietParse;

    public DartUnit(DartSource source) {
        this.source = source;
    }

    public void addTopLevelNode(DartNode node) {
        this.topLevelNodes.add(this.becomeParentOf(node));
    }

    public String getSourceName() {
        return this.source.getName();
    }

    @Override
    public DartSource getSource() {
        return this.source;
    }

    public void addComment(DartComment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<DartComment>();
        }
        this.comments.add(this.becomeParentOf(comment));
    }

    public List<DartComment> getComments() {
        return this.comments == null ? null : Collections.unmodifiableList(this.comments);
    }

    public boolean removeComment(DartComment comment) {
        return this.comments == null ? false : this.comments.remove(comment);
    }

    public void setLibrary(LibraryUnit library) {
        this.library = library;
    }

    public LibraryUnit getLibrary() {
        return this.library;
    }

    public List<DartNode> getTopLevelNodes() {
        return this.topLevelNodes;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.directives != null) {
                v.acceptWithInsertRemove(this, this.directives);
            }
            v.acceptWithInsertRemove(this, this.topLevelNodes);
            if (this.comments != null) {
                v.acceptWithInsertRemove(this, this.comments);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.directives != null) {
            visitor.visit(this.directives);
        }
        visitor.visit(this.topLevelNodes);
        if (this.comments != null) {
            visitor.visit(this.comments);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitUnit(this);
    }

    public void setDiet(boolean isDiet) {
        this.isDiet = isDiet;
    }

    public boolean isDiet() {
        return this.isDiet;
    }

    public final String toDietSource() {
        if (this.dietParse == null) {
            DefaultTextOutput out = new DefaultTextOutput(false);
            new DartToSourceVisitor(out, true, true).accept(this);
            this.dietParse = out.toString();
        }
        return this.dietParse;
    }

    public void addDirective(DartDirective directive) {
        if (this.directives == null) {
            this.directives = new ArrayList<DartDirective>();
        }
        this.directives.add(this.becomeParentOf(directive));
    }

    public List<DartDirective> getDirectives() {
        if (this.directives == null) {
            return Collections.emptyList();
        }
        return this.directives;
    }
}

