/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.type.Type;
import java.util.ArrayList;
import java.util.List;

public class DartTypeNode
extends DartNode {
    private DartNode identifier;
    private List<DartTypeNode> typeArguments = new ArrayList<DartTypeNode>();
    private Type type;

    public DartTypeNode(DartNode identifier) {
        this(identifier, new ArrayList<DartTypeNode>());
    }

    public DartTypeNode(DartNode identifier, List<DartTypeNode> typeArguments) {
        this.identifier = this.becomeParentOf(identifier);
        this.typeArguments = this.becomeParentOf(typeArguments);
    }

    public DartNode getIdentifier() {
        return this.identifier;
    }

    public List<DartTypeNode> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.identifier = this.becomeParentOf(v.accept(this.identifier));
            v.acceptWithInsertRemove(this, this.typeArguments);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.identifier.accept(visitor);
        visitor.visit(this.typeArguments);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitTypeNode(this);
    }
}

