/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartVisitor;
import java.util.List;

public class DartTryStatement
extends DartStatement {
    private DartBlock tryBlock;
    private List<DartCatchBlock> catchBlocks;
    private DartBlock finallyBlock;

    public DartTryStatement(DartBlock tryBlock, List<DartCatchBlock> catchBlocks, DartBlock finallyBlock) {
        this.tryBlock = this.becomeParentOf(tryBlock);
        this.catchBlocks = this.becomeParentOf(catchBlocks);
        this.finallyBlock = this.becomeParentOf(finallyBlock);
    }

    public List<DartCatchBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    public DartBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public DartBlock getTryBlock() {
        return this.tryBlock;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.tryBlock = (DartBlock)this.becomeParentOf((DartNode)v.accept(this.tryBlock));
            v.acceptWithInsertRemove(this, this.catchBlocks);
            if (this.finallyBlock != null) {
                this.finallyBlock = (DartBlock)this.becomeParentOf((DartNode)v.accept(this.finallyBlock));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.tryBlock.accept(visitor);
        visitor.visit(this.catchBlocks);
        if (this.finallyBlock != null) {
            this.finallyBlock.accept(visitor);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitTryStatement(this);
    }
}

