/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.common.collect.Lists;
import com.google.dart.compiler.ast.DartArrayAccess;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartAssertion;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartBreakStatement;
import com.google.dart.compiler.ast.DartCase;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartConditional;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartContinueStatement;
import com.google.dart.compiler.ast.DartDefault;
import com.google.dart.compiler.ast.DartDoWhileStatement;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartEmptyStatement;
import com.google.dart.compiler.ast.DartExprStmt;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartForInStatement;
import com.google.dart.compiler.ast.DartForStatement;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIfStatement;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartLabel;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMapLiteralEntry;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNamedExpression;
import com.google.dart.compiler.ast.DartNativeBlock;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNullLiteral;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartParenthesizedExpression;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartSwitchStatement;
import com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import com.google.dart.compiler.ast.DartSyntheticErrorStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartThrowStatement;
import com.google.dart.compiler.ast.DartTryStatement;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartVisitable;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.ast.DartWhileStatement;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.common.GenerateSourceMap;
import com.google.dart.compiler.common.HasSourceInfo;
import com.google.dart.compiler.common.SourceMapping;
import com.google.dart.compiler.util.TextOutput;
import com.google.debugging.sourcemap.FilePosition;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DartToSourceVisitor
extends DartVisitor {
    private final TextOutput out;
    private boolean buildMappings;
    private List<SourceMapping> mappings = Lists.newArrayList();
    private final boolean isDiet;
    private final boolean calculateHash;

    public DartToSourceVisitor(TextOutput out) {
        this(out, false);
    }

    public DartToSourceVisitor(TextOutput out, boolean isDiet) {
        this.out = out;
        this.isDiet = isDiet;
        this.calculateHash = false;
    }

    public DartToSourceVisitor(TextOutput out, boolean isDiet, boolean calculateHash) {
        this.out = out;
        this.isDiet = isDiet;
        this.calculateHash = calculateHash;
    }

    public void generateSourceMap(boolean generate) {
        this.buildMappings = generate;
    }

    public void writeSourceMap(Appendable out, String name) throws IOException {
        GenerateSourceMap generator = new GenerateSourceMap();
        for (SourceMapping m : this.mappings) {
            generator.addMapping(m.getNode(), m.getStart(), m.getEnd());
        }
        generator.appendTo(out, name);
    }

    @Override
    public void doTraverse(DartVisitable x, DartContext ctx) {
        SourceMapping m = null;
        boolean mapThis = this.shouldMap(x);
        if (mapThis) {
            m = new SourceMapping((HasSourceInfo)((Object)x), new FilePosition(this.out.getLine(), this.out.getColumn()));
            this.mappings.add(m);
        }
        super.doTraverse(x, ctx);
        if (mapThis) {
            m.setEnd(new FilePosition(this.out.getLine(), this.out.getColumn()));
        }
    }

    private boolean shouldMap(DartVisitable x) {
        return this.buildMappings && !(x instanceof DartExprStmt);
    }

    @Override
    public boolean visit(DartUnit x, DartContext ctx) {
        this.p("// unit " + x.getSourceName());
        this.nl();
        this.acceptList(x.getTopLevelNodes());
        return false;
    }

    @Override
    public boolean visit(DartNativeBlock x, DartContext ctx) {
        this.p("native;");
        return false;
    }

    private void pTypeParameters(List<DartTypeParameter> typeParameters) {
        if (typeParameters != null && !typeParameters.isEmpty()) {
            this.p("<");
            boolean first = true;
            for (DartTypeParameter node : typeParameters) {
                if (!first) {
                    this.p(", ");
                }
                this.accept(node);
                first = false;
            }
            this.p(">");
        }
    }

    @Override
    public boolean visit(DartFunctionTypeAlias x, DartContext ctx) {
        this.p("typedef ");
        if (x.getReturnTypeNode() != null) {
            this.accept(x.getReturnTypeNode());
        }
        this.p(" ");
        this.accept(x.getName());
        this.pTypeParameters(x.getTypeParameters());
        this.p("(");
        this.printSeparatedByComma(x.getParameters());
        this.p(")");
        this.p(";");
        this.nl();
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartClass x, DartContext ctx) {
        List<DartTypeNode> interfaces;
        int start = 0;
        if (this.calculateHash) {
            start = this.out.getPosition();
        }
        if (x.isInterface()) {
            this.p("interface ");
        } else {
            this.p("class ");
        }
        this.accept(x.getName());
        this.pTypeParameters(x.getTypeParameters());
        if (x.getSuperclass() != null) {
            this.p(" extends ");
            this.accept(x.getSuperclass());
        }
        if ((interfaces = x.getInterfaces()) != null && !interfaces.isEmpty()) {
            if (x.isInterface()) {
                this.p(" extends ");
            } else {
                this.p(" implements ");
            }
            boolean first = true;
            for (DartTypeNode cls : interfaces) {
                if (!first) {
                    this.p(", ");
                }
                this.accept(cls);
                first = false;
            }
        }
        if (x.getNativeName() != null) {
            this.p(" native ");
            this.accept(x.getNativeName());
        }
        if (x.getDefaultClass() != null) {
            this.p(" default ");
            this.accept(x.getDefaultClass());
        }
        this.p(" {");
        this.nl();
        this.indent();
        this.acceptList(x.getMembers());
        this.outdent();
        this.p("}");
        if (this.calculateHash) {
            x.setHash(this.out.toString().substring(start, this.out.getPosition()).hashCode());
        }
        this.nl();
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartTypeNode x, DartContext ctx) {
        this.accept(x.getIdentifier());
        List<DartTypeNode> arguments = x.getTypeArguments();
        if (arguments != null && !arguments.isEmpty()) {
            this.p("<");
            this.printSeparatedByComma(arguments);
            this.p(">");
        }
        return false;
    }

    @Override
    public boolean visit(DartTypeParameter x, DartContext ctx) {
        this.accept(x.getName());
        DartTypeNode bound = x.getBound();
        if (bound != null) {
            this.p(" extends ");
            this.accept(bound);
        }
        return false;
    }

    @Override
    public boolean visit(DartFieldDefinition x, DartContext ctx) {
        Modifiers modifiers = x.getFields().get(0).getModifiers();
        if (modifiers.isAbstractField()) {
            this.pAbstractField(x, ctx);
        } else {
            this.pFieldModifiers(x);
            if (x.getTypeNode() != null) {
                this.accept(x.getTypeNode());
                this.p(" ");
            } else if (!modifiers.isFinal()) {
                this.p("var ");
            }
            this.printSeparatedByComma(x.getFields());
            this.p(";");
        }
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartField x, DartContext ctx) {
        this.accept(x.getName());
        if (x.getValue() != null) {
            this.p(" = ");
            this.accept(x.getValue());
        }
        return false;
    }

    @Override
    public boolean visit(DartParameter x, DartContext ctx) {
        if (x.getModifiers().isFinal()) {
            this.p("final ");
        }
        if (x.getTypeNode() != null) {
            this.accept(x.getTypeNode());
            this.p(" ");
        }
        this.accept(x.getName());
        if (x.getFunctionParameters() != null) {
            this.p("(");
            this.printSeparatedByComma(x.getFunctionParameters());
            this.p(")");
        }
        if (x.getDefaultExpr() != null) {
            this.p(" = ");
            this.accept(x.getDefaultExpr());
        }
        return false;
    }

    @Override
    public boolean visit(DartMethodDefinition x, DartContext ctx) {
        List<DartInitializer> inits;
        this.nl();
        this.pMethodModifiers(x);
        DartFunction func = x.getFunction();
        if (func.getReturnTypeNode() != null) {
            this.accept(func.getReturnTypeNode());
            this.p(" ");
        }
        if (x.getModifiers().isOperator()) {
            this.p("operator ");
        } else if (x.getModifiers().isGetter()) {
            this.p("get ");
        } else if (x.getModifiers().isSetter()) {
            this.p("set ");
        }
        this.pFunctionDeclaration((DartNode)x.getName(), func);
        this.p(" ");
        if (!this.isDiet && !(inits = x.getInitializers()).isEmpty()) {
            this.p(": ");
            for (int i = 0; i < inits.size(); ++i) {
                this.accept((DartVisitable)inits.get(i));
                if (i >= inits.size() - 1) continue;
                this.p(", ");
            }
        }
        if (x.getFunction().getBody() != null) {
            this.accept(x.getFunction().getBody());
        } else {
            if (this.isDiet && x.getModifiers().isRedirectedConstructor() && !x.getModifiers().isConstant()) {
                this.p("{ }");
            } else {
                this.p(";");
            }
            this.nl();
        }
        return false;
    }

    @Override
    public boolean visit(DartInitializer x, DartContext ctx) {
        if (!x.isInvocation()) {
            this.p("this.");
            this.p(x.getInitializerName());
            this.p(" = ");
        }
        this.accept(x.getValue());
        return false;
    }

    private void pBlock(DartBlock x, boolean newline) {
        this.p("{");
        this.nl();
        this.indent();
        this.acceptList(x.getStatements());
        this.outdent();
        this.p("}");
        if (newline) {
            this.nl();
        }
    }

    private void pFunctionDeclaration(DartNode name, DartFunction x) {
        if (name != null) {
            this.accept(name);
        }
        this.p("(");
        this.pFormalParameters(x.getParams());
        this.p(")");
    }

    private void pFormalParameters(List<DartParameter> params) {
        boolean first = true;
        boolean hasNamed = false;
        for (DartParameter param : params) {
            if (!first) {
                this.p(", ");
            }
            if (!hasNamed && param.getModifiers().isNamed()) {
                hasNamed = true;
                this.p("[");
            }
            this.accept(param);
            first = false;
        }
        if (hasNamed) {
            this.p("]");
        }
    }

    @Override
    public boolean visit(DartBlock x, DartContext ctx) {
        if (this.isDiet) {
            this.p("{ }");
            this.nl();
            return false;
        }
        this.pBlock(x, true);
        return false;
    }

    @Override
    public boolean visit(DartAssertion x, DartContext ctx) {
        this.p("assert(");
        this.accept(x.getExpression());
        this.p(");");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartIfStatement x, DartContext ctx) {
        this.p("if (");
        this.accept(x.getCondition());
        this.p(") ");
        this.pIfBlock(x.getThenStatement(), x.getElseStatement() == null);
        if (x.getElseStatement() != null) {
            this.p(" else ");
            this.pIfBlock(x.getElseStatement(), true);
        }
        return false;
    }

    @Override
    public boolean visit(DartSwitchStatement x, DartContext ctx) {
        this.p("switch (");
        this.accept(x.getExpression());
        this.p(") {");
        this.nl();
        this.indent();
        this.acceptList(x.getMembers());
        this.outdent();
        this.p("}");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartCase x, DartContext ctx) {
        this.p("case ");
        this.accept(x.getExpr());
        this.p(":");
        this.nl();
        this.indent();
        this.acceptList(x.getStatements());
        this.outdent();
        return false;
    }

    @Override
    public boolean visit(DartDefault x, DartContext ctx) {
        this.p("default:");
        this.nl();
        this.indent();
        this.acceptList(x.getStatements());
        this.outdent();
        return false;
    }

    @Override
    public boolean visit(DartWhileStatement x, DartContext ctx) {
        this.p("while (");
        this.accept(x.getCondition());
        this.p(") ");
        this.pIfBlock(x.getBody(), true);
        return false;
    }

    @Override
    public boolean visit(DartDoWhileStatement x, DartContext ctx) {
        this.p("do ");
        this.pIfBlock(x.getBody(), false);
        this.p(" while (");
        this.accept(x.getCondition());
        this.p(");");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartForStatement x, DartContext ctx) {
        this.p("for (");
        DartStatement setup = x.getInit();
        if (setup != null) {
            if (setup instanceof DartVariableStatement) {
                this.p("var ");
                this.printSeparatedByComma(((DartVariableStatement)setup).getVariables());
            } else {
                assert (setup instanceof DartExprStmt);
                this.accept(((DartExprStmt)setup).getExpression());
            }
        }
        this.p("; ");
        if (x.getCondition() != null) {
            this.accept(x.getCondition());
        }
        this.p("; ");
        if (x.getIncrement() != null) {
            this.accept(x.getIncrement());
        }
        this.p(") ");
        this.accept(x.getBody());
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartForInStatement x, DartContext ctx) {
        this.p("for (");
        if (x.introducesVariable()) {
            DartTypeNode type = x.getVariableStatement().getTypeNode();
            if (type != null) {
                this.accept(type);
                this.p(" ");
            } else {
                this.p("var ");
            }
            this.printSeparatedByComma(x.getVariableStatement().getVariables());
        } else {
            this.accept(x.getIdentifier());
        }
        this.p(" in ");
        this.accept(x.getIterable());
        this.p(") ");
        this.accept(x.getBody());
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartContinueStatement x, DartContext ctx) {
        this.p("continue");
        if (x.getTargetName() != null) {
            this.p(" " + x.getTargetName());
        }
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartBreakStatement x, DartContext ctx) {
        this.p("break");
        if (x.getTargetName() != null) {
            this.p(" " + x.getTargetName());
        }
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartReturnStatement x, DartContext ctx) {
        this.p("return");
        if (x.getValue() != null) {
            this.p(" ");
            this.accept(x.getValue());
        }
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartTryStatement x, DartContext ctx) {
        this.p("try ");
        this.accept(x.getTryBlock());
        this.acceptList(x.getCatchBlocks());
        if (x.getFinallyBlock() != null) {
            this.p("finally ");
            this.accept(x.getFinallyBlock());
        }
        return false;
    }

    private void visitCatchParameter(DartParameter x) {
        if (!x.getModifiers().isFinal() && x.getTypeNode() == null) {
            this.p("var ");
        }
        this.accept(x);
    }

    @Override
    public boolean visit(DartCatchBlock x, DartContext ctx) {
        this.p("catch (");
        this.visitCatchParameter(x.getException());
        if (x.getStackTrace() != null) {
            this.p(", ");
            this.visitCatchParameter(x.getStackTrace());
        }
        this.p(") ");
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(DartThrowStatement x, DartContext ctx) {
        this.p("throw");
        if (x.getException() != null) {
            this.p(" ");
            this.accept(x.getException());
        }
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartVariableStatement x, DartContext ctx) {
        if (x.getTypeNode() != null) {
            this.accept(x.getTypeNode());
            this.p(" ");
        } else {
            this.p("var ");
        }
        this.printSeparatedByComma(x.getVariables());
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartVariable x, DartContext ctx) {
        this.accept(x.getName());
        if (x.getValue() != null) {
            this.p(" = ");
            this.accept(x.getValue());
        }
        return false;
    }

    @Override
    public boolean visit(DartEmptyStatement x, DartContext ctx) {
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartLabel x, DartContext ctx) {
        this.p(x.getName());
        this.p(": ");
        this.accept(x.getStatement());
        return false;
    }

    @Override
    public boolean visit(DartExprStmt x, DartContext ctx) {
        this.accept(x.getExpression());
        this.p(";");
        this.nl();
        return false;
    }

    @Override
    public boolean visit(DartBinaryExpression x, DartContext ctx) {
        this.accept(x.getArg1());
        this.p(" ");
        this.p(x.getOperator().getSyntax());
        this.p(" ");
        this.accept(x.getArg2());
        return false;
    }

    @Override
    public boolean visit(DartConditional x, DartContext ctx) {
        this.accept(x.getCondition());
        this.p(" ? ");
        this.accept(x.getThenExpression());
        this.p(" : ");
        this.accept(x.getElseExpression());
        return false;
    }

    @Override
    public boolean visit(DartUnaryExpression x, DartContext ctx) {
        if (x.isPrefix()) {
            this.p(x.getOperator().getSyntax());
        }
        this.accept(x.getArg());
        if (!x.isPrefix()) {
            this.p(x.getOperator().getSyntax());
        }
        return false;
    }

    @Override
    public boolean visit(DartPropertyAccess x, DartContext ctx) {
        this.accept(x.getQualifier());
        this.p(".");
        this.p(x.getPropertyName());
        return false;
    }

    @Override
    public boolean visit(DartArrayAccess x, DartContext ctx) {
        this.accept(x.getTarget());
        this.p("[");
        this.accept(x.getKey());
        this.p("]");
        return false;
    }

    private void pArgs(List<? extends DartNode> args) {
        this.p("(");
        this.printSeparatedByComma(args);
        this.p(")");
    }

    @Override
    public boolean visit(DartUnqualifiedInvocation x, DartContext ctx) {
        this.accept(x.getTarget());
        this.pArgs(x.getArgs());
        return false;
    }

    @Override
    public boolean visit(DartFunctionObjectInvocation x, DartContext ctx) {
        this.accept(x.getTarget());
        this.pArgs(x.getArgs());
        return false;
    }

    @Override
    public boolean visit(DartMethodInvocation x, DartContext ctx) {
        this.accept(x.getTarget());
        this.p(".");
        this.accept(x.getFunctionName());
        this.pArgs(x.getArgs());
        return false;
    }

    @Override
    public boolean visit(DartSyntheticErrorExpression node, DartContext ctx) {
        this.p("[error: " + node.getTokenString() + "]");
        return false;
    }

    @Override
    public boolean visit(DartSyntheticErrorStatement node, DartContext ctx) {
        this.p("[error: " + node.getTokenString() + "]");
        return false;
    }

    @Override
    public boolean visit(DartThisExpression x, DartContext ctx) {
        this.p("this");
        return false;
    }

    @Override
    public boolean visit(DartSuperExpression x, DartContext ctx) {
        this.p("super");
        return false;
    }

    @Override
    public boolean visit(DartSuperConstructorInvocation x, DartContext ctx) {
        this.p("super");
        if (x.getName() != null) {
            this.p(".");
            this.accept(x.getName());
        }
        this.pArgs(x.getArgs());
        return false;
    }

    @Override
    public boolean visit(DartNewExpression x, DartContext ctx) {
        this.p("new ");
        this.accept(x.getConstructor());
        this.pArgs(x.getArgs());
        return false;
    }

    @Override
    public boolean visit(DartFunctionExpression x, DartContext ctx) {
        DartFunction func = x.getFunction();
        if (func.getReturnTypeNode() != null) {
            this.accept(func.getReturnTypeNode());
            this.p(" ");
        }
        DartIdentifier name = x.getName();
        this.pFunctionDeclaration(name, x.getFunction());
        this.p(" ");
        if (x.getFunction().getBody() != null) {
            this.pBlock(x.getFunction().getBody(), false);
        }
        return false;
    }

    @Override
    public boolean visit(DartIdentifier x, DartContext ctx) {
        this.p(x.getTargetName());
        return false;
    }

    @Override
    public boolean visit(DartNullLiteral x, DartContext ctx) {
        this.p("null");
        return false;
    }

    @Override
    public boolean visit(DartRedirectConstructorInvocation x, DartContext ctx) {
        this.p("this");
        if (x.getName() != null) {
            this.p(".");
            this.accept(x.getName());
        }
        this.pArgs(x.getArgs());
        return false;
    }

    @Override
    public boolean visit(DartStringLiteral x, DartContext ctx) {
        this.p("\"");
        String escaped = x.getValue().replaceAll("\\\\", "\\\\\\\\");
        escaped = escaped.replaceAll("\"", "\\\\\"");
        escaped = escaped.replaceAll("'", "\\\\'");
        escaped = escaped.replaceAll("\\n", "\\\\n");
        escaped = escaped.replaceAll("\\$", "\\\\\\$");
        this.p(escaped);
        this.p("\"");
        return false;
    }

    @Override
    public boolean visit(DartStringInterpolation x, DartContext ctx) {
        this.p("\"");
        Iterator<DartExpression> eIter = x.getExpressions().iterator();
        boolean first = true;
        for (DartStringLiteral lit : x.getStrings()) {
            if (first) {
                first = false;
            } else {
                this.p("${");
                assert (eIter.hasNext()) : "DartStringInterpolation invariant broken.";
                this.accept((DartVisitable)eIter.next());
                this.p("}");
            }
            this.p(lit.getValue().replaceAll("\"", "\\\""));
        }
        this.p("\"");
        return false;
    }

    @Override
    public boolean visit(DartBooleanLiteral x, DartContext ctx) {
        this.p(Boolean.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(DartIntegerLiteral x, DartContext ctx) {
        this.p(x.getValue().toString());
        return false;
    }

    @Override
    public boolean visit(DartDoubleLiteral x, DartContext ctx) {
        this.p(Double.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(DartArrayLiteral x, DartContext ctx) {
        this.p("[");
        this.printSeparatedByComma(x.getExpressions());
        this.p("]");
        return false;
    }

    @Override
    public boolean visit(DartMapLiteral x, DartContext ctx) {
        this.p("{");
        List<DartMapLiteralEntry> entries = x.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            DartMapLiteralEntry entry = entries.get(i);
            this.accept(entry);
            if (i >= entries.size() - 1) continue;
            this.p(", ");
        }
        this.p("}");
        return false;
    }

    @Override
    public boolean visit(DartMapLiteralEntry x, DartContext ctx) {
        this.accept(x.getKey());
        this.p(" : ");
        this.accept(x.getValue());
        return false;
    }

    @Override
    public boolean visit(DartParameterizedTypeNode x, DartContext ctx) {
        this.accept(x.getExpression());
        if (!x.getTypeParameters().isEmpty()) {
            this.p("<");
            this.printSeparatedByComma(x.getTypeParameters());
            this.p(">");
        }
        return false;
    }

    @Override
    public boolean visit(DartParenthesizedExpression x, DartContext ctx) {
        this.p("(");
        this.accept(x.getExpression());
        this.p(")");
        return false;
    }

    @Override
    public boolean visit(DartNamedExpression x, DartContext ctx) {
        this.accept(x.getName());
        this.p(":");
        this.accept(x.getExpression());
        return false;
    }

    private void pAbstractField(DartFieldDefinition x, DartContext ctx) {
        this.accept(x.getFields().get(0).getAccessor());
    }

    private void pIfBlock(DartStatement stmt, boolean newline) {
        if (stmt instanceof DartBlock) {
            this.pBlock((DartBlock)stmt, newline);
        } else {
            this.p("{");
            this.nl();
            this.indent();
            this.accept(stmt);
            this.outdent();
            this.p("}");
            if (newline) {
                this.nl();
            }
        }
    }

    private void printSeparatedByComma(List<? extends DartNode> nodes) {
        boolean first = true;
        for (DartNode dartNode : nodes) {
            if (!first) {
                this.p(", ");
            }
            this.accept(dartNode);
            first = false;
        }
    }

    private void pFieldModifiers(DartFieldDefinition field) {
        Modifiers modifiers = field.getFields().get(0).getModifiers();
        if (modifiers.isStatic()) {
            this.p("static ");
        }
        if (modifiers.isFinal()) {
            this.p("final ");
        }
    }

    private void pMethodModifiers(DartMethodDefinition method) {
        if (method.getModifiers().isConstant()) {
            this.p("const ");
        }
        if (method.getModifiers().isStatic()) {
            this.p("static ");
        }
        if (method.getModifiers().isAbstract()) {
            this.p("abstract ");
        }
        if (method.getModifiers().isFactory()) {
            this.p("factory ");
        }
    }

    private void p(String x) {
        this.out.print(x);
    }

    private void nl() {
        this.out.newline();
    }

    private void indent() {
        this.out.indentIn();
    }

    private void outdent() {
        this.out.indentOut();
    }
}

