/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartInvocation;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.common.HasSymbol;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.ConstructorElement;
import java.util.List;

public class DartSuperConstructorInvocation
extends DartInvocation
implements HasSymbol {
    private DartIdentifier name;
    private ConstructorElement symbol;

    public DartSuperConstructorInvocation(DartIdentifier name, List<DartExpression> args) {
        super(args);
        this.name = this.becomeParentOf(name);
    }

    public String getConstructorName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getTargetName();
    }

    public DartIdentifier getName() {
        return this.name;
    }

    public void setName(DartIdentifier newName) {
        this.name = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.symbol = (ConstructorElement)symbol;
    }

    @Override
    public ConstructorElement getSymbol() {
        return this.symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.name != null) {
                this.name = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.name));
            }
            v.acceptWithInsertRemove(this, this.getArgs());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.name != null) {
            this.name.accept(visitor);
        }
        visitor.visit(this.getArgs());
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitSuperConstructorInvocation(this);
    }
}

