/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartLiteral;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartVisitor;
import java.util.List;

public class DartStringInterpolation
extends DartLiteral {
    private List<DartStringLiteral> strings;
    private List<DartExpression> expressions;

    public DartStringInterpolation(List<DartStringLiteral> strings, List<DartExpression> expressions) {
        Preconditions.checkNotNull(strings);
        Preconditions.checkNotNull(expressions);
        Preconditions.checkArgument((strings.size() == expressions.size() + 1 ? 1 : 0) != 0);
        this.strings = this.becomeParentOf(strings);
        this.expressions = this.becomeParentOf(expressions);
    }

    public List<DartStringLiteral> getStrings() {
        return this.strings;
    }

    public List<DartExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this, this.strings);
            v.acceptWithInsertRemove(this, this.expressions);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        visitor.visit(this.strings);
        visitor.visit(this.expressions);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitStringInterpolation(this);
    }
}

