/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.type.Type;
import java.util.Collections;
import java.util.List;

public class DartParameterizedTypeNode
extends DartExpression {
    private DartExpression expression;
    private List<DartTypeParameter> typeParameters;
    private Type type;

    public DartParameterizedTypeNode(DartExpression expression, List<DartTypeParameter> typeParameters) {
        this.setExpression(expression);
        this.setTypeParameters(typeParameters);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitParameterizedTypeNode(this);
    }

    public DartExpression getExpression() {
        return this.expression;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public List<DartTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setExpression(DartExpression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    public void setTypeParameters(List<DartTypeParameter> typeParameters) {
        if (typeParameters == null) {
            typeParameters = Collections.emptyList();
        }
        this.typeParameters = this.becomeParentOf(typeParameters);
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.setExpression(v.accept(this.getExpression()));
            this.setTypeParameters(v.acceptWithInsertRemove(this, this.getTypeParameters()));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.getExpression().accept(visitor);
        visitor.visit(this.getTypeParameters());
    }
}

