/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartToSourceVisitor;
import com.google.dart.compiler.ast.DartVisitable;
import com.google.dart.compiler.common.AbstractNode;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.Types;
import com.google.dart.compiler.util.DefaultTextOutput;
import java.util.List;

public abstract class DartNode
extends AbstractNode
implements DartVisitable {
    private DartNode parent;
    private boolean isInstrumentedNode;

    public final String toSource() {
        DefaultTextOutput out = new DefaultTextOutput(false);
        new DartToSourceVisitor(out).accept(this);
        return out.toString();
    }

    public Symbol getSymbol() {
        return null;
    }

    public void setSymbol(Symbol symbol) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public void setType(Type type) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public DartNode getNormalizedNode() {
        return this;
    }

    public Type getType() {
        return Types.newDynamicType();
    }

    public final String toString() {
        return this.toSource();
    }

    public final DartNode getParent() {
        return this.parent;
    }

    public final DartNode getRoot() {
        DartNode root = this;
        DartNode parent = this.getParent();
        while (parent != null) {
            root = parent;
            parent = root.getParent();
        }
        return root;
    }

    @Deprecated
    public int getLength() {
        return this.getSourceLength();
    }

    @Deprecated
    public int getStartPosition() {
        return this.getSourceStart();
    }

    protected <T extends DartNode> T becomeParentOf(T child) {
        if (child != null) {
            T node = child;
            super.setParent(this);
        }
        return child;
    }

    protected <L extends List<? extends DartNode>> L becomeParentOf(L children) {
        if (children != null) {
            for (DartNode child : children) {
                child.setParent(this);
            }
        }
        return children;
    }

    private void setParent(DartNode newParent) {
        this.parent = newParent;
    }

    public abstract void visitChildren(DartPlainVisitor<?> var1);

    public abstract <R> R accept(DartPlainVisitor<R> var1);

    public int computeHash() {
        DefaultTextOutput out = new DefaultTextOutput(false);
        new DartToSourceVisitor(out, true).accept(this);
        return out.toString().trim().hashCode();
    }

    public DartNode clone() {
        return this;
    }

    public String getObjectIdentifier() {
        return super.toString();
    }

    public boolean isInstrumentedNode() {
        return this.isInstrumentedNode;
    }

    public void setInstrumentedNode(boolean isInstrumentedNode) {
        this.isInstrumentedNode = isInstrumentedNode;
    }
}

