/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartInvocation;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.common.HasSymbol;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.ConstructorElement;
import java.util.List;

public class DartNewExpression
extends DartInvocation
implements HasSymbol {
    private DartNode constructor;
    private ConstructorElement typeSymbol;
    private final boolean isConst;

    public DartNewExpression(DartNode constructor, List<DartExpression> args, boolean isConst) {
        super(args);
        this.constructor = this.becomeParentOf(constructor);
        this.isConst = isConst;
    }

    public DartNode getConstructor() {
        return this.constructor;
    }

    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public ConstructorElement getSymbol() {
        return this.typeSymbol;
    }

    public void setConstructor(DartExpression newConstructor) {
        this.constructor = this.becomeParentOf(newConstructor);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.typeSymbol = (ConstructorElement)symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.constructor = this.becomeParentOf(v.accept(this.constructor));
            v.acceptWithInsertRemove(this, this.getArgs());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.constructor.accept(visitor);
        visitor.visit(this.getArgs());
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitNewExpression(this);
    }
}

