/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;

public class DartNamedExpression
extends DartExpression {
    private DartIdentifier name;
    private DartExpression expression;

    public DartNamedExpression(DartIdentifier ident, DartExpression expression) {
        this.name = ident;
        this.expression = this.becomeParentOf(expression);
    }

    public DartIdentifier getName() {
        return this.name;
    }

    public DartExpression getExpression() {
        return this.expression;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.name != null) {
                this.name = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.name));
            }
            if (this.expression != null) {
                this.expression = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.expression));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.expression != null) {
            this.expression.accept(visitor);
        }
        this.expression.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitNamedExpression(this);
    }
}

