/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartVisitable;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.util.Hack;
import java.util.List;

public class DartModVisitor
extends DartVisitor {
    protected boolean didChange = false;

    protected static <T extends DartVisitable> void checkReplacement(T origNode, T newNode) {
        if (newNode == null) {
            throw new RuntimeException("Cannot replace with null");
        }
        if (newNode == origNode) {
            throw new RuntimeException("The replacement is the same as the original");
        }
    }

    @Override
    public boolean didChange() {
        return this.didChange;
    }

    @Override
    protected <T extends DartVisitable> T doAccept(T node) {
        return new NodeContext<T>().traverse(node);
    }

    @Override
    protected void doAcceptList(List<? extends DartVisitable> collection) {
        this.doAcceptListImpl(collection);
    }

    private <T extends DartVisitable> void doAcceptListImpl(List<T> collection) {
        NodeContext<DartVisitable> ctx = new NodeContext<DartVisitable>();
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            ctx.traverse((DartVisitable)collection.get(i));
            if (!((NodeContext)ctx).replaced) continue;
            collection.set(i, ((NodeContext)ctx).node);
        }
    }

    @Override
    protected DartExpression doAcceptLvalue(DartExpression expr) {
        return new LvalueContext().traverse(expr);
    }

    @Override
    protected <T extends DartVisitable> List<T> doAcceptWithInsertRemove(DartNode parent, List<T> collection) {
        ListContext<T> ctx = new ListContext<T>(parent);
        ctx.traverse(collection);
        return ((ListContext)ctx).collection;
    }

    private class NodeContext<T extends DartVisitable>
    implements DartContext {
        private T node;
        private boolean replaced;

        private NodeContext() {
        }

        @Override
        public boolean canInsert() {
            return false;
        }

        @Override
        public boolean canRemove() {
            return false;
        }

        @Override
        public void insertAfter(DartVisitable node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(DartVisitable node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceMe(DartVisitable node) {
            if (this.replaced) {
                throw new RuntimeException("Node was already replaced");
            }
            DartModVisitor.checkReplacement(this.node, node);
            this.node = (DartVisitable)Hack.cast(node);
            this.replaced = true;
            DartModVisitor.this.didChange = true;
        }

        protected T traverse(T node) {
            this.node = node;
            this.replaced = false;
            DartModVisitor.this.doTraverse((DartVisitable)node, this);
            return this.node;
        }
    }

    private class LvalueContext
    extends NodeContext<DartExpression> {
        private LvalueContext() {
        }

        @Override
        public boolean isLvalue() {
            return true;
        }
    }

    private class ListContext<T extends DartVisitable>
    implements DartContext {
        private DartNode parent;
        private List<T> collection;
        private int index;
        private boolean removed;
        private boolean replaced;

        public ListContext(DartNode parent) {
            this.parent = parent;
        }

        @Override
        public boolean canInsert() {
            return true;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public void insertAfter(DartVisitable node) {
            this.checkRemoved();
            this.parent.becomeParentOf((DartNode)node);
            this.collection.add(this.index + 1, Hack.cast(node));
            DartModVisitor.this.didChange = true;
        }

        @Override
        public void insertBefore(DartVisitable node) {
            this.checkRemoved();
            this.parent.becomeParentOf((DartNode)node);
            this.collection.add(this.index++, Hack.cast(node));
            DartModVisitor.this.didChange = true;
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            this.checkState();
            this.collection.remove(this.index--);
            this.removed = true;
            DartModVisitor.this.didChange = true;
        }

        @Override
        public void replaceMe(DartVisitable node) {
            this.checkState();
            DartModVisitor.checkReplacement((DartVisitable)this.collection.get(this.index), node);
            this.parent.becomeParentOf((DartNode)node);
            this.collection.set(this.index, Hack.cast(node));
            this.replaced = true;
            DartModVisitor.this.didChange = true;
        }

        protected void traverse(List<T> collection) {
            this.collection = collection;
            this.index = 0;
            while (this.index < collection.size()) {
                this.replaced = false;
                this.removed = false;
                DartModVisitor.this.doTraverse((DartVisitable)collection.get(this.index), this);
                ++this.index;
            }
        }

        private void checkRemoved() {
            if (this.removed) {
                throw new RuntimeException("Node was already removed");
            }
        }

        private void checkState() {
            this.checkRemoved();
            if (this.replaced) {
                throw new RuntimeException("Node was already replaced");
            }
        }
    }
}

