/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartInvocation;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.common.Symbol;
import java.util.List;

public class DartMethodInvocation
extends DartInvocation {
    private DartExpression target;
    private DartIdentifier functionName;
    private Symbol targetSymbol;

    public DartMethodInvocation(DartExpression target, DartIdentifier functionName, List<DartExpression> args) {
        super(args);
        functionName.getClass();
        this.target = this.becomeParentOf(target);
        this.functionName = this.becomeParentOf(functionName);
    }

    @Override
    public DartExpression getTarget() {
        return this.target;
    }

    public String getFunctionNameString() {
        return this.functionName.getTargetName();
    }

    public DartIdentifier getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(DartIdentifier newName) {
        newName.getClass();
        this.functionName = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.targetSymbol = symbol;
    }

    public Symbol getTargetSymbol() {
        return this.targetSymbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.target = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.target));
            this.functionName = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.functionName));
            this.functionName.getClass();
            v.acceptWithInsertRemove(this, this.getArgs());
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.target.accept(visitor);
        this.functionName.accept(visitor);
        visitor.visit(this.getArgs());
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitMethodInvocation(this);
    }
}

