/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartClassMember;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.MethodElement;
import java.util.Collections;
import java.util.List;

public class DartMethodDefinition
extends DartClassMember<DartExpression> {
    protected DartFunction function;
    private MethodElement element;
    private DartMethodDefinition normalizedNode = this;

    public static DartMethodDefinition create(DartExpression name, DartFunction function, Modifiers modifiers, List<DartInitializer> initializers) {
        if (initializers == null) {
            return new DartMethodDefinition(name, function, modifiers);
        }
        return new DartMethodWithInitializersDefinition(name, function, modifiers, initializers);
    }

    private DartMethodDefinition(DartExpression name, DartFunction function, Modifiers modifiers) {
        super(name, modifiers);
        this.function = this.becomeParentOf(function);
    }

    public DartFunction getFunction() {
        return this.function;
    }

    @Override
    public MethodElement getSymbol() {
        return this.element;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.element = (MethodElement)symbol;
    }

    public void setNormalizedNode(DartMethodDefinition normalizedNode) {
        normalizedNode.setSourceInfo(this);
        this.normalizedNode = normalizedNode;
    }

    @Override
    public DartMethodDefinition getNormalizedNode() {
        return this.normalizedNode;
    }

    public List<DartInitializer> getInitializers() {
        return Collections.emptyList();
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.function = (DartFunction)this.becomeParentOf((DartNode)v.accept(this.function));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        super.visitChildren(visitor);
        this.function.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitMethodDefinition(this);
    }

    private static class DartMethodWithInitializersDefinition
    extends DartMethodDefinition {
        private final List<DartInitializer> initializers;

        DartMethodWithInitializersDefinition(DartExpression name, DartFunction function, Modifiers modifiers, List<DartInitializer> initializers) {
            super(name, function, modifiers);
            this.initializers = this.becomeParentOf(initializers);
        }

        @Override
        public List<DartInitializer> getInitializers() {
            return this.initializers;
        }

        @Override
        public void traverse(DartVisitor v, DartContext ctx) {
            if (v.visit(this, ctx)) {
                this.function = (DartFunction)this.becomeParentOf((DartNode)v.accept(this.function));
                v.acceptWithInsertRemove(this, this.initializers);
            }
            v.endVisit(this, ctx);
        }

        @Override
        public void visitChildren(DartPlainVisitor<?> visitor) {
            super.visitChildren(visitor);
            visitor.visit(this.initializers);
        }
    }
}

