/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.common.HasSymbol;
import com.google.dart.compiler.common.Symbol;

public class DartLabel
extends DartStatement
implements HasSymbol {
    private DartIdentifier label;
    private Symbol symbol;
    private DartStatement statement;

    public DartLabel(DartIdentifier label, DartStatement statement) {
        this.label = this.becomeParentOf(label);
        this.statement = this.becomeParentOf(statement);
    }

    public DartIdentifier getLabel() {
        return this.label;
    }

    public String getName() {
        return this.label.getTargetName();
    }

    public DartStatement getStatement() {
        return this.statement;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setLabel(DartIdentifier newLabel) {
        this.label = newLabel;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.statement = (DartStatement)this.becomeParentOf((DartNode)v.accept(this.statement));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.statement != null) {
            this.statement.accept(visitor);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitLabel(this);
    }
}

