/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartVisitor;

public class DartInitializer
extends DartNode {
    private DartIdentifier name;
    private DartExpression value;

    public DartInitializer(DartIdentifier name, DartExpression value) {
        this.name = this.becomeParentOf(name);
        this.value = this.becomeParentOf(value);
    }

    public String getInitializerName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getTargetName();
    }

    public DartIdentifier getName() {
        return this.name;
    }

    public DartExpression getValue() {
        return this.value;
    }

    public boolean isInvocation() {
        return this.name == null;
    }

    public void setName(DartIdentifier newName) {
        this.name = this.becomeParentOf(newName);
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.name != null) {
                this.name = (DartIdentifier)this.becomeParentOf((DartNode)v.accept(this.name));
            }
            if (this.value != null) {
                this.value = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.value));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.value != null) {
            this.value.accept(visitor);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitInitializer(this);
    }
}

