/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartVisitor;

public class DartIfStatement
extends DartStatement {
    private DartExpression condition;
    private DartStatement thenStmt;
    private DartStatement elseStmt;

    public DartIfStatement(DartExpression condition, DartStatement thenStmt, DartStatement elseStmt) {
        this.condition = this.becomeParentOf(condition);
        this.thenStmt = this.becomeParentOf(thenStmt);
        this.elseStmt = this.becomeParentOf(elseStmt);
    }

    public DartExpression getCondition() {
        return this.condition;
    }

    public DartStatement getElseStatement() {
        return this.elseStmt;
    }

    public DartStatement getThenStatement() {
        return this.thenStmt;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.condition = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.condition));
            this.thenStmt = (DartStatement)this.becomeParentOf((DartNode)v.accept(this.thenStmt));
            if (this.elseStmt != null) {
                this.elseStmt = (DartStatement)this.becomeParentOf((DartNode)v.accept(this.elseStmt));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.condition.accept(visitor);
        this.thenStmt.accept(visitor);
        if (this.elseStmt != null) {
            this.elseStmt.accept(visitor);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitIfStatement(this);
    }
}

