/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartDeclaration;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.common.HasSymbol;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.FunctionAliasElement;
import java.util.List;

public class DartFunctionTypeAlias
extends DartDeclaration<DartIdentifier>
implements HasSymbol {
    private DartTypeNode returnTypeNode;
    private final List<DartParameter> parameters;
    private FunctionAliasElement element;
    private final List<DartTypeParameter> typeParameters;

    public DartFunctionTypeAlias(DartIdentifier name, DartTypeNode returnTypeNode, List<DartParameter> parameters, List<DartTypeParameter> typeParameters) {
        super(name);
        this.returnTypeNode = this.becomeParentOf(returnTypeNode);
        this.parameters = this.becomeParentOf(parameters);
        this.typeParameters = this.becomeParentOf(typeParameters);
    }

    public List<DartParameter> getParameters() {
        return this.parameters;
    }

    public DartTypeNode getReturnTypeNode() {
        return this.returnTypeNode;
    }

    public List<DartTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public FunctionAliasElement getSymbol() {
        return this.element;
    }

    public void setReturnTypeNode(DartTypeNode newReturnType) {
        this.returnTypeNode = this.becomeParentOf(newReturnType);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.element = (FunctionAliasElement)symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.returnTypeNode != null) {
                this.returnTypeNode = (DartTypeNode)this.becomeParentOf((DartNode)v.accept(this.returnTypeNode));
            }
            v.acceptWithInsertRemove(this, this.parameters);
            v.acceptWithInsertRemove(this, this.typeParameters);
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        if (this.returnTypeNode != null) {
            this.returnTypeNode.accept(visitor);
        }
        visitor.visit(this.parameters);
        visitor.visit(this.typeParameters);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitFunctionTypeAlias(this);
    }
}

