/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartVisitor;
import java.util.List;

public class DartFunction
extends DartNode {
    private final List<DartParameter> params;
    private DartBlock body;
    private DartTypeNode returnTypeNode;

    public DartFunction(List<DartParameter> arguments, DartBlock body, DartTypeNode returnTypeNode) {
        this.params = this.becomeParentOf(arguments);
        this.body = this.becomeParentOf(body);
        this.returnTypeNode = this.becomeParentOf(returnTypeNode);
    }

    public void addParam(DartParameter param) {
        this.params.add(param);
    }

    public DartBlock getBody() {
        return this.body;
    }

    public List<DartParameter> getParams() {
        return this.params;
    }

    public DartTypeNode getReturnTypeNode() {
        return this.returnTypeNode;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this, this.params);
            if (this.body != null) {
                this.body = (DartBlock)this.becomeParentOf((DartNode)v.accept(this.body));
            }
            if (this.returnTypeNode != null) {
                this.returnTypeNode = (DartTypeNode)this.becomeParentOf((DartNode)v.accept(this.returnTypeNode));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        visitor.visit(this.params);
        if (this.body != null) {
            this.body.accept(visitor);
        }
        if (this.returnTypeNode != null) {
            this.returnTypeNode.accept(visitor);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitFunction(this);
    }
}

