/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExprStmt;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartVisitor;

public class DartForInStatement
extends DartStatement {
    private DartStatement setup;
    private DartExpression iterable;
    private DartStatement body;
    private DartStatement normalizedNode = this;

    public DartForInStatement(DartStatement setup, DartExpression iterable, DartStatement body) {
        this.setup = this.becomeParentOf(setup);
        this.iterable = this.becomeParentOf(iterable);
        this.body = this.becomeParentOf(body);
    }

    public DartStatement getBody() {
        return this.body;
    }

    public DartExpression getIterable() {
        return this.iterable;
    }

    public void setNormalizedNode(DartStatement statement) {
        this.normalizedNode = statement;
    }

    @Override
    public DartStatement getNormalizedNode() {
        return this.normalizedNode;
    }

    public boolean introducesVariable() {
        return this.setup instanceof DartVariableStatement;
    }

    public DartIdentifier getIdentifier() {
        assert (!this.introducesVariable());
        return (DartIdentifier)((DartExprStmt)this.setup).getExpression();
    }

    public DartVariableStatement getVariableStatement() {
        assert (this.introducesVariable());
        return (DartVariableStatement)this.setup;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.setup = (DartStatement)this.becomeParentOf((DartNode)v.accept(this.setup));
            this.iterable = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.iterable));
            this.body = (DartStatement)this.becomeParentOf((DartNode)v.accept(this.body));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.setup.accept(visitor);
        this.iterable.accept(visitor);
        this.body.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitForInStatement(this);
    }
}

