/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.ast;

import com.google.dart.compiler.ast.DartClassMember;
import com.google.dart.compiler.ast.DartContext;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartVisitor;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.FieldElement;

public class DartField
extends DartClassMember<DartIdentifier> {
    private DartExpression value;
    private FieldElement element;
    private DartMethodDefinition accessor;

    public DartField(DartIdentifier name, Modifiers modifiers, DartMethodDefinition accessor, DartExpression value) {
        super(name, modifiers);
        this.accessor = this.becomeParentOf(accessor);
        this.value = this.becomeParentOf(value);
    }

    public void setValue(DartExpression value) {
        this.value = this.becomeParentOf(value);
    }

    public DartExpression getValue() {
        return this.value;
    }

    public void setAccessor(DartMethodDefinition accessor) {
        this.accessor = this.becomeParentOf(accessor);
    }

    public DartMethodDefinition getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldElement getSymbol() {
        return this.element;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.element = (FieldElement)symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.getValue() != null) {
                this.setValue(v.accept(this.getValue()));
            }
            if (this.getAccessor() != null) {
                this.setAccessor(v.accept(this.getAccessor()));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        super.visitChildren(visitor);
        if (this.getAccessor() != null) {
            this.getAccessor().accept(visitor);
        }
        if (this.getValue() != null) {
            this.getValue().accept(visitor);
        }
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitField(this);
    }

    @Override
    public int computeHash() {
        DartFieldDefinition def = (DartFieldDefinition)this.getParent();
        DartTypeNode typeNode = def.getTypeNode();
        if (typeNode == null) {
            return 0;
        }
        return typeNode.computeHash();
    }
}

